/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.dialog;

import adams.core.base.BasePassword;
import adams.gui.dialog.ApprovalDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class PasswordDialog
extends ApprovalDialog {
    private static final long serialVersionUID = -2132414163522707681L;
    protected JPasswordField m_TextPassword;
    protected JCheckBox m_CheckBoxShowPassword;

    public PasswordDialog(Dialog owner) {
        super(owner);
    }

    public PasswordDialog(Dialog owner, Dialog.ModalityType modality) {
        super(owner, modality);
    }

    public PasswordDialog(Dialog owner, String title) {
        super(owner, title);
    }

    public PasswordDialog(Dialog owner, String title, Dialog.ModalityType modality) {
        super(owner, title, modality);
    }

    public PasswordDialog(Frame owner) {
        super(owner);
    }

    public PasswordDialog(Frame owner, boolean modal) {
        super(owner, modal);
    }

    public PasswordDialog(Frame owner, String title) {
        super(owner, title);
    }

    public PasswordDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setTitle("Enter password");
        this.setDefaultCloseOperation(2);
        JPanel panel = new JPanel(new FlowLayout(0));
        this.getContentPane().add((Component)panel, "North");
        this.m_TextPassword = new JPasswordField(20);
        this.m_TextPassword.setEchoChar('*');
        this.m_TextPassword.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    PasswordDialog.this.m_Option = 0;
                    PasswordDialog.this.setVisible(false);
                } else if (e.getKeyCode() == 27) {
                    e.consume();
                    PasswordDialog.this.m_Option = 2;
                    PasswordDialog.this.setVisible(false);
                } else {
                    super.keyPressed(e);
                }
            }
        });
        JLabel label = new JLabel("Password");
        label.setLabelFor(this.m_TextPassword);
        panel.add(label);
        panel.add(this.m_TextPassword);
        panel = new JPanel(new FlowLayout(0));
        this.getContentPane().add((Component)panel, "Center");
        this.m_CheckBoxShowPassword = new JCheckBox("Show password");
        this.m_CheckBoxShowPassword.setMnemonic('S');
        this.m_CheckBoxShowPassword.setToolTipText("If checked, the password will be shown in clear text as you type it");
        this.m_CheckBoxShowPassword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PasswordDialog.this.m_CheckBoxShowPassword.isSelected()) {
                    PasswordDialog.this.m_TextPassword.setEchoChar('\u0000');
                } else {
                    PasswordDialog.this.m_TextPassword.setEchoChar('*');
                }
            }
        });
        panel.add(this.m_CheckBoxShowPassword);
        this.pack();
    }

    public void setPassword(BasePassword value) {
        this.m_TextPassword.setText(value.getValue());
    }

    public BasePassword getPassword() {
        return new BasePassword(this.m_TextPassword.getText());
    }
}

