/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.HelpProvider;
import adams.core.Utils;
import adams.core.base.BaseObject;
import adams.core.base.BaseString;
import adams.core.option.AbstractOption;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTextArea;
import adams.gui.core.BrowserHelper;
import adams.gui.core.GUIHelper;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.InlineEditorSupport;
import adams.gui.goe.MultiLineValueDialog;
import adams.gui.goe.MultiSelectionEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

public class BaseObjectEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler,
MultiSelectionEditor,
InlineEditorSupport {
    protected JTextComponent m_TextValue;
    protected JButton m_ButtonHelp;

    public static String toString(AbstractOption option, Object object) {
        return ((BaseObject)object).getValue();
    }

    protected static Class determineClass(Object obj) {
        Class<Object> result = obj.getClass();
        if (result.isArray()) {
            result = result.getComponentType();
        }
        if (result == BaseObject.class) {
            System.err.println("Falling back to BaseString class!");
            result = BaseString.class;
        }
        return result;
    }

    public static Object valueOf(AbstractOption option, String str) {
        BaseObject result;
        try {
            Class cls = BaseObjectEditor.determineClass(option.getDefaultValue());
            result = (BaseObject)cls.newInstance();
            result.setValue(str);
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public String toCustomStringRepresentation(Object obj) {
        return BaseObjectEditor.toString(null, obj);
    }

    @Override
    public Object fromCustomStringRepresentation(String str) {
        BaseObject result;
        try {
            Class<Object> cls = this.getValue().getClass();
            if (cls.isArray()) {
                cls = cls.getComponentType();
            }
            if (cls == BaseObject.class) {
                System.err.println("Falling back to BaseString class!");
                cls = BaseString.class;
            }
            result = (BaseObject)cls.newInstance();
            result.setValue(str);
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public String getJavaInitializationString() {
        String result = "new " + this.getValue().getClass().getName() + "(\"" + Utils.backQuoteChars(this.getValue().toString()) + "\")";
        return result;
    }

    protected String getStringToPaint() {
        return "" + this.getValue();
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        String val = this.getStringToPaint();
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    protected BaseObject parse(String s) {
        BaseObject result;
        try {
            result = (BaseObject)this.getValue().getClass().newInstance();
            result.setValue(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    @Override
    protected JComponent createCustomEditor() {
        this.m_TextValue = new BaseTextArea(1, 20);
        ((BaseTextArea)this.m_TextValue).setLineWrap(true);
        this.m_TextValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    BaseObjectEditor.this.acceptInput();
                } else if (e.getKeyCode() == 27) {
                    e.consume();
                    BaseObjectEditor.this.discardInput();
                } else {
                    super.keyPressed(e);
                }
            }
        });
        JPanel panelAll = new JPanel(new BorderLayout());
        JLabel label = new JLabel("Value");
        label.setDisplayedMnemonic('V');
        label.setLabelFor(this.m_TextValue);
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(label);
        panelAll.add((Component)panel, "West");
        panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
        panel.add((Component)new BaseScrollPane(this.m_TextValue), "Center");
        panelAll.add((Component)panel, "Center");
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panelAll.add((Component)panelButtons, "South");
        this.m_ButtonHelp = new JButton();
        this.m_ButtonHelp.setVisible(false);
        this.m_ButtonHelp.setToolTipText(this.getHelpDescription());
        this.m_ButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserHelper.openURL(BaseObjectEditor.this.getHelpURL());
            }
        });
        panel = new JPanel(new FlowLayout(0));
        panelAll.add((Component)panel, "East");
        panel.add(this.m_ButtonHelp);
        JButton buttonOK = new JButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseObjectEditor.this.acceptInput();
            }
        });
        panelButtons.add(buttonOK);
        JButton buttonClose = new JButton("Cancel");
        buttonClose.setMnemonic('C');
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseObjectEditor.this.discardInput();
            }
        });
        panelButtons.add(buttonClose);
        return panelAll;
    }

    protected boolean isValid(String s) {
        return ((BaseObject)this.getValue()).isValid(s);
    }

    protected boolean isUnchanged(String s) {
        return s.equals(((BaseObject)this.getValue()).getValue());
    }

    protected void acceptInput() {
        String s = this.m_TextValue.getText();
        if (this.isValid(s) && !this.isUnchanged(s)) {
            this.setValue(this.parse(s));
        }
        this.closeDialog(1);
    }

    protected void discardInput() {
        this.closeDialog(0);
    }

    @Override
    protected void initForDisplay() {
        super.initForDisplay();
        if (!this.m_TextValue.getText().equals("" + this.getValue())) {
            this.m_TextValue.setText("" + this.getValue());
        }
        this.m_TextValue.setCaretPosition(0);
        this.m_TextValue.setToolTipText(((BaseObject)this.getValue()).getTipText());
        this.m_TextValue.grabFocus();
        if (this.m_ButtonHelp != null) {
            this.m_ButtonHelp.setVisible(this.getHelpURL() != null);
            this.m_ButtonHelp.setToolTipText(this.getHelpDescription());
            if (this.getHelpIcon() != null) {
                this.m_ButtonHelp.setIcon(GUIHelper.getIcon(this.getHelpIcon()));
            } else {
                this.m_ButtonHelp.setIcon(null);
            }
            this.m_ButtonHelp.setText(this.getHelpTitle());
        }
    }

    @Override
    public Object[] getSelectedObjects(Container parent) {
        Object[] result;
        MultiLineValueDialog dialog = new MultiLineValueDialog();
        dialog.setInfoText("Enter the string representations, one per line:");
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        Class cls = BaseObjectEditor.determineClass(this.getValue());
        if (dialog.getOption() == 0) {
            Vector<String> lines = new Vector<String>(Arrays.asList(dialog.getContent().split("\n")));
            Utils.removeEmptyLines(lines);
            result = (Object[])Array.newInstance(cls, lines.size());
            for (int i = 0; i < lines.size(); ++i) {
                Array.set(result, i, this.parse(lines.get(i)));
            }
        } else {
            result = (Object[])Array.newInstance(cls, 0);
        }
        return result;
    }

    @Override
    public boolean isInlineEditingAvailable() {
        return true;
    }

    @Override
    public void setInlineValue(String value) {
        if (this.isValid(value)) {
            this.setValue(this.parse(value));
        }
    }

    @Override
    public String getInlineValue() {
        return ((BaseObject)this.getValue()).getValue();
    }

    @Override
    public boolean isInlineValueValid(String value) {
        return this.isValid(value);
    }

    @Override
    public String getHelpDescription() {
        if (this.getValue() instanceof HelpProvider) {
            return ((HelpProvider)this.getValue()).getHelpDescription();
        }
        if (this.getValue() != null) {
            return ((BaseObject)this.getValue()).getTipText();
        }
        return null;
    }
}

