/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.EnumHelper;
import adams.core.Utils;
import adams.gui.goe.MultiLineValueDialog;
import adams.gui.goe.MultiSelectionEditor;
import java.awt.Container;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Vector;

public class EnumEditor
extends PropertyEditorSupport
implements MultiSelectionEditor {
    @Override
    public String getJavaInitializationString() {
        String result = "Enum.valueOf(" + this.getValue().getClass().getSimpleName() + ", " + this.getValue().toString() + ")";
        return result;
    }

    @Override
    public String getAsText() {
        return this.getValue().toString();
    }

    @Override
    public void setAsText(String text) {
        this.setValue(EnumHelper.parse(this.getValue().getClass(), text));
    }

    @Override
    public String[] getTags() {
        Object[] values = EnumHelper.getValues(this.getValue());
        String[] result = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i].toString();
        }
        return result;
    }

    @Override
    public Object[] getSelectedObjects(Container parent) {
        Object[] result;
        MultiLineValueDialog dialog = new MultiLineValueDialog();
        dialog.setInfoText("Enter the string representations, one per line:");
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        Class cls = EnumHelper.determineClass(this.getValue());
        if (dialog.getOption() == 0) {
            Vector<String> lines = new Vector<String>(Arrays.asList(dialog.getContent().split("\n")));
            Utils.removeEmptyLines(lines);
            result = (Object[])Array.newInstance(cls, lines.size());
            for (int i = 0; i < lines.size(); ++i) {
                Array.set(result, i, EnumHelper.parse(cls, lines.get(i)));
            }
        } else {
            result = (Object[])Array.newInstance(cls, 0);
        }
        return result;
    }
}

