/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe.actorpathtree;

import adams.gui.core.BaseTreeNode;
import adams.gui.core.dotnotationtree.DotNotationTree;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.Tree;
import adams.gui.goe.actorpathtree.ActorPathNode;
import adams.gui.goe.actorpathtree.ActorPathTreeRenderer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class ActorPathTree<T extends ActorPathNode>
extends DotNotationTree<T> {
    private static final long serialVersionUID = 6343911349519910301L;
    protected Tree m_FlowTree;

    public ActorPathTree() {
        this.setSorted(true);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FlowTree = null;
    }

    public void setFlowTree(Tree value) {
        this.m_FlowTree = value;
    }

    public Tree getFlowTree() {
        return this.m_FlowTree;
    }

    @Override
    protected TreeCellRenderer getDefaultRenderer() {
        return new ActorPathTreeRenderer();
    }

    protected String maskEscapedDots(String s) {
        return s.replace("\\.", "\t");
    }

    protected String unmaskEscapedDots(String s) {
        return s.replace("\t", "\\.");
    }

    @Override
    public void setItems(List<String> items) {
        ArrayList<String> masked = new ArrayList<String>();
        for (String item : items) {
            masked.add(this.maskEscapedDots(item));
        }
        super.setItems(masked);
    }

    @Override
    public boolean hasItem(String item) {
        return super.hasItem(this.maskEscapedDots(item));
    }

    @Override
    public void addItem(String item) {
        super.addItem(this.maskEscapedDots(item));
    }

    @Override
    public String getFirstItem() {
        return this.unmaskEscapedDots(super.getFirstItem());
    }

    @Override
    public void setSelectedItem(String item) {
        super.setSelectedItem(this.maskEscapedDots(item));
    }

    @Override
    protected String getRootNodeLabel() {
        return null;
    }

    protected T newNodeInstance(String label) {
        return (T)new ActorPathNode(label);
    }

    @Override
    protected T newNode(String label) {
        Node node;
        String classname = null;
        if (this.m_FlowTree != null && (node = this.m_FlowTree.locate(label)) != null) {
            classname = node.getActor().getClass().getName();
        }
        T result = this.newNodeInstance(label);
        if (classname != null) {
            ((ActorPathNode)result).setClassname(this.checkClassname(result, classname));
            ((ActorPathNode)result).setIconClassname(this.checkIconClassname(result, classname));
        }
        return result;
    }

    protected String checkIconClassname(T node, String classname) {
        return classname;
    }

    protected String checkClassname(T node, String classname) {
        return classname;
    }

    @Override
    protected void postAddLeaf(T node, String item) {
        String classname = null;
        if (this.m_FlowTree != null) {
            Node located = this.m_FlowTree.locate(item);
            if (located != null) {
                classname = located.getActor().getClass().getName();
            }
            if (classname != null) {
                ((ActorPathNode)node).setIconClassname(this.checkIconClassname(node, classname));
                ((ActorPathNode)node).setClassname(this.checkClassname(node, classname));
            }
        }
        super.postAddLeaf(node, item);
    }

    public ActorPathNode findNodeByName(String name) {
        BaseTreeNode node;
        ActorPathNode result = null;
        if (name != null && name.length() > 0 && (node = (BaseTreeNode)this.getTreeModel().getRoot()) != null) {
            Enumeration<TreeNode> enm = node.breadthFirstEnumeration();
            while (enm.hasMoreElements()) {
                ActorPathNode child;
                node = (BaseTreeNode)enm.nextElement();
                if (!(node instanceof ActorPathNode) || !(child = (ActorPathNode)node).hasClassname() || !child.isLabelMatch(name)) continue;
                result = child;
                break;
            }
        }
        return result;
    }

    public void selectNodeByName(String name) {
        ActorPathNode node = this.findNodeByName(name);
        if (node != null) {
            TreePath path = new TreePath(node.getPath());
            this.setSelectionPath(path);
        }
    }
}

