/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe.actorpathtree;

import adams.gui.core.GUIHelper;
import adams.gui.core.dotnotationtree.DotNotationRenderer;
import adams.gui.goe.actorpathtree.ActorPathNode;
import java.util.Hashtable;
import javax.swing.Icon;

public class ActorPathTreeRenderer
extends DotNotationRenderer<ActorPathNode> {
    private static final long serialVersionUID = -800697802084012705L;
    protected Hashtable<String, Icon> m_Icons;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Icons = new Hashtable();
    }

    @Override
    protected Icon getIcon(ActorPathNode node) {
        Icon result = null;
        String classname = node.hasClassname() ? node.getClassname() : node.getIconClassname();
        if (classname != null) {
            if (this.m_Icons.containsKey(classname)) {
                result = this.m_Icons.get(classname);
            } else {
                try {
                    result = GUIHelper.getIcon(Class.forName(classname));
                    this.m_Icons.put(classname, result);
                }
                catch (Exception e) {
                    result = null;
                }
            }
        }
        return result;
    }
}

