/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe.classtree;

import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTreeNode;
import adams.gui.core.DragAndDropTreeNodeCollection;
import adams.gui.core.dotnotationtree.DotNotationTree;
import adams.gui.goe.classtree.ClassNode;
import adams.gui.goe.classtree.ClassTreeNodeCollection;
import adams.gui.goe.classtree.ClassTreeRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ClassTree
extends DotNotationTree<ClassNode> {
    private static final long serialVersionUID = 1489354474021395304L;

    public ClassTree() {
        this.setSorted(true);
    }

    @Override
    protected TreeCellRenderer getDefaultRenderer() {
        return new ClassTreeRenderer();
    }

    @Override
    protected ClassNode newNode(String label) {
        return new ClassNode(label);
    }

    @Override
    protected DragAndDropTreeNodeCollection newNodeCollection(BaseTreeNode[] nodes) {
        ClassNode[] cnodes = new ClassNode[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            cnodes[i] = (ClassNode)nodes[i];
        }
        return new ClassTreeNodeCollection(cnodes);
    }

    @Override
    protected void expandAfterSearch() {
        Object root = this.getModel().getRoot();
        if (root != null) {
            this.expandAllAfterSearch(new TreePath((TreeNode)root));
        }
    }

    protected void expandAllAfterSearch(TreePath parent) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                if (!(n instanceof ClassNode) || ((ClassNode)n).isItemLeaf()) continue;
                TreePath path = parent.pathByAddingChild(n);
                this.expandAllAfterSearch(path);
            }
        }
        this.expandPath(parent);
    }

    public static void main(String[] args) {
        Vector<String> classes = new Vector<String>();
        classes.add("weka.classifiers.trees.J48");
        classes.add("weka.classifiers.rules.ZeroR");
        classes.add("dummy.classifiers.trees.MyJ48");
        final ClassTree tree = new ClassTree();
        tree.setItems(classes);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                System.out.println(tree.getSelectedItem());
            }
        });
        final JTextField search = new JTextField();
        search.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                tree.setSearch(search.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                tree.setSearch(search.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                tree.setSearch(search.getText());
            }
        });
        JFrame frame = new JFrame("Class tree");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)new BaseScrollPane(tree), "Center");
        frame.getContentPane().add((Component)search, "South");
        frame.setSize(640, 480);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        tree.setSelectedItem("weka.classifiers.rules.ZeroR");
    }
}

