/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.menu;

import adams.core.io.PlaceholderDirectory;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.AbstractMenuItemDefinition;
import adams.gui.application.UserMode;
import adams.gui.chooser.BaseDirectoryChooser;
import adams.gui.core.GUIHelper;
import adams.gui.core.SearchPanel;
import adams.gui.core.SortableAndSearchableTable;
import adams.gui.core.SortableAndSearchableTableWithButtons;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import adams.gui.menu.FlowEditor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ActorUsage
extends AbstractMenuItemDefinition {
    private static final long serialVersionUID = -6548349613973153076L;

    public ActorUsage(AbstractApplicationFrame owner) {
        super(owner);
    }

    @Override
    public String getTitle() {
        return "Actor usage";
    }

    @Override
    public String getIconName() {
        return "adams.flow.transformer.SetVariable.gif";
    }

    @Override
    public UserMode getUserMode() {
        return UserMode.BASIC;
    }

    @Override
    public String getCategory() {
        return "Help";
    }

    protected PlaceholderDirectory chooseDir() {
        PlaceholderDirectory result = null;
        BaseDirectoryChooser chooser = new BaseDirectoryChooser(new File("."));
        chooser.setDialogTitle("Choose directory with flows");
        int retVal = chooser.showOpenDialog(null);
        if (retVal == 0) {
            result = chooser.getSelectedDirectory();
        }
        return result;
    }

    protected SpreadSheet determineUsage(PlaceholderDirectory dir) {
        adams.flow.core.ActorUsage usage = new adams.flow.core.ActorUsage();
        usage.setRecursive(true);
        usage.setDirectories(new PlaceholderDirectory[]{dir});
        SpreadSheet result = usage.execute();
        return result;
    }

    protected void displayUsage(SpreadSheet sheet) {
        SpreadSheetTableModel model = new SpreadSheetTableModel(sheet);
        model.setUseSimpleHeader(true);
        model.setShowRowColumn(false);
        final SortableAndSearchableTableWithButtons table = new SortableAndSearchableTableWithButtons(model);
        table.setAutoResizeMode(0);
        table.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        SearchPanel search = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
        search.addSearchListener(new SearchListener(){

            @Override
            public void searchInitiated(SearchEvent e) {
                table.search(e.getParameters().getSearchString(), e.getParameters().isRegExp());
            }
        });
        table.add((Component)search, "South");
        final JButton editFlow = new JButton("Edit");
        editFlow.setMnemonic('E');
        editFlow.setToolTipText("Opens the selected flows with the Flow editor");
        editFlow.setEnabled(false);
        editFlow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indices = table.getSelectedRows();
                ArrayList<String> flows = new ArrayList<String>();
                for (int i = 0; i < indices.length; ++i) {
                    String flow = (String)table.getModel().getValueAt(indices[i], 2);
                    if (flow.length() <= 1) continue;
                    flows.add(flow);
                }
                FlowEditor editor = new FlowEditor();
                editor.setOwner(ActorUsage.this.getOwner());
                editor.setAdditionalParameters(flows.toArray(new String[flows.size()]));
                editor.launch();
            }
        });
        table.addToButtonsPanel(editFlow);
        table.setDoubleClickButton(editFlow);
        ((SortableAndSearchableTable)table.getComponent()).getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                editFlow.setEnabled(table.getSelectedRowCount() > 0);
            }
        });
        this.createChildFrame(table, 800, 600);
        table.setOptimalColumnWidth();
    }

    @Override
    public void launch() {
        PlaceholderDirectory dir = this.chooseDir();
        if (dir == null) {
            GUIHelper.showErrorMessage(null, "Canceled selection of flow directory!");
            return;
        }
        SpreadSheet sheet = this.determineUsage(dir);
        if (sheet == null) {
            GUIHelper.showErrorMessage(null, "Failed to generate overview!");
            return;
        }
        this.displayUsage(sheet);
    }

    @Override
    public boolean isSingleton() {
        return false;
    }
}

