/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.scripting;

import adams.core.Utils;
import adams.gui.scripting.AbstractCommandProcessor;
import adams.gui.scripting.AbstractScriptingEngine;
import adams.gui.scripting.ScriptingCommand;
import adams.gui.scripting.ScriptingCommandCode;
import adams.gui.scripting.ScriptingLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ScriptingEngineThread
extends Thread {
    protected AbstractScriptingEngine m_Owner;
    protected LinkedBlockingQueue<ScriptingCommand> m_Commands;
    protected boolean m_Running;
    protected boolean m_Processing;

    public ScriptingEngineThread(AbstractScriptingEngine owner) {
        this.m_Owner = owner;
        this.m_Commands = new LinkedBlockingQueue();
        this.m_Running = true;
        this.m_Processing = false;
    }

    public AbstractScriptingEngine getOwner() {
        return this.m_Owner;
    }

    public void clear() {
        this.m_Commands.clear();
    }

    public void add(ScriptingCommand cmd) {
        this.m_Commands.add(cmd);
    }

    public void stopExecution() {
        this.m_Running = false;
    }

    public boolean isRunning() {
        return this.m_Running;
    }

    public boolean isProcessing() {
        return this.m_Processing;
    }

    public synchronized boolean isEmpty() {
        return this.m_Commands.isEmpty();
    }

    protected void preProcess(ScriptingCommand cmd) {
        this.getOwner().notifyScriptingInfoListeners(cmd.getCommand());
        this.getOwner().getLogger().info(cmd.getCommand());
    }

    protected String doProcess(ScriptingCommand cmd) throws Exception {
        String result;
        AbstractCommandProcessor processor = this.getOwner().getProcessor();
        String output = processor.process(cmd);
        if (output != null) {
            result = "Problem encountered processing the following command:\n" + Utils.insertLineBreaks(cmd.getCommand(), 80) + "\n\nEncountered error:\n" + output;
            this.getOwner().setLastError(result);
            this.getOwner().getLogger().severe(result);
        } else {
            result = null;
            this.getOwner().addToHistory(cmd.getCommand());
        }
        return result;
    }

    protected void postProcess(ScriptingCommand cmd, boolean success, String lastError) {
        ScriptingLogger.getSingleton().log(this.getOwner(), cmd, success, lastError);
    }

    @Override
    public void run() {
        while (this.m_Running) {
            try {
                boolean success;
                String lastError;
                ScriptingCommand command = this.m_Commands.poll(100L, TimeUnit.MILLISECONDS);
                if (command == null || !this.m_Running || !AbstractScriptingEngine.check(command.getCommand())) continue;
                this.m_Processing = true;
                this.preProcess(command);
                try {
                    lastError = this.doProcess(command);
                    success = lastError == null;
                }
                catch (Exception e) {
                    success = false;
                    StringWriter writer = new StringWriter();
                    e.printStackTrace(new PrintWriter(writer));
                    lastError = "Exception encountered processing the following command:\n" + Utils.insertLineBreaks(command.getCommand(), 80) + "\n\nEncountered exception:\n" + writer.toString();
                    System.err.println(lastError);
                }
                this.postProcess(command, success, lastError);
                if (command.hasCode()) {
                    ScriptingCommandCode code = command.getCode();
                    code.setError(lastError);
                    code.execute();
                }
                this.m_Processing = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

