/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.core.io.FileUtils;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import adams.flow.sink.TextSupplier;
import adams.gui.chooser.TextFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.ConsolePanel;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.ParameterPanel;
import adams.gui.core.RecentFilesWithEncodingHandler;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.core.TitleGenerator;
import adams.gui.event.PopupMenuListener;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ConsoleOutputAnalyzerPanel
extends BasePanel
implements MenuBarProvider,
SendToActionSupporter {
    private static final long serialVersionUID = -9220648401733691034L;
    public static final String SESSION_FILE = "ConsoleOutputAnalyzerSession.props";
    protected BaseSplitPane m_SplitPane;
    protected transient TextFileChooser m_FileChooser;
    protected JTextField m_TextOrigin;
    protected JComboBox m_ComboBoxOrigin;
    protected JComboBox m_ComboBoxOriginID;
    protected JComboBox m_ComboBoxType;
    protected JTextField m_TextOutput;
    protected ParameterPanel m_PanelSearch;
    protected JButton m_ButtonSearch;
    protected JButton m_ButtonClearSearch;
    protected SpreadSheetTable m_Table;
    protected SpreadSheetTableModel m_TableModel;
    protected ConsoleOutput m_Original;
    protected File m_CurrentFile;
    protected String m_CurrentEncoding;
    protected ConsoleOutput m_Filtered;
    protected RecentFilesWithEncodingHandler<JMenu> m_RecentFilesHandler;
    protected JMenuBar m_MenuBar;
    protected JMenu m_MenuFileLoadRecent;
    protected JMenuItem m_MenuFileReload;
    protected TitleGenerator m_TitleGenerator;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Original = null;
        this.m_Filtered = null;
        this.m_CurrentFile = null;
        this.m_CurrentEncoding = null;
        this.m_RecentFilesHandler = null;
        this.m_TitleGenerator = new TitleGenerator("Console output analyzer", false);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_SplitPane = new BaseSplitPane(1);
        this.m_SplitPane.setOneTouchExpandable(true);
        this.m_SplitPane.setResizeWeight(1.0);
        this.add((Component)this.m_SplitPane, "Center");
        this.m_TableModel = new SpreadSheetTableModel();
        this.m_Table = new SpreadSheetTable(this.m_TableModel);
        this.m_SplitPane.setLeftComponent(new BaseScrollPane(this.m_Table));
        this.m_Table.addCellPopupMenuListener(new PopupMenuListener(){

            @Override
            public void showPopupMenu(MouseEvent e) {
                JPopupMenu menu = ConsoleOutputAnalyzerPanel.this.createCellPopup(e);
                if (menu != null) {
                    menu.show(ConsoleOutputAnalyzerPanel.this.m_Table, e.getX(), e.getY());
                }
            }
        });
        this.m_PanelSearch = new ParameterPanel();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.m_PanelSearch, "North");
        this.m_SplitPane.setRightComponent(panel);
        this.m_TextOrigin = new JTextField(20);
        this.m_PanelSearch.addParameter("_Origin (regexp)", this.m_TextOrigin);
        this.m_ComboBoxOrigin = new JComboBox();
        this.m_PanelSearch.addParameter("Origin (list)", this.m_ComboBoxOrigin);
        this.m_ComboBoxOriginID = new JComboBox();
        this.m_PanelSearch.addParameter("Origin _ID", this.m_ComboBoxOriginID);
        this.m_ComboBoxType = new JComboBox();
        this.m_PanelSearch.addParameter("_Type", this.m_ComboBoxType);
        this.m_TextOutput = new JTextField(20);
        this.m_PanelSearch.addParameter("Out_put", this.m_TextOutput);
        this.m_ButtonSearch = new JButton("Search");
        this.m_ButtonSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsoleOutputAnalyzerPanel.this.search();
            }
        });
        this.m_ButtonClearSearch = new JButton("Clear");
        this.m_ButtonClearSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsoleOutputAnalyzerPanel.this.clearSearch(true);
            }
        });
        panel = new JPanel(new FlowLayout(0));
        panel.add(this.m_ButtonSearch);
        panel.add(this.m_ButtonClearSearch);
        this.m_PanelSearch.addParameter("", panel);
    }

    protected JPopupMenu createCellPopup(MouseEvent e) {
        JMenuItem menuitem;
        JPopupMenu result = null;
        int row = this.m_Table.rowAtPoint(e.getPoint());
        int col = this.m_Table.columnAtPoint(e.getPoint());
        if (row == -1 || col == -1) {
            return result;
        }
        final Object value = this.m_Table.getValueAt(row, col);
        if (value == null) {
            return result;
        }
        result = new JPopupMenu();
        if (col == 1) {
            menuitem = new JMenuItem("Search for origin '" + Utils.shorten(value.toString(), 15) + "'");
            menuitem.setIcon(GUIHelper.getIcon("find.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConsoleOutputAnalyzerPanel.this.clearSearch(false);
                    ConsoleOutputAnalyzerPanel.this.m_ComboBoxOrigin.setSelectedItem(value.toString());
                    ConsoleOutputAnalyzerPanel.this.search();
                }
            });
            result.add(menuitem);
        } else if (col == 2 && Utils.isInteger(value.toString())) {
            menuitem = new JMenuItem("Search for ID '" + value.toString() + "'");
            menuitem.setIcon(GUIHelper.getIcon("find.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConsoleOutputAnalyzerPanel.this.clearSearch(false);
                    ConsoleOutputAnalyzerPanel.this.m_ComboBoxOriginID.setSelectedItem(new Integer(value.toString()));
                    ConsoleOutputAnalyzerPanel.this.search();
                }
            });
            result.add(menuitem);
        } else if (col == 3) {
            menuitem = new JMenuItem("Search for type '" + value.toString() + "'");
            menuitem.setIcon(GUIHelper.getIcon("find.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConsoleOutputAnalyzerPanel.this.clearSearch(false);
                    ConsoleOutputAnalyzerPanel.this.m_ComboBoxType.setSelectedItem(value.toString());
                    ConsoleOutputAnalyzerPanel.this.search();
                }
            });
            result.add(menuitem);
        }
        menuitem = new JMenuItem("Copy");
        menuitem.setIcon(GUIHelper.getIcon("copy.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIHelper.copyToClipboard(value.toString());
            }
        });
        if (result.getSubElements().length > 0) {
            result.addSeparator();
        }
        result.add(menuitem);
        return result;
    }

    protected TextFileChooser getFileChooser() {
        if (this.m_FileChooser == null) {
            TextFileChooser fileChooser = new TextFileChooser();
            ExtensionFileFilter filter = null;
            if (this instanceof TextSupplier) {
                filter = ((TextSupplier)((Object)this)).getCustomTextFileFilter();
            }
            if (filter != null) {
                filter = ExtensionFileFilter.getTextFileFilter();
                fileChooser.resetChoosableFileFilters();
                fileChooser.addChoosableFileFilter(filter);
                fileChooser.setFileFilter(filter);
                fileChooser.setDefaultExtension(filter.getExtensions()[0]);
            }
            this.m_FileChooser = fileChooser;
        }
        return this.m_FileChooser;
    }

    protected ConsoleEntryFilter getFilter() {
        BaseRegExp originRegExp = null;
        if (this.m_TextOrigin.getText().length() > 0) {
            originRegExp = new BaseRegExp(this.m_TextOrigin.getText());
        }
        String origin = null;
        if (this.m_ComboBoxOrigin.getSelectedIndex() > -1 && this.m_ComboBoxOrigin.getSelectedItem().toString().length() > 0) {
            origin = this.m_ComboBoxOrigin.getSelectedItem().toString();
        }
        Integer originID = null;
        if (this.m_ComboBoxOriginID.getSelectedIndex() > -1 && (originID = (Integer)this.m_ComboBoxOriginID.getSelectedItem()) == -1) {
            originID = null;
        }
        String type = null;
        if (this.m_ComboBoxType.getSelectedIndex() > -1 && this.m_ComboBoxType.getSelectedItem().toString().length() > 0) {
            type = this.m_ComboBoxType.getSelectedItem().toString();
        }
        BaseRegExp outputRegExp = null;
        if (this.m_TextOutput.getText().length() > 0) {
            outputRegExp = new BaseRegExp(this.m_TextOutput.getText());
        }
        return new ConsoleEntryFilter(originRegExp, origin, originID, type, outputRegExp);
    }

    protected void clearSearch(boolean update) {
        this.m_TextOrigin.setText("");
        this.m_ComboBoxOrigin.setSelectedIndex(0);
        this.m_ComboBoxOriginID.setSelectedIndex(0);
        this.m_ComboBoxType.setSelectedIndex(0);
        this.m_TextOutput.setText("");
        if (update) {
            this.m_Filtered = null;
            this.update();
        }
    }

    protected void search() {
        if (this.m_Original == null) {
            return;
        }
        ConsoleEntryFilter filter = this.getFilter();
        this.m_Filtered = this.m_Original.applyFilter(filter);
        this.m_TableModel = new SpreadSheetTableModel(this.m_Filtered.toSpreadSheet());
        this.m_Table.setModel(this.m_TableModel);
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        this.m_MenuFileReload.setEnabled(this.m_CurrentFile != null);
    }

    @Override
    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ConsoleOutputAnalyzerPanel.this.updateMenu();
                }
            });
            JMenuItem menuitem = new JMenuItem("Open...");
            menu.add(menuitem);
            menuitem.setMnemonic('O');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed O"));
            menuitem.setIcon(GUIHelper.getIcon("open.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConsoleOutputAnalyzerPanel.this.open();
                }
            });
            JMenu submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentFilesHandler = new RecentFilesWithEncodingHandler<JMenu>(SESSION_FILE, 5, submenu);
            this.m_RecentFilesHandler.addRecentItemListener(new RecentItemListener<JMenu, String>(){

                @Override
                public void recentItemAdded(RecentItemEvent<JMenu, String> e) {
                }

                @Override
                public void recentItemSelected(RecentItemEvent<JMenu, String> e) {
                    ConsoleOutputAnalyzerPanel.this.open(RecentFilesWithEncodingHandler.getFile(e.getItem()), RecentFilesWithEncodingHandler.getEncoding(e.getItem()));
                }
            });
            this.m_MenuFileLoadRecent = submenu;
            menuitem = new JMenuItem("Reload");
            menu.add(menuitem);
            menuitem.setMnemonic('R');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("F5"));
            menuitem.setIcon(GUIHelper.getIcon("refresh.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConsoleOutputAnalyzerPanel.this.reload();
                }
            });
            this.m_MenuFileReload = menuitem;
            menu.addSeparator();
            if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, menu)) {
                menu.addSeparator();
            }
            menuitem = new JMenuItem("Close");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon("exit.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConsoleOutputAnalyzerPanel.this.closeParent();
                }
            });
            menu = new JMenu("Edit");
            result.add(menu);
            menu.setMnemonic('E');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ConsoleOutputAnalyzerPanel.this.updateMenu();
                }
            });
            menuitem = new JMenuItem("Use current output");
            menu.add(menuitem);
            menuitem.setMnemonic('c');
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConsoleOutputAnalyzerPanel.this.useCurrentOutput();
                }
            });
            this.m_MenuBar = result;
            this.updateMenu();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    protected void open() {
        int retVal = this.getFileChooser().showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        this.open(this.getFileChooser().getSelectedFile(), this.getFileChooser().getEncoding());
    }

    public void open(File file) {
        this.open(file, null);
    }

    public void open(final File file, final String encoding) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            System.err.println("File with console output does not exist: " + file);
            return;
        }
        if (file.isDirectory()) {
            System.err.println("File with console output is pointing to a directory: " + file);
            return;
        }
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ConsoleOutputAnalyzerPanel.this.m_Original = new ConsoleOutput(file, encoding);
                ConsoleOutputAnalyzerPanel.this.m_Filtered = null;
                ConsoleOutputAnalyzerPanel.this.m_CurrentFile = file;
                ConsoleOutputAnalyzerPanel.this.m_CurrentEncoding = encoding;
                return null;
            }

            @Override
            protected void done() {
                if (ConsoleOutputAnalyzerPanel.this.m_RecentFilesHandler != null) {
                    ConsoleOutputAnalyzerPanel.this.m_RecentFilesHandler.addRecentItem(ConsoleOutputAnalyzerPanel.this.m_CurrentFile.getAbsolutePath() + "\t" + ConsoleOutputAnalyzerPanel.this.m_CurrentEncoding);
                }
                ConsoleOutputAnalyzerPanel.this.update();
                super.done();
            }
        };
        worker.execute();
    }

    protected void reload() {
        if (this.m_CurrentFile == null) {
            return;
        }
        this.open(this.m_CurrentFile, this.m_CurrentEncoding);
    }

    protected void useCurrentOutput() {
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ConsoleOutputAnalyzerPanel.this.m_CurrentFile = null;
                ConsoleOutputAnalyzerPanel.this.m_CurrentEncoding = null;
                ConsoleOutputAnalyzerPanel.this.m_Original = new ConsoleOutput(ConsolePanel.getSingleton().getPanel(ConsolePanel.PanelType.ALL).getContent());
                ConsoleOutputAnalyzerPanel.this.m_Filtered = null;
                return null;
            }

            @Override
            protected void done() {
                ConsoleOutputAnalyzerPanel.this.update();
                super.done();
            }
        };
        worker.execute();
    }

    protected List addFirstElement(List list, Object first) {
        if (!list.contains(first)) {
            list.add(0, first);
        }
        return list;
    }

    protected void update() {
        ConsoleOutput current = this.m_Filtered != null ? this.m_Filtered : this.m_Original;
        if (current != null) {
            this.m_ComboBoxOrigin.setModel(new DefaultComboBoxModel<Object>(this.addFirstElement(current.getOrigins(), "").toArray()));
            this.m_ComboBoxOriginID.setModel(new DefaultComboBoxModel<Object>(this.addFirstElement(current.getOriginIDs(), new Integer(-1)).toArray()));
            this.m_ComboBoxType.setModel(new DefaultComboBoxModel<Object>(this.addFirstElement(current.getTypes(), "").toArray()));
        } else {
            this.m_ComboBoxOrigin.setModel(new DefaultComboBoxModel<Object>(this.addFirstElement(new ArrayList(), "").toArray()));
            this.m_ComboBoxOriginID.setModel(new DefaultComboBoxModel<Object>(this.addFirstElement(new ArrayList(), -1).toArray()));
            this.m_ComboBoxType.setModel(new DefaultComboBoxModel<Object>(this.addFirstElement(new ArrayList(), "").toArray()));
        }
        this.m_ComboBoxOrigin.setSelectedIndex(0);
        this.m_ComboBoxOriginID.setSelectedIndex(0);
        this.m_ComboBoxType.setSelectedIndex(0);
        if (!this.getFilter().isMatchAll()) {
            this.search();
        } else {
            this.m_TableModel = new SpreadSheetTableModel(this.m_Original.toSpreadSheet());
            this.m_Table.setModel(this.m_TableModel);
        }
        this.updateMenu();
    }

    @Override
    public Class[] getSendToClasses() {
        return new Class[]{String.class, JTable.class};
    }

    @Override
    public boolean hasSendToItem(Class[] cls) {
        return SendToActionUtils.isAvailable(new Class[]{String.class, JTable.class}, cls);
    }

    @Override
    public Object getSendToItem(Class[] cls) {
        Object result = null;
        if (this.m_Original != null) {
            if (SendToActionUtils.isAvailable(JTable.class, cls)) {
                result = this.m_Table;
                if (this.m_Table.getRowCount() == 0) {
                    result = null;
                }
            } else if (SendToActionUtils.isAvailable(String.class, cls)) {
                result = this.m_TableModel.toSpreadSheet().toString();
            }
        }
        return result;
    }

    public static class ConsoleEntryFilter {
        protected BaseRegExp m_OriginRegExp;
        protected String m_Origin;
        protected Integer m_OriginID;
        protected String m_Type;
        protected BaseRegExp m_OutputRegExp;

        public ConsoleEntryFilter() {
            this(null, null, null, null, null);
        }

        public ConsoleEntryFilter(BaseRegExp originRegExp, String origin, Integer originID, String type, BaseRegExp outputRegExp) {
            this.m_OriginRegExp = originRegExp;
            this.m_Origin = origin;
            this.m_OriginID = originID;
            this.m_Type = type;
            this.m_OutputRegExp = outputRegExp;
        }

        public BaseRegExp getOriginRegExp() {
            return this.m_OriginRegExp;
        }

        public String getOrigin() {
            return this.m_Origin;
        }

        public Integer getOriginID() {
            return this.m_OriginID;
        }

        public String getType() {
            return this.m_Type;
        }

        public BaseRegExp getOutputRegExp() {
            return this.m_OutputRegExp;
        }

        public boolean isMatch(ConsoleOutputEntry entry) {
            boolean result = true;
            if (result && this.m_OriginRegExp != null) {
                result = this.m_OriginRegExp.isMatch(entry.getOrigin());
            }
            if (result && this.m_Origin != null) {
                result = this.m_Origin.equals(entry.getOrigin());
            }
            if (result && this.m_OriginID != null) {
                result = this.m_OriginID.equals(entry.getOriginID());
            }
            if (result && this.m_Type != null) {
                result = this.m_Type.equals(entry.getType());
            }
            if (result && this.m_OutputRegExp != null) {
                result = this.m_OutputRegExp.isMatch(entry.getOutput());
            }
            return result;
        }

        public boolean isMatchAll() {
            return this.m_OriginRegExp == null && this.m_Origin == null && this.m_OriginID == null && this.m_Type == null && this.m_OutputRegExp == null;
        }

        public String toString() {
            return "originRegExp=" + this.m_OriginRegExp + ", origin=" + this.m_Origin + ", origin-id=" + this.m_OriginID + ", type=" + this.m_Type + ", outputRegExp=" + this.m_OutputRegExp;
        }
    }

    public static class ConsoleOutput
    implements Serializable,
    SpreadSheetSupporter {
        private static final long serialVersionUID = 4261087821410856963L;
        protected List<ConsoleOutputEntry> m_Entries;
        protected List<String> m_Origins;
        protected List<Integer> m_OriginIDs;
        protected List<String> m_Types;

        public ConsoleOutput(File file, String encoding) {
            this(FileUtils.loadFromFile(file, encoding));
        }

        public ConsoleOutput(String content) {
            this(Arrays.asList(content.split("\n")));
        }

        public ConsoleOutput(List<String> content) {
            this.m_Entries = new ArrayList<ConsoleOutputEntry>();
            this.m_Origins = null;
            this.m_OriginIDs = null;
            this.m_Types = null;
            if (content != null) {
                this.parse(content);
            }
        }

        public ConsoleOutput(ArrayList<ConsoleOutputEntry> content) {
            this.m_Entries = new ArrayList<ConsoleOutputEntry>(content);
        }

        protected void parse(List<String> content) {
            for (int i = 0; i < content.size(); ++i) {
                ConsoleOutputEntry entry = new ConsoleOutputEntry(i, content.get(i));
                this.m_Entries.add(entry);
            }
        }

        public synchronized List<String> getOrigins() {
            List<String> result;
            if (this.m_Origins == null) {
                HashSet<String> unique = new HashSet<String>();
                for (ConsoleOutputEntry entry : this.m_Entries) {
                    if (entry.getOrigin() == null || entry.getOrigin().length() <= 0) continue;
                    unique.add(entry.getOrigin());
                }
                result = new ArrayList<String>(unique);
                Collections.sort(result);
                this.m_Origins = result;
            } else {
                result = this.m_Origins;
            }
            return result;
        }

        public synchronized List<Integer> getOriginIDs() {
            List<Integer> result;
            if (this.m_OriginIDs == null) {
                HashSet<Integer> unique = new HashSet<Integer>();
                for (ConsoleOutputEntry entry : this.m_Entries) {
                    unique.add(entry.getOriginID());
                }
                result = new ArrayList<Integer>(unique);
                Collections.sort(result);
                this.m_OriginIDs = result;
            } else {
                result = this.m_OriginIDs;
            }
            return result;
        }

        public synchronized List<String> getTypes() {
            List<String> result;
            if (this.m_Types == null) {
                HashSet<String> unique = new HashSet<String>();
                for (ConsoleOutputEntry entry : this.m_Entries) {
                    if (entry.getType() == null || entry.getType().length() <= 0) continue;
                    unique.add(entry.getType());
                }
                result = new ArrayList<String>(unique);
                Collections.sort(result);
                this.m_Types = result;
            } else {
                result = this.m_Types;
            }
            return result;
        }

        public ConsoleOutput applyFilter(ConsoleEntryFilter filter) {
            ArrayList<ConsoleOutputEntry> filtered = new ArrayList<ConsoleOutputEntry>();
            for (ConsoleOutputEntry entry : this.m_Entries) {
                if (!filter.isMatch(entry)) continue;
                filtered.add(entry);
            }
            return new ConsoleOutput(filtered);
        }

        @Override
        public SpreadSheet toSpreadSheet() {
            SpreadSheet result = new SpreadSheet();
            Row row = result.getHeaderRow();
            row.addCell(0).setContent("Origin");
            row.addCell(1).setContent("ID");
            row.addCell(2).setContent("Type");
            row.addCell(3).setContent("Output");
            for (ConsoleOutputEntry entry : this.m_Entries) {
                row = result.addRow();
                row.addCell(0).setContent(entry.getOrigin() == null ? "?" : entry.getOrigin());
                row.addCell(1).setContent(entry.getOriginID());
                row.addCell(2).setContent(entry.getType() == null ? "?" : entry.getType());
                row.addCell(3).setContent(entry.getOutput() == null ? "?" : entry.getOutput());
            }
            return result;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            for (ConsoleOutputEntry entry : this.m_Entries) {
                if (result.length() > 0) {
                    result.append("\n");
                }
                result.append(entry.toString());
            }
            return result.toString();
        }
    }

    public static class ConsoleOutputEntry
    implements Serializable,
    Comparable<ConsoleOutputEntry> {
        private static final long serialVersionUID = -7650152159132046191L;
        public static final String ORIGIN_UNKNOWN = "unknown";
        protected int m_LineNo;
        protected String m_Raw;
        protected String m_Origin;
        protected int m_OriginID;
        protected String m_Type;
        protected String m_Output;

        public ConsoleOutputEntry(int lineNo, String raw) {
            this.m_LineNo = lineNo;
            this.m_Raw = raw;
            this.parse();
        }

        protected void parse() {
            boolean parsed = false;
            String content = this.m_Raw.trim();
            try {
                if (content.startsWith("[")) {
                    this.m_Origin = content.replaceAll("\\[(.*)(\\/([0-9]*))?-(ERROR|INFO|DEBUG)\\].*", "$1").trim();
                    String tmp = content.replaceAll("\\[(.*)(\\/([0-9]*))?-(ERROR|INFO|DEBUG)\\].*", "$2").trim();
                    this.m_OriginID = Utils.isInteger(tmp) ? Integer.parseInt(tmp) : -1;
                    this.m_Type = content.replaceAll("\\[(.*)(\\/([0-9]*))?-(ERROR|INFO|DEBUG)\\].*", "$3").trim();
                    this.m_Output = content.replaceAll("\\[(.*)(\\/([0-9]*))?-(ERROR|INFO|DEBUG)\\](.*)", "$4").trim();
                    parsed = true;
                }
            }
            catch (Exception e) {
                System.err.println("Failed to parse #" + (this.m_LineNo + 1) + ": " + this.m_Raw);
                e.printStackTrace();
                parsed = false;
            }
            if (!parsed) {
                this.m_Origin = ORIGIN_UNKNOWN;
                this.m_OriginID = -1;
                this.m_Output = this.m_Raw;
            }
        }

        public int getLineNo() {
            return this.m_LineNo;
        }

        public String getRaw() {
            return this.m_Raw;
        }

        public String getOrigin() {
            return this.m_Origin;
        }

        public int getOriginID() {
            return this.m_OriginID;
        }

        public String getType() {
            return this.m_Type;
        }

        public String getOutput() {
            return this.m_Output;
        }

        @Override
        public int compareTo(ConsoleOutputEntry o) {
            if (o == null) {
                return 1;
            }
            return new Integer(this.m_LineNo).compareTo(o.getLineNo());
        }

        public String toString() {
            return this.m_Raw;
        }
    }
}

