/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.CleanUpHandler;
import adams.core.Properties;
import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.gui.application.ChildFrame;
import adams.gui.application.ChildWindow;
import adams.gui.chooser.DirectoryChooserPanel;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.RecentFilesHandler;
import adams.gui.core.SearchPanel;
import adams.gui.core.SearchableBaseList;
import adams.gui.core.TitleGenerator;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import adams.gui.tools.previewbrowser.AbstractArchiveHandler;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.CreatingPreviewPanel;
import adams.gui.tools.previewbrowser.MultipleFileContentHandler;
import adams.gui.tools.previewbrowser.NoPreviewAvailablePanel;
import adams.gui.tools.previewbrowser.PreviewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PreviewBrowserPanel
extends BasePanel
implements MenuBarProvider,
SendToActionSupporter {
    private static final long serialVersionUID = 5284765971012530865L;
    public static final String FILENAME = "PreviewBrowser.props";
    public static final String SESSION_FILE = "PreviewBrowserSession.props";
    public static final String PREFIX_PREFERRED_CONTENT_HANDLER = "PreferredContentHandler-";
    public static final String PREFIX_PREFERRED_ARCHIVE_HANDLER = "PreferredArchiveHandler-";
    protected static Properties m_Properties;
    protected BaseSplitPane m_SplitPane;
    protected DirectoryChooserPanel m_PanelDir;
    protected BasePanel m_PanelBrowsing;
    protected BasePanel m_PanelLocalFiles;
    protected SearchableBaseList m_ListLocalFiles;
    protected DefaultListModel m_ModelLocalFiles;
    protected SearchPanel m_SearchLocalFiles;
    protected BasePanel m_PanelArchiveFiles;
    protected SearchableBaseList m_ListArchiveFiles;
    protected DefaultListModel m_ModelArchiveFiles;
    protected SearchPanel m_SearchArchiveFiles;
    protected BasePanel m_PanelContent;
    protected BasePanel m_PanelView;
    protected BasePanel m_PanelContentHandlers;
    protected JComboBox m_ComboBoxContentHandlers;
    protected DefaultComboBoxModel m_ModelContentHandlers;
    protected boolean m_IgnoreContentHandlerChanges;
    protected BasePanel m_PanelArchiveHandlers;
    protected JComboBox m_ComboBoxArchiveHandlers;
    protected DefaultComboBoxModel m_ModelArchiveHandlers;
    protected boolean m_IgnoreArchiveHandlerChanges;
    protected AbstractArchiveHandler m_ArchiveHandler;
    protected File[] m_CurrentFiles;
    protected RecentFilesHandler<JMenu> m_RecentFilesHandler;
    protected JMenuBar m_MenuBar;
    protected JMenu m_MenuFileLoadRecent;
    protected JMenuItem m_MenuItemShowHiddenFiles;
    protected JMenuItem m_MenuItemShowTempFiles;
    protected TitleGenerator m_TitleGenerator;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_ArchiveHandler = null;
        this.m_IgnoreContentHandlerChanges = false;
        this.m_IgnoreArchiveHandlerChanges = false;
        this.m_CurrentFiles = null;
        this.m_RecentFilesHandler = null;
        this.m_TitleGenerator = new TitleGenerator("Preview browser", false);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        Properties props = PreviewBrowserPanel.getProperties();
        this.setLayout(new BorderLayout());
        this.m_SplitPane = new BaseSplitPane(1);
        this.m_SplitPane.setOneTouchExpandable(true);
        this.m_SplitPane.setDividerLocation(props.getInteger("DividerLocation", 200));
        this.add((Component)this.m_SplitPane, "Center");
        this.m_PanelBrowsing = new BasePanel(new GridLayout(2, 1));
        this.m_SplitPane.setLeftComponent(this.m_PanelBrowsing);
        this.m_PanelLocalFiles = new BasePanel(new BorderLayout(0, 5));
        this.m_PanelBrowsing.add(this.m_PanelLocalFiles);
        this.m_PanelLocalFiles.setBorder(BorderFactory.createTitledBorder("Files"));
        this.m_PanelDir = new DirectoryChooserPanel(props.getPath("InitialDir", "%h"));
        this.m_PanelDir.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PreviewBrowserPanel.this.refreshLocalFiles();
                if (PreviewBrowserPanel.this.m_RecentFilesHandler != null) {
                    PreviewBrowserPanel.this.m_RecentFilesHandler.addRecentItem(PreviewBrowserPanel.this.m_PanelDir.getCurrent());
                }
            }
        });
        this.m_PanelLocalFiles.add((Component)this.m_PanelDir, "North");
        this.m_ModelLocalFiles = new DefaultListModel();
        this.m_ListLocalFiles = new SearchableBaseList((ListModel)this.m_ModelLocalFiles);
        this.m_ListLocalFiles.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                PreviewBrowserPanel.this.displayLocalFile();
            }
        });
        this.m_PanelLocalFiles.add((Component)new BaseScrollPane(this.m_ListLocalFiles), "Center");
        this.m_SearchLocalFiles = new SearchPanel(SearchPanel.LayoutType.VERTICAL, false);
        this.m_SearchLocalFiles.addSearchListener(new SearchListener(){

            @Override
            public void searchInitiated(SearchEvent e) {
                PreviewBrowserPanel.this.m_ListLocalFiles.search(e.getParameters().getSearchString(), e.getParameters().isRegExp());
            }
        });
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(this.m_SearchLocalFiles);
        this.m_PanelLocalFiles.add((Component)panel, "South");
        this.m_PanelArchiveFiles = new BasePanel(new BorderLayout());
        this.m_PanelBrowsing.add(this.m_PanelArchiveFiles);
        this.m_PanelArchiveFiles.setVisible(false);
        this.m_PanelArchiveFiles.setBorder(BorderFactory.createTitledBorder("Archive"));
        this.m_ModelArchiveFiles = new DefaultListModel();
        this.m_ListArchiveFiles = new SearchableBaseList((ListModel)this.m_ModelArchiveFiles);
        this.m_ListArchiveFiles.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                PreviewBrowserPanel.this.displayArchiveContent();
            }
        });
        this.m_PanelArchiveFiles.add((Component)new BaseScrollPane(this.m_ListArchiveFiles), "Center");
        this.m_SearchArchiveFiles = new SearchPanel(SearchPanel.LayoutType.VERTICAL, false);
        this.m_SearchArchiveFiles.addSearchListener(new SearchListener(){

            @Override
            public void searchInitiated(SearchEvent e) {
                PreviewBrowserPanel.this.m_ListArchiveFiles.search(e.getParameters().getSearchString(), e.getParameters().isRegExp());
            }
        });
        panel = new JPanel(new FlowLayout(0));
        panel.add(this.m_SearchArchiveFiles);
        this.m_PanelArchiveFiles.add((Component)panel, "South");
        this.m_PanelArchiveHandlers = new BasePanel(new FlowLayout(0));
        this.m_PanelArchiveHandlers.setVisible(false);
        this.m_PanelArchiveFiles.add((Component)this.m_PanelArchiveHandlers, "South");
        this.m_ModelArchiveHandlers = new DefaultComboBoxModel();
        this.m_ComboBoxArchiveHandlers = new JComboBox(this.m_ModelArchiveHandlers);
        this.m_ComboBoxArchiveHandlers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PreviewBrowserPanel.this.m_IgnoreArchiveHandlerChanges) {
                    return;
                }
                PreviewBrowserPanel.this.updatePreferredArchiveHandler();
                PreviewBrowserPanel.this.displayArchiveContent();
            }
        });
        this.m_PanelArchiveHandlers.add(new JLabel("Preferred handler"));
        this.m_PanelArchiveHandlers.add(this.m_ComboBoxArchiveHandlers);
        this.m_PanelContent = new BasePanel(new BorderLayout());
        this.m_SplitPane.setRightComponent(this.m_PanelContent);
        this.m_PanelView = new BasePanel(new BorderLayout());
        this.m_PanelContent.add((Component)this.m_PanelView, "Center");
        this.m_PanelContentHandlers = new BasePanel(new FlowLayout(0));
        this.m_PanelContentHandlers.setVisible(false);
        this.m_PanelContent.add((Component)this.m_PanelContentHandlers, "South");
        this.m_ModelContentHandlers = new DefaultComboBoxModel();
        this.m_ComboBoxContentHandlers = new JComboBox(this.m_ModelContentHandlers);
        this.m_ComboBoxContentHandlers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PreviewBrowserPanel.this.m_IgnoreContentHandlerChanges) {
                    return;
                }
                PreviewBrowserPanel.this.updatePreferredContentHandler();
                if (PreviewBrowserPanel.this.m_CurrentFiles != null) {
                    PreviewBrowserPanel.this.displayLocalContent(PreviewBrowserPanel.this.m_CurrentFiles, false);
                }
            }
        });
        this.m_PanelContentHandlers.add(new JLabel("Preferred handler"));
        this.m_PanelContentHandlers.add(this.m_ComboBoxContentHandlers);
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.refreshLocalFiles();
    }

    protected File[] filterFiles(File[] files) {
        boolean showHidden = this.m_MenuItemShowHiddenFiles != null ? this.m_MenuItemShowHiddenFiles.isSelected() : PreviewBrowserPanel.getProperties().getBoolean("ShowHiddenFiles", false).booleanValue();
        boolean showTemp = this.m_MenuItemShowTempFiles != null ? this.m_MenuItemShowTempFiles.isSelected() : PreviewBrowserPanel.getProperties().getBoolean("ShowTempFiles", false).booleanValue();
        BaseRegExp regExp = new BaseRegExp(".*");
        String exp = PreviewBrowserPanel.getProperties().getProperty("TempFiles", ".*\\.bak|.*\\.backup|.*~");
        if (exp.length() > 0) {
            String[] expList = Utils.split(exp, '|');
            exp = "";
            for (String item : expList) {
                if (exp.length() > 0) {
                    exp = exp + "|";
                }
                exp = exp + (String)item;
            }
            regExp = new BaseRegExp("^(" + exp + ")");
        } else {
            showTemp = true;
        }
        if (showHidden && showTemp) {
            return files;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (File file : files) {
            if (!showTemp && regExp.isMatch(file.getName()) || !showHidden && file.isHidden()) continue;
            result.add(file);
        }
        return result.toArray(new File[result.size()]);
    }

    protected synchronized void refreshLocalFiles() {
        File dir = (File)this.m_PanelDir.getCurrent();
        File[] files = this.filterFiles(dir.listFiles());
        ArrayList<File> fileList = new ArrayList<File>();
        for (File file : files) {
            if (file.isDirectory()) continue;
            fileList.add(file);
        }
        Collections.sort(fileList, new FileComparator());
        this.m_ListLocalFiles.clearSelection();
        this.m_ModelLocalFiles.clear();
        for (File file : fileList) {
            this.m_ModelLocalFiles.addElement(file.getName());
        }
        this.m_ListLocalFiles.search(this.m_ListLocalFiles.getSeachString(), this.m_ListLocalFiles.isRegExpSearch());
        this.m_ListArchiveFiles.clearSelection();
        this.m_ModelArchiveFiles.clear();
        this.m_PanelArchiveFiles.setVisible(false);
    }

    protected void displayView(JPanel panel) {
        if (this.m_PanelView.getComponentCount() > 0 && this.m_PanelView.getComponent(0) instanceof CleanUpHandler) {
            ((CleanUpHandler)((Object)this.m_PanelView.getComponent(0))).cleanUp();
        }
        this.m_PanelView.removeAll();
        this.m_PanelView.add((Component)panel, "Center");
        this.m_SplitPane.validate();
    }

    protected void displayCreatingView() {
        this.displayView(new CreatingPreviewPanel());
    }

    protected synchronized void displayLocalFile() {
        if (this.m_ListLocalFiles.getSelectedIndex() < 0) {
            return;
        }
        if (this.m_ListLocalFiles.getSelectedValues().length < 1) {
            return;
        }
        File[] localFiles = new PlaceholderFile[this.m_ListLocalFiles.getSelectedValues().length];
        for (int n = 0; n < localFiles.length; ++n) {
            localFiles[n] = new PlaceholderFile(((File)this.m_PanelDir.getCurrent()).getAbsolutePath() + File.separator + this.m_ListLocalFiles.getSelectedValues()[n]);
        }
        if (AbstractArchiveHandler.hasHandler(localFiles[0])) {
            this.m_PanelArchiveFiles.setVisible(true);
            Vector<Class> handlers = AbstractArchiveHandler.getHandlersForFile(localFiles[0]);
            this.m_IgnoreArchiveHandlerChanges = true;
            this.m_ModelArchiveHandlers.removeAllElements();
            for (Class cls : handlers) {
                this.m_ModelArchiveHandlers.addElement(cls.getName());
            }
            this.m_PanelArchiveHandlers.setVisible(this.m_ModelArchiveHandlers.getSize() > 1);
            AbstractArchiveHandler preferred = this.getPreferredArchiveHandler(localFiles[0]);
            this.m_ComboBoxArchiveHandlers.setSelectedIndex(0);
            if (preferred != null) {
                for (int i = 0; i < handlers.size(); ++i) {
                    if (preferred.getClass() != handlers.get(i)) continue;
                    this.m_ComboBoxArchiveHandlers.setSelectedIndex(i);
                    break;
                }
            }
            this.m_IgnoreArchiveHandlerChanges = false;
            try {
                Class<?> cls = Class.forName((String)this.m_ComboBoxArchiveHandlers.getSelectedItem());
                this.m_ArchiveHandler = (AbstractArchiveHandler)cls.newInstance();
            }
            catch (Exception e) {
                this.m_ArchiveHandler = null;
                System.err.println("Failed to obtain archive handler for '" + localFiles[0] + "':");
                e.printStackTrace();
            }
        } else {
            this.m_ArchiveHandler = null;
        }
        this.m_ModelArchiveFiles.clear();
        this.m_PanelArchiveFiles.setVisible(this.m_ArchiveHandler != null);
        this.m_PanelView.removeAll();
        if (this.m_ArchiveHandler == null) {
            this.displayLocalContent(localFiles, false);
        } else {
            String[] files;
            this.m_CurrentFiles = null;
            this.m_ArchiveHandler.setArchive((PlaceholderFile)localFiles[0]);
            for (String file : files = this.m_ArchiveHandler.getFiles()) {
                this.m_ModelArchiveFiles.addElement(file);
            }
        }
        this.m_ListArchiveFiles.search(this.m_ListArchiveFiles.getSeachString(), this.m_ListArchiveFiles.isRegExpSearch());
    }

    protected JPanel createPreview(File[] localFiles) {
        JPanel result = new NoPreviewAvailablePanel();
        if (AbstractContentHandler.hasHandler(localFiles[0])) {
            Vector<Class> handlers = AbstractContentHandler.getHandlersForFile(localFiles[0]);
            this.m_IgnoreContentHandlerChanges = true;
            this.m_ModelContentHandlers.removeAllElements();
            for (Class handler : handlers) {
                this.m_ModelContentHandlers.addElement(handler.getName());
            }
            this.m_PanelContentHandlers.setVisible(this.m_ModelContentHandlers.getSize() > 1);
            AbstractContentHandler preferred = this.getPreferredContentHandler(localFiles[0]);
            this.m_ComboBoxContentHandlers.setSelectedIndex(0);
            if (preferred != null) {
                for (int i = 0; i < handlers.size(); ++i) {
                    if (preferred.getClass() != handlers.get(i)) continue;
                    this.m_ComboBoxContentHandlers.setSelectedIndex(i);
                    break;
                }
            }
            this.m_IgnoreContentHandlerChanges = false;
            try {
                Class<?> cls;
                if (this.m_ComboBoxContentHandlers.getSelectedIndex() != -1) {
                    cls = Class.forName((String)this.m_ComboBoxContentHandlers.getSelectedItem());
                } else if (this.m_ComboBoxContentHandlers.getItemCount() > 0) {
                    cls = Class.forName((String)this.m_ComboBoxContentHandlers.getItemAt(0));
                } else {
                    return null;
                }
                AbstractContentHandler contentHandler = (AbstractContentHandler)cls.newInstance();
                result = contentHandler instanceof MultipleFileContentHandler ? ((MultipleFileContentHandler)((Object)contentHandler)).getPreview(localFiles) : contentHandler.getPreview(localFiles[0]);
            }
            catch (Exception e) {
                Object contentHandler = null;
                System.err.println("Failed to obtain content handler for '" + Utils.arrayToString(localFiles) + "':");
                e.printStackTrace();
            }
        }
        return result;
    }

    protected void displayLocalContent(final File[] localFiles, boolean wait) {
        if (localFiles.length < 1) {
            return;
        }
        this.m_CurrentFiles = localFiles;
        this.displayCreatingView();
        if (!wait) {
            SwingWorker worker = new SwingWorker(){
                JPanel contentPanel;

                protected Object doInBackground() throws Exception {
                    this.contentPanel = PreviewBrowserPanel.this.createPreview(localFiles);
                    return null;
                }

                @Override
                protected void done() {
                    if (this.contentPanel != null) {
                        PreviewBrowserPanel.this.displayView(this.contentPanel);
                    }
                    super.done();
                }
            };
            worker.execute();
        } else {
            this.displayView(this.createPreview(localFiles));
        }
    }

    protected synchronized void displayArchiveContent() {
        if (this.m_ListArchiveFiles.getSelectedIndex() < 0) {
            return;
        }
        this.displayCreatingView();
        Object[] selFiles = this.m_ListArchiveFiles.getSelectedValues();
        File[] tmpFiles = new File[selFiles.length];
        for (int i = 0; i < selFiles.length; ++i) {
            try {
                tmpFiles[i] = File.createTempFile("adams-pb-", "." + FileUtils.getExtension(selFiles[i].toString()), FileUtils.getTempDirectory());
                if (this.m_ArchiveHandler.extract(selFiles[i].toString(), tmpFiles[i])) continue;
                System.err.println("Failed to extract file '" + selFiles[i] + "'!");
                return;
            }
            catch (Exception e) {
                System.err.println("Failed to extract file '" + selFiles[i] + "':");
                e.printStackTrace();
            }
        }
        this.displayLocalContent(tmpFiles, false);
    }

    protected AbstractContentHandler getPreferredContentHandler(File file) {
        AbstractContentHandler result = null;
        String ext = FileUtils.getExtension(file);
        if (ext == null) {
            return result;
        }
        ext = ext.toLowerCase();
        Properties props = PreviewBrowserPanel.getProperties();
        if (props.hasKey(PREFIX_PREFERRED_CONTENT_HANDLER + ext)) {
            String handler = props.getProperty(PREFIX_PREFERRED_CONTENT_HANDLER + ext);
            try {
                result = (AbstractContentHandler)Class.forName(handler).newInstance();
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate handler: " + handler);
                e.printStackTrace();
            }
        }
        return result;
    }

    protected void updatePreferredContentHandler() {
        if (this.m_CurrentFiles == null) {
            return;
        }
        Properties props = PreviewBrowserPanel.getProperties();
        for (File file : this.m_CurrentFiles) {
            String ext = FileUtils.getExtension(file);
            if (ext == null) continue;
            ext = ext.toLowerCase();
            String handler = this.m_ComboBoxContentHandlers.getSelectedIndex() < 0 ? (String)this.m_ComboBoxContentHandlers.getItemAt(0) : (String)this.m_ComboBoxContentHandlers.getSelectedItem();
            props.setProperty(PREFIX_PREFERRED_CONTENT_HANDLER + ext, handler);
        }
        String filename = Environment.getInstance().getHome() + File.separator + FILENAME;
        if (!props.save(filename)) {
            System.err.println("Failed to save properties to '" + filename + "'!");
        }
    }

    protected AbstractArchiveHandler getPreferredArchiveHandler(File file) {
        AbstractArchiveHandler result = null;
        String ext = FileUtils.getExtension(file);
        if (ext == null) {
            return result;
        }
        ext = ext.toLowerCase();
        Properties props = PreviewBrowserPanel.getProperties();
        if (props.hasKey(PREFIX_PREFERRED_ARCHIVE_HANDLER + ext)) {
            String handler = props.getProperty(PREFIX_PREFERRED_ARCHIVE_HANDLER + ext);
            try {
                result = (AbstractArchiveHandler)Class.forName(handler).newInstance();
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate handler: " + handler);
                e.printStackTrace();
            }
        }
        return result;
    }

    protected void updatePreferredArchiveHandler() {
        if (this.m_CurrentFiles == null) {
            return;
        }
        Properties props = PreviewBrowserPanel.getProperties();
        for (File file : this.m_CurrentFiles) {
            String ext = FileUtils.getExtension(file);
            if (ext == null) continue;
            ext = ext.toLowerCase();
            String handler = this.m_ComboBoxArchiveHandlers.getSelectedIndex() < 0 ? (String)this.m_ComboBoxArchiveHandlers.getItemAt(0) : (String)this.m_ComboBoxArchiveHandlers.getSelectedItem();
            props.setProperty(PREFIX_PREFERRED_ARCHIVE_HANDLER + ext, handler);
        }
        String filename = Environment.getInstance().getCustomPropertiesFilename("preview browser");
        if (!Environment.getInstance().write("preview browser", props)) {
            System.err.println("Failed to save properties to '" + filename + "'!");
        }
    }

    protected void update() {
        this.updateTitle();
        this.updateMenu();
    }

    protected void updateTitle() {
        if (this.m_CurrentFiles.length == 0) {
            this.setParentTitle(this.m_TitleGenerator.generate());
        } else if (this.m_CurrentFiles.length == 1) {
            this.setParentTitle(this.m_TitleGenerator.generate(this.m_CurrentFiles[0]));
        } else {
            this.setParentTitle(this.m_TitleGenerator.generate(this.m_CurrentFiles[0]) + " ...");
        }
    }

    protected void updateMenu() {
    }

    @Override
    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PreviewBrowserPanel.this.updateMenu();
                }
            });
            JMenuItem menuitem = new JMenuItem("Open...");
            menu.add(menuitem);
            menuitem.setMnemonic('O');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed O"));
            menuitem.setIcon(GUIHelper.getIcon("open.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PreviewBrowserPanel.this.m_PanelDir.choose();
                }
            });
            JMenu submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentFilesHandler = new RecentFilesHandler<JMenu>(SESSION_FILE, PreviewBrowserPanel.getProperties().getInteger("MaxRecentDirs", 5), submenu);
            this.m_RecentFilesHandler.addRecentItemListener(new RecentItemListener<JMenu, File>(){

                @Override
                public void recentItemAdded(RecentItemEvent<JMenu, File> e) {
                }

                @Override
                public void recentItemSelected(RecentItemEvent<JMenu, File> e) {
                    PreviewBrowserPanel.this.open(new PlaceholderDirectory(e.getItem()));
                }
            });
            this.m_MenuFileLoadRecent = submenu;
            menuitem = new JMenuItem("Reload");
            menu.add(menuitem);
            menuitem.setMnemonic('R');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("F5"));
            menuitem.setIcon(GUIHelper.getIcon("refresh.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PreviewBrowserPanel.this.reload();
                }
            });
            menu.addSeparator();
            if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, menu)) {
                menu.addSeparator();
            }
            menuitem = new JMenuItem("Close");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon("exit.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PreviewBrowserPanel.this.closeParent();
                }
            });
            menu = new JMenu("View");
            result.add(menu);
            menu.setMnemonic('V');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PreviewBrowserPanel.this.updateMenu();
                }
            });
            menuitem = new JCheckBoxMenuItem("Show hidden files");
            menuitem.setSelected(PreviewBrowserPanel.getProperties().getBoolean("ShowHiddenFiles", false));
            menu.add(menuitem);
            menuitem.setMnemonic('h');
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PreviewBrowserPanel.this.refreshLocalFiles();
                }
            });
            this.m_MenuItemShowHiddenFiles = menuitem;
            menuitem = new JCheckBoxMenuItem("Show temporary files");
            menuitem.setSelected(PreviewBrowserPanel.getProperties().getBoolean("ShowTempFiles", false));
            menu.add(menuitem);
            menuitem.setMnemonic('t');
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PreviewBrowserPanel.this.refreshLocalFiles();
                }
            });
            this.m_MenuItemShowTempFiles = menuitem;
            menu = new JMenu("Window");
            result.add(menu);
            menu.setMnemonic('W');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PreviewBrowserPanel.this.updateMenu();
                }
            });
            menuitem = new JMenuItem("New window");
            menu.add(menuitem);
            menuitem.setMnemonic('N');
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PreviewBrowserPanel.this.newWindow();
                }
            });
            this.m_MenuBar = result;
            this.updateMenu();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    public void open(final PlaceholderDirectory dir) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                PreviewBrowserPanel.this.m_PanelDir.setCurrent(dir);
                PreviewBrowserPanel.this.m_PanelDir.fireCurrentValueChanged();
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public void open(final PlaceholderFile file) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                PreviewBrowserPanel.this.m_PanelDir.setCurrent(file.getParentFile());
                PreviewBrowserPanel.this.m_PanelDir.fireCurrentValueChanged();
            }
        };
        SwingUtilities.invokeLater(run);
        run = new Runnable(){

            @Override
            public void run() {
                PreviewBrowserPanel.this.m_ListLocalFiles.setSelectedValue(file.getName(), true);
            }
        };
        SwingUtilities.invokeLater(run);
        run = new Runnable(){

            @Override
            public void run() {
                PreviewBrowserPanel.this.displayLocalContent(new File[]{file}, true);
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public void reload() {
        Object[] selected = this.m_ListLocalFiles.getSelectedValues();
        this.open(new PlaceholderDirectory((File)this.m_PanelDir.getCurrent()));
        if (selected.length > 0) {
            this.m_ListLocalFiles.setSelectedValue(selected[0], true);
        }
    }

    public void clear() {
        this.m_CurrentFiles = new File[0];
        this.displayView(new NoPreviewAvailablePanel());
    }

    public PreviewBrowserPanel newWindow() {
        PreviewBrowserPanel result = null;
        ChildFrame oldFrame = (ChildFrame)GUIHelper.getParent(this, ChildFrame.class);
        if (oldFrame != null) {
            ChildFrame newFrame = oldFrame.getNewWindow();
            newFrame.setVisible(true);
            result = (PreviewBrowserPanel)newFrame.getContentPane().getComponent(0);
        } else {
            ChildWindow oldWindow = (ChildWindow)GUIHelper.getParent(this, ChildWindow.class);
            if (oldWindow != null) {
                ChildWindow newWindow = oldWindow.getNewWindow();
                newWindow.setVisible(true);
                result = (PreviewBrowserPanel)newWindow.getContentPane().getComponent(0);
            }
        }
        if (result != null) {
            result.open(new PlaceholderDirectory((File)this.m_PanelDir.getCurrent()));
        }
        return result;
    }

    @Override
    public Class[] getSendToClasses() {
        return new Class[]{PlaceholderFile.class, JComponent.class};
    }

    @Override
    public boolean hasSendToItem(Class[] cls) {
        return this.m_CurrentFiles != null && this.m_CurrentFiles.length > 0;
    }

    @Override
    public Object getSendToItem(Class[] cls) {
        Serializable result = null;
        File file = null;
        if (this.m_CurrentFiles != null && this.m_CurrentFiles.length > 0) {
            file = this.m_CurrentFiles[0];
        }
        if (SendToActionUtils.isAvailable(PlaceholderFile.class, cls)) {
            if (file != null) {
                result = new PlaceholderFile(file);
            }
        } else if (SendToActionUtils.isAvailable(JComponent.class, cls)) {
            result = this.m_PanelView.getComponentCount() > 0 && this.m_PanelView.getComponent(0) instanceof PreviewPanel ? ((PreviewPanel)this.m_PanelView.getComponent(0)).getContent() : this.m_PanelView;
        }
        return result;
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("preview browser");
        }
        return m_Properties;
    }

    public void setBrowsingEnabled(boolean value) {
        this.m_SplitPane.setLeftComponentHidden(!value);
    }

    public boolean isBrowsingEnabled() {
        return !this.m_SplitPane.isLeftComponentHidden();
    }

    public static class FileComparator
    implements Comparator<File> {
        @Override
        public int compare(File o1, File o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
        }
    }
}

