/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.SpreadSheetTable;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.NoDataToPreviewPanel;
import adams.gui.tools.previewbrowser.PreviewPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;

public abstract class AbstractSpreadSheetHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = 460332838835780629L;
    public static final String UNNAMED_SHEET_PREFIX = "Sheet";

    @Override
    public String globalInfo() {
        return "Displays the following spreadsheet types: " + Utils.arrayToString(this.getExtensions());
    }

    protected abstract SpreadSheet[] readAll(File var1);

    @Override
    protected PreviewPanel createPreview(File file) {
        SpreadSheetTable table;
        BasePanel result;
        SpreadSheet[] sheets = this.readAll(file);
        if (sheets.length > 1) {
            result = new BasePanel(new BorderLayout());
            BaseTabbedPane tabbedPane = new BaseTabbedPane();
            tabbedPane.setTabPlacement(3);
            result.add((Component)tabbedPane, "Center");
            for (int i = 0; i < sheets.length; ++i) {
                if (!sheets[i].hasName()) {
                    sheets[i].setName(UNNAMED_SHEET_PREFIX + (i + 1));
                }
                table = new SpreadSheetTable(sheets[i]);
                tabbedPane.addTab(sheets[i].getName(), new BaseScrollPane(table));
            }
            table = null;
        } else if (sheets.length == 1) {
            result = new BasePanel(new BorderLayout());
            table = new SpreadSheetTable(sheets[0]);
            result.add((Component)new BaseScrollPane(table), "Center");
        } else {
            result = new NoDataToPreviewPanel();
            table = null;
        }
        if (table != null) {
            return new PreviewPanel(result, table);
        }
        return new PreviewPanel(result);
    }
}

