/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.container;

import adams.gui.event.DataChangeEvent;
import adams.gui.visualization.container.AbstractContainer;
import adams.gui.visualization.container.AbstractContainerManager;
import adams.gui.visualization.container.SearchableContainerManager;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSearchableContainerManager<T extends AbstractContainer>
extends AbstractContainerManager<T>
implements SearchableContainerManager<T> {
    private static final long serialVersionUID = -3626257922847866204L;
    protected String m_SearchString;
    protected boolean m_SearchRegexp;
    protected List<T> m_FilteredList = null;

    protected AbstractSearchableContainerManager() {
    }

    public boolean isFiltered() {
        return this.m_FilteredList != null;
    }

    protected boolean updateSearchOnUpdate() {
        return true;
    }

    @Override
    public void finishUpdate(boolean notify) {
        super.finishUpdate(notify);
        if (this.updateSearchOnUpdate()) {
            this.updateSearch();
        }
    }

    @Override
    public void clear() {
        this.m_FilteredList = null;
        super.clear();
    }

    @Override
    public boolean contains(T o) {
        if (!this.isFiltered()) {
            return super.contains(o);
        }
        boolean result = false;
        for (int i = 0; i < this.m_FilteredList.size(); ++i) {
            if (!((AbstractContainer)this.m_FilteredList.get(i)).equals(o)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public void add(T c) {
        super.add(c);
        if (!this.m_Updating && this.updateSearchOnUpdate()) {
            this.updateSearch();
        }
    }

    @Override
    public T set(int index, T c) {
        T result = super.set(index, c);
        if (!this.m_Updating && this.updateSearchOnUpdate()) {
            this.updateSearch();
        }
        return result;
    }

    @Override
    public T get(int index) {
        if (this.isFiltered()) {
            return (T)((AbstractContainer)this.m_FilteredList.get(index));
        }
        return (T)((AbstractContainer)this.m_List.get(index));
    }

    @Override
    public T remove(int index) {
        if (!this.m_AllowRemoval) {
            return null;
        }
        if (!this.isFiltered()) {
            return super.remove(index);
        }
        AbstractContainer result = (AbstractContainer)this.m_FilteredList.remove(index);
        if (result != null) {
            this.m_List.remove(result);
        }
        this.notifyDataChangeListeners(new DataChangeEvent((AbstractContainerManager)this, DataChangeEvent.Type.REMOVAL, index, result));
        return (T)result;
    }

    @Override
    public int count() {
        if (this.isFiltered()) {
            return this.m_FilteredList.size();
        }
        return this.m_List.size();
    }

    @Override
    public int indexOf(T c) {
        if (this.isFiltered()) {
            return this.m_FilteredList.indexOf(c);
        }
        return this.m_List.indexOf(c);
    }

    @Override
    public void search(String search, boolean regExp) {
        this.m_SearchString = search;
        this.m_SearchRegexp = regExp;
        this.updateSearch();
    }

    @Override
    public void clearSearch() {
        this.search(null, false);
    }

    protected abstract boolean isMatch(T var1, String var2, boolean var3);

    protected void updateSearch() {
        if (this.m_SearchString == null) {
            this.m_FilteredList = null;
            this.notifyDataChangeListeners(new DataChangeEvent(this, DataChangeEvent.Type.SEARCH));
            return;
        }
        ArrayList<T> filtered = new ArrayList<T>();
        for (AbstractContainer cont : this.m_List) {
            if (!this.isMatch(cont, this.m_SearchString, this.m_SearchRegexp)) continue;
            filtered.add(cont);
        }
        this.m_FilteredList = filtered;
        this.notifyDataChangeListeners(new DataChangeEvent(this, DataChangeEvent.Type.SEARCH));
    }
}

