/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.container;

import adams.gui.core.BaseTable;
import adams.gui.visualization.container.AbstractContainer;
import adams.gui.visualization.container.AbstractContainerManager;
import adams.gui.visualization.container.ContainerModel;
import adams.gui.visualization.container.ContainerTableCellRenderer;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ContainerTable<M extends AbstractContainerManager, C extends AbstractContainer>
extends BaseTable {
    private static final long serialVersionUID = -7750679423202155069L;
    protected boolean m_ColumnWidthsSet;
    protected boolean m_ManuallyResized;

    public ContainerTable() {
        this(new ContainerModel((AbstractContainerManager)null));
    }

    public ContainerTable(ContainerModel<M, C> model) {
        super(model);
        this.setAutoResizeMode(0);
        this.setDefaultRenderer(String.class, new ContainerTableCellRenderer());
        this.setDefaultRenderer(Integer.class, new ContainerTableCellRenderer());
        this.setDefaultRenderer(Double.class, new ContainerTableCellRenderer());
        this.getTableHeader().setReorderingAllowed(false);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    ContainerTable.this.removeContainers(ContainerTable.this.getSelectedRows());
                    e.consume();
                }
                if (!e.isConsumed()) {
                    super.keyPressed(e);
                }
            }
        });
        this.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                ContainerTable.this.m_ManuallyResized = true;
            }

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }
        });
        this.resizeAndRepaint();
    }

    public void removeAllContainers() {
        this.removeContainers(null);
    }

    public void removeContainers(int[] indices) {
        if (indices != null && indices.length == 0) {
            return;
        }
        M manager = this.getManager();
        if (indices == null) {
            ((AbstractContainerManager)manager).clear();
        } else if (indices.length > 1) {
            ((AbstractContainerManager)manager).startUpdate();
            for (int i = indices.length - 1; i >= 0; --i) {
                ((AbstractContainerManager)manager).remove(indices[i]);
            }
            ((AbstractContainerManager)manager).finishUpdate();
        } else {
            ((AbstractContainerManager)manager).remove(indices[0]);
        }
    }

    @Override
    public void setModel(TableModel value) {
        if (!(value instanceof ContainerModel)) {
            throw new IllegalArgumentException("Only models of type " + ContainerModel.class.getName() + " can be used!");
        }
        if (this.getModel() instanceof ContainerModel) {
            ((ContainerModel)this.getModel()).unregister();
        }
        super.setModel(value);
        this.m_ColumnWidthsSet = false;
        this.m_ManuallyResized = false;
    }

    protected void updateColumnWidths() {
        if (this.getModel() == null) {
            return;
        }
        if (this.getColumnCount() != this.getColumnModel().getColumnCount()) {
            return;
        }
        if (this.getTableHeader() == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ContainerModel model = (ContainerModel)ContainerTable.this.getModel();
                TableColumnModel colModel = ContainerTable.this.getColumnModel();
                ContainerModel containerModel = model;
                synchronized (containerModel) {
                    TableColumnModel tableColumnModel = colModel;
                    synchronized (tableColumnModel) {
                        for (int i = 0; i < colModel.getColumnCount(); ++i) {
                            colModel.getColumn(i).setPreferredWidth(model.getColumnWidth(i));
                        }
                    }
                }
            }
        };
        this.m_ColumnWidthsSet = true;
        SwingUtilities.invokeLater(runnable);
    }

    public boolean isColumnWidthsSet() {
        return this.m_ColumnWidthsSet;
    }

    public boolean isManuallyResized() {
        return this.m_ManuallyResized;
    }

    public void invalidateColumnWidths() {
        this.m_ColumnWidthsSet = false;
        this.m_ManuallyResized = false;
        super.invalidate();
    }

    @Override
    public void revalidate() {
        super.revalidate();
        if (!this.isColumnWidthsSet() && !this.isManuallyResized()) {
            this.updateColumnWidths();
        }
    }

    public M getManager() {
        if (this.getModel() != null) {
            return ((ContainerModel)this.getModel()).getManager();
        }
        return null;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getColumn() == -1) {
            this.m_ColumnWidthsSet = false;
        }
        super.tableChanged(e);
    }
}

