/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core;

import adams.core.option.AbstractOptionHandler;
import adams.data.DecimalFormatString;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.axis.FancyTickGenerator;
import adams.gui.visualization.core.axis.TickGenerator;
import adams.gui.visualization.core.axis.Type;
import adams.gui.visualization.core.plot.Axis;

public class AxisPanelOptions
extends AbstractOptionHandler {
    private static final long serialVersionUID = 1675594412675760089L;
    protected String m_Label;
    protected Type m_Type;
    protected boolean m_ShowGridLines;
    protected TickGenerator m_TickGenerator;
    protected int m_NthValueToShow;
    protected int m_LengthTicks;
    protected DecimalFormatString m_CustomFormat;
    protected double m_TopMargin;
    protected double m_BottomMargin;
    protected int m_Width;

    @Override
    public String globalInfo() {
        return "Encapsulates options for an axis in a plot.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("label", "label", "");
        this.m_OptionManager.add("type", "type", Type.ABSOLUTE);
        this.m_OptionManager.add("hide-grid-lines", "showGridLines", true);
        this.m_OptionManager.add("tick-generator", "tickGenerator", new FancyTickGenerator());
        this.m_OptionManager.add("nth-value", "nthValueToShow", 5, 0, null);
        this.m_OptionManager.add("length-ticks", "lengthTicks", 4, 1, null);
        this.m_OptionManager.add("width", "width", 20, 5, null);
        this.m_OptionManager.add("top-margin", "topMargin", 0.0, 0.0, null);
        this.m_OptionManager.add("bottom-margin", "bottomMargin", 0.0, 0.0, null);
        this.m_OptionManager.add("custom-format", "customFormat", new DecimalFormatString(""));
    }

    public void setLabel(String value) {
        this.m_Label = value;
        this.reset();
    }

    public String getLabel() {
        return this.m_Label;
    }

    public String labelTipText() {
        return "The label of the axis.";
    }

    public void setType(Type value) {
        this.m_Type = value;
        this.reset();
    }

    public Type getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of the axis.";
    }

    public void setShowGridLines(boolean value) {
        this.m_ShowGridLines = value;
        this.reset();
    }

    public boolean getShowGridLines() {
        return this.m_ShowGridLines;
    }

    public String showGridLinesTipText() {
        return "If enabled, grid lines are plotted as well.";
    }

    public void setTickGenerator(TickGenerator value) {
        this.m_TickGenerator = value;
        this.reset();
    }

    public TickGenerator getTickGenerator() {
        return this.m_TickGenerator;
    }

    public String tickGeneratorTipText() {
        return "Algorithm for generating the tick positions.";
    }

    public void setNthValueToShow(int value) {
        if (value >= 0) {
            this.m_NthValueToShow = value;
            this.reset();
        } else {
            this.getLogger().warning("'n-th value to show' must be >=0, provided: " + value);
        }
    }

    public int getNthValueToShow() {
        return this.m_NthValueToShow;
    }

    public String nthValueToShowTipText() {
        return "The count of ticks a value is shown, i.e., '3' means every third tick: 1, 4, 7, ...";
    }

    public void setLengthTicks(int value) {
        if (value > 0) {
            this.m_LengthTicks = value;
            this.reset();
        } else {
            System.err.println("Length of ticks must be >0, provided: " + value);
        }
    }

    public int getLengthTicks() {
        return this.m_LengthTicks;
    }

    public String lengthTicksTipText() {
        return "The length in pixels of the ticks to display.";
    }

    public void setTopMargin(double value) {
        if (value >= 0.0) {
            this.m_TopMargin = value;
            this.reset();
        } else {
            System.err.println("Top margin factor must be at least 0.0 (provided: " + value + ")!");
        }
    }

    public double getTopMargin() {
        return this.m_TopMargin;
    }

    public String topMarginTipText() {
        return "The factor for an extra margin on the top/left (eg 0.05 = 5%).";
    }

    public void setBottomMargin(double value) {
        if (value >= 0.0) {
            this.m_BottomMargin = value;
            this.reset();
        } else {
            System.err.println("Bottom margin factor must be at least 0.0 (provided: " + value + ")!");
        }
    }

    public double getBottomMargin() {
        return this.m_BottomMargin;
    }

    public String bottomMarginTipText() {
        return "The factor for an extra margin on the bottom/right (eg 0.05 = 5%).";
    }

    public void setWidth(int value) {
        if (value >= 5) {
            this.m_Width = value;
            this.reset();
        } else {
            System.err.println("The width must be at least 5 pixels (provided: " + value + ")!");
        }
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width/height of the axis (>= 5).";
    }

    public void setCustomFormat(DecimalFormatString value) {
        this.m_CustomFormat = value;
        this.reset();
    }

    public DecimalFormatString getCustomFormat() {
        return this.m_CustomFormat;
    }

    public String customFormatTipText() {
        return "The custom format for displaying the tick labels on the axis.";
    }

    public void configure(PlotPanel plot, Axis axis) {
        plot.setAxisWidth(axis, this.m_Width);
        plot.getAxis(axis).setType(this.m_Type);
        plot.getAxis(axis).setShowGridLines(this.m_ShowGridLines);
        plot.getAxis(axis).setTickGenerator((TickGenerator)this.m_TickGenerator.shallowCopy());
        plot.getAxis(axis).setNthValueToShow(this.m_NthValueToShow);
        plot.getAxis(axis).setLengthTicks(this.m_LengthTicks);
        plot.getAxis(axis).setTopMargin(this.m_TopMargin);
        plot.getAxis(axis).setBottomMargin(this.m_BottomMargin);
        plot.getAxis(axis).setAxisName(this.m_Label);
        if (!this.m_CustomFormat.isEmpty()) {
            plot.getAxis(axis).setNumberFormat(this.m_CustomFormat.getValue());
        }
    }
}

