/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core.axis;

import adams.core.logging.LoggingObject;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.axis.FixedLabelTickGenerator;
import adams.gui.visualization.core.axis.Formatter;
import adams.gui.visualization.core.axis.SimpleTickGenerator;
import adams.gui.visualization.core.axis.Tick;
import adams.gui.visualization.core.axis.TickGenerator;
import adams.gui.visualization.core.axis.ZoomHandler;
import java.util.List;
import java.util.Stack;

public abstract class AbstractAxisModel
extends LoggingObject {
    private static final long serialVersionUID = -3950212023344727427L;
    protected AxisPanel m_Parent;
    protected double m_Minimum;
    protected double m_Maximum;
    protected double m_ActualMinimum;
    protected double m_ActualMaximum;
    protected double m_MarginTop;
    protected double m_MarginBottom;
    protected boolean m_Validated;
    protected Formatter m_Formatter;
    protected Formatter m_CustomerFormatter;
    protected ZoomHandler m_ZoomHandler;
    protected int m_PixelOffset;
    protected Stack<Integer> m_PixelOffsets;
    protected TickGenerator m_TickGenerator;
    protected int m_NthValueToShow;

    public AbstractAxisModel() {
        this.initialize();
    }

    protected void initialize() {
        this.m_Parent = null;
        this.m_Minimum = 0.0;
        this.m_Maximum = 1.0;
        this.m_MarginTop = 0.0;
        this.m_MarginBottom = 0.0;
        this.m_PixelOffset = 0;
        this.m_Validated = false;
        this.m_Formatter = Formatter.getDecimalFormatter(this.getDefaultNumberFormat());
        this.m_CustomerFormatter = null;
        this.m_ZoomHandler = new ZoomHandler();
        this.m_PixelOffsets = new Stack();
        this.m_TickGenerator = new SimpleTickGenerator();
    }

    public void setParent(AxisPanel value) {
        this.m_Parent = value;
    }

    public AxisPanel getParent() {
        return this.m_Parent;
    }

    public abstract String getDisplayName();

    public abstract boolean canHandle(double var1, double var3);

    public void setMinimum(double value) {
        this.m_Minimum = value;
        this.invalidate();
        this.update();
    }

    public double getMinimum() {
        return this.m_Minimum;
    }

    public double getActualMinimum() {
        this.validate();
        return this.m_ActualMinimum;
    }

    public void setMaximum(double value) {
        this.m_Maximum = value;
        this.invalidate();
        this.update();
    }

    public double getMaximum() {
        return this.m_Maximum;
    }

    public double getActualMaximum() {
        this.validate();
        return this.m_ActualMaximum;
    }

    public void setTopMargin(double value) {
        if (value >= 0.0) {
            this.m_MarginTop = value;
            this.invalidate();
            this.update();
        } else {
            this.getLogger().warning("Top margin factor must be at least 0.0 (provided: " + value + ")!");
        }
    }

    public double getTopMargin() {
        return this.m_MarginTop;
    }

    public void setBottomMargin(double value) {
        if (value >= 0.0) {
            this.m_MarginBottom = value;
            this.invalidate();
            this.update();
        } else {
            this.getLogger().warning("Bottom margin factor must be at least 0.0 (provided: " + value + ")!");
        }
    }

    public double getBottomMargin() {
        return this.m_MarginBottom;
    }

    public void setPixelOffset(int value) {
        this.m_PixelOffset = value;
        this.invalidate();
        this.update();
    }

    public int getPixelOffset() {
        return this.m_PixelOffset;
    }

    public String getDefaultNumberFormat() {
        return "0.00E0;-0.00E0";
    }

    public void setNumberFormat(String value) {
        this.m_Formatter.applyPattern(value);
        this.update();
    }

    public String getNumberFormat() {
        return this.m_Formatter.toPattern();
    }

    public boolean hasCustomFormatter() {
        return this.m_CustomerFormatter != null;
    }

    public void setCustomFormatter(Formatter value) {
        this.m_CustomerFormatter = value;
    }

    public Formatter getCustomFormatter() {
        return this.m_CustomerFormatter;
    }

    protected Formatter getActualFormatter() {
        if (this.hasCustomFormatter()) {
            return this.m_CustomerFormatter;
        }
        return this.m_Formatter;
    }

    protected double getMinZoomDifference() {
        return 1.0E-7;
    }

    public boolean canZoom(double min, double max) {
        return Math.abs(max - min) > this.getMinZoomDifference();
    }

    public void pushZoom(double min, double max) {
        this.m_ZoomHandler.push(min, max);
        this.m_PixelOffsets.push(this.m_PixelOffset);
        this.m_PixelOffset = 0;
        this.invalidate();
        this.update();
    }

    public void popZoom() {
        if (this.isZoomed()) {
            this.m_ZoomHandler.pop();
            this.m_PixelOffset = this.m_PixelOffsets.pop();
            this.invalidate();
            this.update();
        }
    }

    public boolean isZoomed() {
        return this.m_ZoomHandler.isZoomed();
    }

    public void clearZoom() {
        if (this.isZoomed()) {
            this.m_ZoomHandler.clear();
            this.m_PixelOffset = 0;
            this.m_PixelOffsets.clear();
            this.invalidate();
            this.update();
        }
    }

    public void setTickGenerator(TickGenerator value) {
        this.m_TickGenerator = value;
        this.m_TickGenerator.setParent(this);
        this.update();
    }

    public TickGenerator getTickGenerator() {
        return this.m_TickGenerator;
    }

    public List<Tick> getTicks() {
        return this.m_TickGenerator.getTicks();
    }

    public void setNthValueToShow(int value) {
        if (value >= 0) {
            this.m_NthValueToShow = value;
            this.update();
        } else {
            this.getLogger().warning("'n-th value to show' must be >=0, provided: " + value);
        }
    }

    public int getNthValueToShow() {
        return this.m_NthValueToShow;
    }

    protected abstract String doValueToDisplay(double var1);

    public String valueToDisplay(double value) {
        if (this.m_TickGenerator instanceof FixedLabelTickGenerator) {
            return ((FixedLabelTickGenerator)this.m_TickGenerator).valueToDisplayLabel(value);
        }
        return this.doValueToDisplay(value);
    }

    public abstract int valueToPos(double var1);

    public abstract double posToValue(int var1);

    public void invalidate() {
        this.m_Validated = false;
    }

    public void validate() {
        double max;
        double min;
        if (this.m_Validated) {
            return;
        }
        if (this.m_ZoomHandler.isZoomed()) {
            min = this.m_ZoomHandler.peek().getMinimum();
            max = this.m_ZoomHandler.peek().getMaximum();
        } else {
            min = this.m_Minimum;
            max = this.m_Maximum;
        }
        double size = this.getParent().getLength() == 0 ? 1.0 : (double)this.getParent().getLength();
        double range = Math.abs(max - min);
        double offset = range / size * (double)this.m_PixelOffset;
        this.m_ActualMinimum = min - range * this.m_MarginBottom - offset;
        this.m_ActualMaximum = max + range * this.m_MarginTop - offset;
        this.m_Validated = true;
    }

    public void assign(AbstractAxisModel model) {
        this.m_Parent = model.m_Parent;
        this.m_Minimum = model.m_Minimum;
        this.m_Maximum = model.m_Maximum;
        this.m_MarginTop = model.m_MarginTop;
        this.m_MarginBottom = model.m_MarginBottom;
        this.m_ZoomHandler = model.m_ZoomHandler.getClone();
        this.m_PixelOffsets = (Stack)model.m_PixelOffsets.clone();
        this.m_PixelOffset = model.getPixelOffset();
        this.m_CustomerFormatter = model.m_CustomerFormatter;
        this.m_TickGenerator = (TickGenerator)model.getTickGenerator().shallowCopy();
        this.m_TickGenerator.setParent(this);
        this.m_NthValueToShow = model.getNthValueToShow();
        this.invalidate();
        this.update();
    }

    public void update() {
        this.validate();
        if (this.m_Parent != null) {
            this.m_Parent.repaint();
            this.m_Parent.notifyChangeListeners();
        }
    }

    public String toString() {
        String result = this.getClass().getName() + ": ";
        result = result + "min=" + this.getMinimum() + ", ";
        result = result + "max=" + this.getMaximum() + ", ";
        result = result + "topMargin=" + this.getTopMargin() + ", ";
        result = result + "bottomMargin=" + this.getBottomMargin() + ", ";
        result = result + "format=" + this.getNumberFormat();
        return result;
    }
}

