/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core.axis;

import adams.gui.visualization.core.axis.AbstractAxisModel;
import adams.gui.visualization.core.axis.FlippableAxisModel;
import adams.gui.visualization.core.axis.Formatter;

public abstract class AbstractDateBasedAxisModel
extends AbstractAxisModel
implements FlippableAxisModel {
    private static final long serialVersionUID = 6882846237550109166L;
    protected boolean m_Flipped;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Flipped = false;
        this.m_Formatter = Formatter.getDateFormatter(this.getDefaultDateFormat());
    }

    @Override
    public void assign(AbstractAxisModel model) {
        if (model instanceof FlippableAxisModel) {
            this.m_Flipped = ((FlippableAxisModel)((Object)model)).isFlipped();
        }
        super.assign(model);
    }

    @Override
    public boolean canHandle(double min, double max) {
        return true;
    }

    protected abstract String getDefaultDateFormat();

    @Override
    public abstract String getDisplayName();

    @Override
    public void setFlipped(boolean value) {
        this.m_Flipped = value;
        this.invalidate();
        this.update();
    }

    @Override
    public boolean isFlipped() {
        return this.m_Flipped;
    }

    @Override
    protected String doValueToDisplay(double value) {
        return this.getActualFormatter().format(value);
    }

    @Override
    public int valueToPos(double value) {
        this.validate();
        int size = this.getParent().getLength() - 1;
        int result = (int)Math.round((value - this.m_ActualMinimum) / (this.m_ActualMaximum - this.m_ActualMinimum) * (double)size);
        if (this.m_Flipped) {
            result = this.getParent().getLength() - 1 - result;
        }
        return result;
    }

    @Override
    public double posToValue(int pos) {
        this.validate();
        if (this.m_Flipped) {
            pos = this.getParent().getLength() - 1 - pos;
        }
        int size = this.getParent().getLength() - 1;
        double result = (double)pos / (double)size * (this.m_ActualMaximum - this.m_ActualMinimum) + this.m_ActualMinimum;
        return result;
    }

    @Override
    public void pushZoom(double min, double max) {
        if (this.m_Flipped) {
            super.pushZoom(max, min);
        } else {
            super.pushZoom(min, max);
        }
    }
}

