/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug.propertyextractor;

import adams.gui.goe.Editors;
import adams.gui.visualization.debug.propertyextractor.AbstractPropertyExtractor;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;

public class DefaultPropertyExtractor
extends AbstractPropertyExtractor {
    protected PropertyDescriptor[] m_Properties;

    @Override
    public boolean handles(Class cls) {
        return !Editors.isBlacklisted(cls, false);
    }

    @Override
    protected void initialize() {
        super.initialize();
        try {
            BeanInfo bi = Introspector.getBeanInfo(this.m_Current.getClass());
            this.m_Properties = bi.getPropertyDescriptors();
        }
        catch (Exception e) {
            System.err.println("Failed to obtain bean property descriptors for class " + this.m_Current.getClass().getName() + ":");
            e.printStackTrace();
            this.m_Properties = new PropertyDescriptor[0];
        }
    }

    @Override
    public int size() {
        return this.m_Properties.length;
    }

    @Override
    public Object getValue(int index) {
        Object result = null;
        if (Editors.isBlacklisted(this.m_Current.getClass(), this.m_Properties[index].getDisplayName())) {
            return result;
        }
        if (this.m_Properties[index].getReadMethod() != null && this.m_Properties[index].getWriteMethod() != null) {
            try {
                result = this.m_Properties[index].getReadMethod().invoke(this.m_Current, new Object[0]);
            }
            catch (Exception e) {
                System.err.println("Failed to obtain current value for " + this.m_Current.getClass().getName() + "/" + this.m_Properties[index].getDisplayName() + ":");
                e.printStackTrace();
                result = null;
            }
        }
        return result;
    }

    @Override
    public String getLabel(int index) {
        return this.m_Properties[index].getDisplayName();
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_Properties = null;
    }
}

