/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image;

import adams.core.Properties;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionUtils;
import adams.data.image.AbstractImage;
import adams.data.image.AbstractImageTransformer;
import adams.data.image.BufferedImageContainer;
import adams.env.Environment;
import adams.env.Modules;
import adams.gui.chooser.ImageFileChooser;
import adams.gui.core.BaseMenu;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.MouseUtils;
import adams.gui.core.RecentFilesHandler;
import adams.gui.core.TitleGenerator;
import adams.gui.core.Undo;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import adams.gui.visualization.core.PopupMenuCustomizer;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.plugins.AbstractImageViewerPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ImageViewerPanel
extends BasePanel
implements MenuBarProvider,
SendToActionSupporter {
    private static final long serialVersionUID = -7291572371004753723L;
    public static final String FILENAME = "ImageViewer.props";
    public static final String SESSION_FILE = "ImageViewerSession.props";
    protected static Properties m_Properties;
    protected ImageViewerPanel m_Self;
    protected ImageFileChooser m_FileChooser;
    protected PopupMenuCustomizer m_PopupMenuCustomizer;
    protected JMenuBar m_MenuBar;
    protected JMenu m_MenuItemFileLoadRecent;
    protected JMenuItem m_MenuItemFileSaveAs;
    protected JMenuItem m_MenuItemFileClose;
    protected JCheckBoxMenuItem m_MenuItemEditEnableUndo;
    protected JMenuItem m_MenuItemEditUndo;
    protected JMenuItem m_MenuItemEditRedo;
    protected JMenuItem m_MenuItemEditCopy;
    protected JMenuItem m_MenuItemImageRotateLeft;
    protected JMenuItem m_MenuItemImageRotateRight;
    protected JMenuItem m_MenuItemImageFlipHorizontally;
    protected JMenuItem m_MenuItemImageFlipVertically;
    protected JMenu m_MenuViewZoom;
    protected JMenuItem m_MenuItemViewZoomIn;
    protected JMenuItem m_MenuItemViewZoomOut;
    protected JMenuItem m_MenuItemViewBackgroundColor;
    protected JMenuItem m_MenuItemViewShowProperties;
    protected BaseMenu m_MenuPlugins;
    protected Vector<AbstractImageViewerPlugin> m_Plugins;
    protected Vector<JMenuItem> m_MenuItemPlugins;
    protected BaseTabbedPane m_TabbedPane;
    protected RecentFilesHandler<JMenu> m_RecentFilesHandler;
    protected TitleGenerator m_TitleGenerator;
    protected boolean m_ImagingModulePresent;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Self = this;
        this.m_FileChooser = new ImageFileChooser();
        this.m_FileChooser.setCurrentDirectory(new File(ImageViewerPanel.getProperties().getPath("InitialDir", "%h")));
        this.m_FileChooser.setAutoAppendExtension(true);
        this.m_FileChooser.setMultiSelectionEnabled(true);
        this.m_PopupMenuCustomizer = null;
        this.m_RecentFilesHandler = null;
        this.m_TitleGenerator = new TitleGenerator("Image viewer", true);
        this.m_MenuItemPlugins = new Vector();
        this.m_Plugins = new Vector();
        this.m_ImagingModulePresent = Modules.getSingleton().isAvailable("adams-imaging");
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_TabbedPane = new BaseTabbedPane(){
            private static final long serialVersionUID = -2247884686333300541L;

            @Override
            protected boolean canCloseTabWithMiddleMouseButton(int index) {
                return ImageViewerPanel.this.checkForModified((ImagePanel)ImageViewerPanel.this.m_TabbedPane.getComponentAt(index));
            }
        };
        this.m_TabbedPane.setCloseTabsWithMiddelMouseButton(true);
        this.m_TabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ImageViewerPanel.this.getCurrentPanel() != null) {
                    ImageViewerPanel.this.getCurrentPanel().showStatus("");
                }
                ImageViewerPanel.this.update();
            }
        });
        this.add((Component)this.m_TabbedPane, "Center");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!MouseUtils.isPrintScreenClick(e) && MouseUtils.isRightClick(e)) {
                    JPopupMenu menu = ImageViewerPanel.this.getPopupMenu(e);
                    menu.show(ImageViewerPanel.this.m_Self, e.getX(), e.getY());
                }
            }
        });
    }

    protected void update() {
        this.updateTitle();
        this.updateTabTitle();
        this.updateMenu();
    }

    protected void updateTabTitle() {
        int index = this.m_TabbedPane.getSelectedIndex();
        if (index >= 0) {
            String title = this.m_TabbedPane.getTitleAt(index);
            boolean modified = title.startsWith("*");
            if (modified) {
                title = title.substring(1);
            }
            if (this.getCurrentPanel().isModified() != modified) {
                if (this.getCurrentPanel().isModified()) {
                    title = "*" + title;
                }
                this.m_TabbedPane.setTitleAt(index, title);
            }
        }
    }

    protected void updateTitle() {
        boolean modified = false;
        if (this.getCurrentPanel() != null) {
            modified = this.getCurrentPanel().isModified();
        }
        this.setParentTitle(this.m_TitleGenerator.generate(this.getCurrentFile(), modified));
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        boolean imageAvailable = this.getCurrentImage() != null;
        ImagePanel panel = this.getCurrentPanel();
        this.m_MenuItemFileLoadRecent.setEnabled(this.m_RecentFilesHandler.size() > 0);
        this.m_MenuItemFileSaveAs.setEnabled(imageAvailable);
        this.m_MenuItemFileClose.setEnabled(imageAvailable);
        this.m_MenuItemEditEnableUndo.setEnabled(panel != null);
        this.m_MenuItemEditEnableUndo.setSelected(panel != null && panel.getUndo().isEnabled());
        this.m_MenuItemEditUndo.setEnabled(panel != null && panel.getUndo().canUndo());
        if (panel != null && panel.getUndo().canUndo()) {
            this.m_MenuItemEditUndo.setText("Undo - " + panel.getUndo().peekUndoComment(true));
            this.m_MenuItemEditUndo.setToolTipText(panel.getUndo().peekUndoComment());
        } else {
            this.m_MenuItemEditUndo.setText("Undo");
            this.m_MenuItemEditUndo.setToolTipText(null);
        }
        this.m_MenuItemEditRedo.setEnabled(panel != null && panel.getUndo().canRedo());
        if (panel != null && panel.getUndo().canRedo()) {
            this.m_MenuItemEditRedo.setText("Redo - " + panel.getUndo().peekRedoComment(true));
            this.m_MenuItemEditRedo.setToolTipText(panel.getUndo().peekRedoComment());
        } else {
            this.m_MenuItemEditRedo.setText("Redo");
            this.m_MenuItemEditRedo.setToolTipText(null);
        }
        this.m_MenuItemEditCopy.setEnabled(imageAvailable);
        this.m_MenuItemImageRotateLeft.setEnabled(imageAvailable);
        this.m_MenuItemImageRotateRight.setEnabled(imageAvailable);
        this.m_MenuItemImageFlipHorizontally.setEnabled(imageAvailable);
        this.m_MenuItemImageFlipVertically.setEnabled(imageAvailable);
        this.m_MenuViewZoom.setEnabled(imageAvailable);
        this.m_MenuItemViewZoomIn.setEnabled(imageAvailable);
        this.m_MenuItemViewZoomOut.setEnabled(imageAvailable);
        this.m_MenuItemViewBackgroundColor.setEnabled(imageAvailable);
        this.m_MenuItemViewShowProperties.setSelected(imageAvailable && this.getCurrentPanel().getShowProperties());
        this.m_MenuItemViewShowProperties.setEnabled(imageAvailable);
        for (int i = 0; i < this.m_Plugins.size(); ++i) {
            boolean enabled = this.m_Plugins.get(i).canExecute(this.getCurrentPanel());
            this.m_MenuItemPlugins.get(i).setEnabled(enabled);
        }
    }

    public ImagePanel getCurrentPanel() {
        ImagePanel result = null;
        int index = this.m_TabbedPane.getSelectedIndex();
        if (index >= 0) {
            result = (ImagePanel)this.m_TabbedPane.getComponentAt(index);
        }
        return result;
    }

    public BufferedImage getCurrentImage() {
        BufferedImage result = null;
        if (this.getCurrentPanel() != null) {
            result = this.getCurrentPanel().getCurrentImage();
        }
        return result;
    }

    public File getCurrentFile() {
        File result = null;
        if (this.getCurrentPanel() != null) {
            result = this.getCurrentPanel().getCurrentFile();
        }
        return result;
    }

    @Override
    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            int i;
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ImageViewerPanel.this.updateMenu();
                }
            });
            JMenuItem menuitem = new JMenuItem("Open...");
            menu.add(menuitem);
            menuitem.setMnemonic('O');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed O"));
            menuitem.setIcon(GUIHelper.getIcon("open.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerPanel.this.open();
                }
            });
            JMenu submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentFilesHandler = new RecentFilesHandler<JMenu>(SESSION_FILE, ImageViewerPanel.getProperties().getInteger("MaxRecentImages", 5), submenu);
            this.m_RecentFilesHandler.addRecentItemListener(new RecentItemListener<JMenu, File>(){

                @Override
                public void recentItemAdded(RecentItemEvent<JMenu, File> e) {
                }

                @Override
                public void recentItemSelected(RecentItemEvent<JMenu, File> e) {
                    ImageViewerPanel.this.load(e.getItem());
                }
            });
            this.m_MenuItemFileLoadRecent = submenu;
            menuitem = new JMenuItem("Save as...");
            menu.add(menuitem);
            menuitem.setMnemonic('v');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl shift pressed S"));
            menuitem.setIcon(GUIHelper.getIcon("save.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerPanel.this.saveAs();
                }
            });
            this.m_MenuItemFileSaveAs = menuitem;
            menuitem = new JMenuItem("Close tab");
            menu.add(menuitem);
            menuitem.setMnemonic('t');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed W"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerPanel.this.close();
                }
            });
            this.m_MenuItemFileClose = menuitem;
            menu.addSeparator();
            if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, menu)) {
                menu.addSeparator();
            }
            menuitem = new JMenuItem("Close");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon("exit.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerPanel.this.exit();
                }
            });
            menu = new JMenu("Edit");
            result.add(menu);
            menu.setMnemonic('E');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ImageViewerPanel.this.updateMenu();
                }
            });
            menuitem = new JCheckBoxMenuItem("Undo enabled");
            menu.add(menuitem);
            menuitem.setMnemonic('n');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerPanel.this.getCurrentPanel().getUndo().setEnabled(!ImageViewerPanel.this.getCurrentPanel().getUndo().isEnabled());
                }
            });
            this.m_MenuItemEditEnableUndo = (JCheckBoxMenuItem)menuitem;
            menuitem = new JMenuItem("Undo");
            menu.add(menuitem);
            menuitem.setMnemonic('U');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Z"));
            menuitem.setIcon(GUIHelper.getIcon("undo.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerPanel.this.undo();
                }
            });
            this.m_MenuItemEditUndo = menuitem;
            menuitem = new JMenuItem("Redo");
            menu.add(menuitem);
            menuitem.setMnemonic('R');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Y"));
            menuitem.setIcon(GUIHelper.getIcon("redo.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerPanel.this.redo();
                }
            });
            this.m_MenuItemEditRedo = menuitem;
            menuitem = new JMenuItem("Copy");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed C"));
            menuitem.setIcon(GUIHelper.getIcon("copy.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerPanel.this.copy();
                }
            });
            this.m_MenuItemEditCopy = menuitem;
            menu = new JMenu("Image");
            menu.setVisible(this.m_ImagingModulePresent);
            result.add(menu);
            menu.setMnemonic('I');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ImageViewerPanel.this.updateMenu();
                }
            });
            menuitem = new JMenuItem("Rotate left");
            menu.add(menuitem);
            menuitem.setMnemonic('l');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed L"));
            menuitem.setIcon(GUIHelper.getIcon("rotate_left.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerPanel.this.rotate(true);
                }
            });
            this.m_MenuItemImageRotateLeft = menuitem;
            menuitem = new JMenuItem("Rotate right");
            menu.add(menuitem);
            menuitem.setMnemonic('r');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed R"));
            menuitem.setIcon(GUIHelper.getIcon("rotate_right.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerPanel.this.rotate(false);
                }
            });
            this.m_MenuItemImageRotateRight = menuitem;
            menuitem = new JMenuItem("Flip horizontally");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('h');
            menuitem.setIcon(GUIHelper.getIcon("flip_horizontal.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerPanel.this.flip(true);
                }
            });
            this.m_MenuItemImageFlipHorizontally = menuitem;
            menuitem = new JMenuItem("Flip vertically");
            menu.add(menuitem);
            menuitem.setMnemonic('v');
            menuitem.setIcon(GUIHelper.getIcon("flip_vertical.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerPanel.this.flip(false);
                }
            });
            this.m_MenuItemImageFlipVertically = menuitem;
            menu = new JMenu("View");
            result.add(menu);
            menu.setMnemonic('V');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ImageViewerPanel.this.updateMenu();
                }
            });
            submenu = new JMenu("Zoom");
            menu.add(submenu);
            submenu.setMnemonic('Z');
            submenu.setIcon(GUIHelper.getIcon("glasses.gif"));
            submenu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ImageViewerPanel.this.updateMenu();
                }
            });
            this.m_MenuViewZoom = submenu;
            menuitem = new JMenuItem("Zoom in");
            submenu.add(menuitem);
            menuitem.setMnemonic('i');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl shift pressed I"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerPanel.this.getCurrentPanel().setScale(ImageViewerPanel.this.getCurrentPanel().getScale() * 1.5);
                }
            });
            this.m_MenuItemViewZoomIn = menuitem;
            menuitem = new JMenuItem("Zoom out");
            submenu.add(menuitem);
            menuitem.setMnemonic('o');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl shift pressed O"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerPanel.this.getCurrentPanel().setScale(ImageViewerPanel.this.getCurrentPanel().getScale() / 1.5);
                }
            });
            this.m_MenuItemViewZoomOut = menuitem;
            int[] zooms = new int[]{25, 50, 66, 75, 100, 150, 200, 400, 800};
            String[] shortcuts = new String[]{"", "", "", "", "1", "", "2", "4", ""};
            submenu.addSeparator();
            for (i = 0; i < zooms.length; ++i) {
                final int fZoom = zooms[i];
                menuitem = new JMenuItem(zooms[i] + "%");
                submenu.add(menuitem);
                if (shortcuts[i].length() > 0) {
                    menuitem.setAccelerator(GUIHelper.getKeyStroke(shortcuts[i]));
                }
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ImageViewerPanel.this.zoom(fZoom);
                    }
                });
            }
            menuitem = new JMenuItem("Background color...");
            menu.add(menuitem);
            menuitem.setIcon(GUIHelper.getIcon("colorpicker.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerPanel.this.chooseBackgroundColor();
                }
            });
            this.m_MenuItemViewBackgroundColor = menuitem;
            menuitem = new JCheckBoxMenuItem("Show properties");
            menu.add(menuitem);
            menuitem.setIcon(GUIHelper.getIcon("properties.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageViewerPanel.this.getCurrentPanel().setShowProperties(!ImageViewerPanel.this.getCurrentPanel().getShowProperties());
                }
            });
            this.m_MenuItemViewShowProperties = menuitem;
            String[] plugins = AbstractImageViewerPlugin.getPlugins();
            menu = new BaseMenu("Plugins");
            result.add(menu);
            menu.setMnemonic('P');
            menu.setVisible(plugins.length > 0);
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ImageViewerPanel.this.updateMenu();
                }
            });
            this.m_MenuPlugins = (BaseMenu)menu;
            this.m_MenuItemPlugins.clear();
            this.m_Plugins.clear();
            for (i = 0; i < plugins.length; ++i) {
                try {
                    final AbstractImageViewerPlugin plugin = (AbstractImageViewerPlugin)Class.forName(plugins[i]).newInstance();
                    menuitem = new JMenuItem(plugin.getCaption());
                    menu.add(menuitem);
                    menuitem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ImageViewerPanel.this.getCurrentPanel().addUndoPoint("Saving undo data...", "Plugin: " + plugin.getCaption());
                            String error = plugin.execute(ImageViewerPanel.this.getCurrentPanel());
                            if (error != null) {
                                GUIHelper.showErrorMessage(ImageViewerPanel.this.getCurrentPanel(), "Error occurred executing plugin '" + plugin.getCaption() + "':\n" + error);
                            }
                            ImageViewerPanel.this.update();
                        }
                    });
                    this.m_Plugins.add(plugin);
                    this.m_MenuItemPlugins.add(menuitem);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Failed to install plugin '" + plugins[i] + "':");
                    e.printStackTrace();
                }
            }
            this.m_MenuPlugins.sort();
            this.m_MenuBar = result;
            this.updateMenu();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    protected void open() {
        File[] files;
        int retVal = this.m_FileChooser.showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        for (File file : files = this.m_FileChooser.getSelectedFiles()) {
            this.load(file);
        }
    }

    public void load(File file) {
        ImagePanel panel = new ImagePanel();
        panel.setSelectionEnabled(true);
        if (!panel.load(file)) {
            GUIHelper.showErrorMessage(this, "Failed to open image '" + file + "'!");
        } else {
            panel.setScale(ImageViewerPanel.getProperties().getDouble("ZoomLevel") / 100.0);
            this.m_TabbedPane.addTab(file.getName(), panel);
            this.m_TabbedPane.setSelectedComponent(panel);
            if (this.m_RecentFilesHandler != null) {
                this.m_RecentFilesHandler.addRecentItem(file);
            }
        }
        this.update();
    }

    protected void saveAs() {
        int index = this.m_TabbedPane.getSelectedIndex();
        if (index < 0) {
            return;
        }
        ImagePanel panel = (ImagePanel)this.m_TabbedPane.getComponentAt(index);
        this.m_FileChooser.setSelectedFile(this.getCurrentFile());
        int retVal = this.m_FileChooser.showSaveDialog(this);
        if (retVal != 0) {
            return;
        }
        File file = this.m_FileChooser.getSelectedFile();
        if (!panel.save(file)) {
            GUIHelper.showErrorMessage(this, "Failed to write image to '" + file + "'!");
        } else if (this.m_RecentFilesHandler != null) {
            this.m_RecentFilesHandler.addRecentItem(file);
        }
        this.update();
    }

    protected boolean checkForModified(ImagePanel panel) {
        boolean result;
        if (panel == null) {
            return true;
        }
        boolean bl = result = !panel.isModified();
        if (!result) {
            String msg = this.getCurrentFile() == null ? "Image not saved - save?" : "Image not saved - save?\n" + this.getCurrentFile();
            int retVal = GUIHelper.showConfirmMessage(this, msg, "Image not saved");
            switch (retVal) {
                case 0: {
                    this.saveAs();
                    result = !panel.isModified();
                    break;
                }
                case 1: {
                    result = true;
                    break;
                }
                case 2: {
                    result = false;
                }
            }
        }
        return result;
    }

    protected void close() {
        int index = this.m_TabbedPane.getSelectedIndex();
        boolean canClose = false;
        if (index >= 0) {
            canClose = this.checkForModified(this.getCurrentPanel());
        }
        if (canClose) {
            this.m_TabbedPane.remove(index);
            this.update();
        }
    }

    protected void exit() {
        int i = 0;
        while (i < this.m_TabbedPane.getTabCount()) {
            if (!this.checkForModified((ImagePanel)this.m_TabbedPane.getComponentAt(i))) {
                return;
            }
            this.m_TabbedPane.remove(i);
        }
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
            this.getParentFrame().dispose();
        } else if (this.getParentDialog() != null) {
            this.getParentDialog().setVisible(false);
            this.getParentDialog().dispose();
        }
    }

    protected void copy() {
        GUIHelper.copyToClipboard(this.getCurrentImage());
    }

    protected void applyJAITransformer(String cmd, String operation) {
        this.getCurrentPanel().addUndoPoint("Saving undo data...", operation);
        try {
            BufferedImageContainer cont = new BufferedImageContainer();
            cont.setImage(this.getCurrentImage());
            AbstractImageTransformer transformer = (AbstractImageTransformer)OptionUtils.forCommandLine(AbstractImageTransformer.class, cmd);
            AbstractImage[] trans = transformer.transform(cont);
            if (trans.length > 0) {
                this.getCurrentPanel().setCurrentImage(trans[0]);
            } else {
                GUIHelper.showErrorMessage(this, "Failed to " + operation + "?");
            }
        }
        catch (Exception e) {
            String msg = "Failed to " + operation + ":\n" + Utils.throwableToString(e);
            GUIHelper.showErrorMessage(this, msg);
            ConsolePanel.getSingleton().append(ConsolePanel.OutputType.ERROR, msg);
        }
    }

    protected void rotate(boolean left) {
        String cmd = "adams.data.jai.transformer.Rotate -angle ";
        cmd = left ? cmd + "270" : cmd + "90";
        this.applyJAITransformer(cmd, "rotate image");
    }

    protected void flip(boolean horizontal) {
        String cmd = "adams.data.jai.transformer.Flip -direction ";
        cmd = horizontal ? cmd + "HORIZONTAL" : cmd + "VERTICAL";
        this.applyJAITransformer(cmd, "flip image");
    }

    protected void zoom(int zoom) {
        this.getCurrentPanel().setScale((double)zoom / 100.0);
    }

    protected void chooseBackgroundColor() {
        Color bgcolor = JColorChooser.showDialog(this, "Background color", this.getCurrentPanel().getBackgroundColor());
        if (bgcolor == null) {
            return;
        }
        this.getCurrentPanel().setBackgroundColor(bgcolor);
    }

    public void setPopupMenuCustomizer(PopupMenuCustomizer value) {
        this.m_PopupMenuCustomizer = value;
    }

    public PopupMenuCustomizer getPopupMenuCustomizer() {
        return this.m_PopupMenuCustomizer;
    }

    public JPopupMenu getPopupMenu(MouseEvent e) {
        JPopupMenu result = new JPopupMenu();
        if (this.m_PopupMenuCustomizer != null) {
            this.m_PopupMenuCustomizer.customizePopupMenu(e, result);
        }
        return result;
    }

    @Override
    public Class[] getSendToClasses() {
        return new Class[]{PlaceholderFile.class, JComponent.class};
    }

    @Override
    public boolean hasSendToItem(Class[] cls) {
        return this.getCurrentImage() != null;
    }

    @Override
    public Object getSendToItem(Class[] cls) {
        Serializable result = null;
        File file = this.getCurrentFile();
        if (SendToActionUtils.isAvailable(PlaceholderFile.class, cls)) {
            if (file == null && this.getCurrentImage() != null) {
                result = SendToActionUtils.nextTmpFile("imageviewer", "png");
                this.getCurrentPanel().save((File)result);
                this.getCurrentPanel().setCurrentImage(this.getCurrentPanel().getCurrentImage());
            } else if (file != null) {
                result = new PlaceholderFile(file);
            }
        } else if (SendToActionUtils.isAvailable(JComponent.class, cls) && this.getCurrentPanel() != null) {
            result = this.getCurrentPanel().getPaintPanel();
        }
        return result;
    }

    public void undo() {
        ImagePanel panel = this.getCurrentPanel();
        if (panel == null) {
            return;
        }
        if (!panel.getUndo().canUndo()) {
            return;
        }
        panel.showStatus("Performing Undo...");
        panel.getUndo().addRedo(panel.getState(), panel.getUndo().peekUndoComment());
        Undo.UndoPoint point = panel.getUndo().undo();
        panel.setState((Vector)point.getData());
        this.update();
        panel.showStatus("");
    }

    public void redo() {
        ImagePanel panel = this.getCurrentPanel();
        if (panel == null) {
            return;
        }
        if (!panel.getUndo().canRedo()) {
            return;
        }
        panel.showStatus("Performing Redo...");
        panel.getUndo().addUndo(panel.getState(), panel.getUndo().peekRedoComment(), true);
        Undo.UndoPoint point = panel.getUndo().redo();
        panel.setState((Vector)point.getData());
        this.update();
        panel.showStatus("");
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("image viewer panel");
        }
        return m_Properties;
    }
}

