/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.sequence;

import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.data.sequence.XYSequenceUtils;
import adams.gui.visualization.container.VisibilityContainer;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.AbstractXYSequencePointHitDetector;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import adams.gui.visualization.sequence.XYSequencePanel;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Vector;

public class XYSequenceLineHitDetector
extends AbstractXYSequencePointHitDetector {
    private static final long serialVersionUID = -6387662418337280157L;

    public XYSequenceLineHitDetector(XYSequencePanel owner) {
        super(owner);
    }

    @Override
    protected Object isHit(MouseEvent e) {
        Vector<XYSequencePoint> result = new Vector<XYSequencePoint>();
        AxisPanel axisBottom = this.m_Owner.getPlot().getAxis(Axis.BOTTOM);
        AxisPanel axisLeft = this.m_Owner.getPlot().getAxis(Axis.LEFT);
        double y = axisLeft.posToValue(e.getY());
        double x = axisBottom.posToValue(e.getX());
        boolean logging = this.isLoggingEnabled();
        for (int i = 0; i < ((XYSequenceContainerManager)this.m_Owner.getContainerManager()).count(); ++i) {
            XYSequencePoint sp;
            int[] indices;
            if (!((VisibilityContainer)((XYSequenceContainerManager)this.m_Owner.getContainerManager()).get(i)).isVisible()) continue;
            XYSequence s = ((XYSequenceContainer)((XYSequenceContainerManager)this.m_Owner.getContainerManager()).get(i)).getData();
            List<XYSequencePoint> points = s.toList();
            if (logging) {
                this.getLogger().info("\n" + s.getID() + ":");
            }
            if ((indices = XYSequenceUtils.findEnclosingXs(points, x))[0] == -1 || indices[1] == -1) {
                int index = XYSequenceUtils.findClosestX(points, x);
                if (index == -1) continue;
                sp = points.get(index);
                double diffX = sp.getX() - x;
                double diffPixel = Math.abs(axisBottom.valueToPos(diffX) - axisBottom.valueToPos(0.0));
                if (logging) {
                    this.getLogger().info("diff x=" + diffPixel);
                }
                if (diffPixel > (double)this.m_MinimumPixelDifference) continue;
                double diffY = sp.getY() - y;
                diffPixel = Math.abs(axisLeft.valueToPos(diffY) - axisLeft.valueToPos(0.0));
                if (logging) {
                    this.getLogger().info("diff y=" + diffPixel);
                }
                if (diffPixel > (double)this.m_MinimumPixelDifference) {
                    continue;
                }
            } else {
                sp = points.get(indices[0]);
                XYSequencePoint sp2 = points.get(indices[1]);
                double dist = this.distance(new Point2D.Double(axisBottom.valueToPos(sp.getX()), axisLeft.valueToPos(sp.getY())), new Point2D.Double(axisBottom.valueToPos(sp2.getX()), axisLeft.valueToPos(sp2.getY())), new Point2D.Double(e.getX(), e.getY()));
                if (logging) {
                    this.getLogger().info("dist line=" + dist);
                }
                if (dist > (double)this.m_MinimumPixelDifference) continue;
            }
            if (logging) {
                this.getLogger().info("hit!");
            }
            result.add(sp);
        }
        if (result.size() > 0) {
            return result;
        }
        return null;
    }
}

