/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.sequence;

import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.sequence.AbstractXYSequencePaintlet;
import adams.gui.visualization.sequence.AbstractXYSequencePointHitDetector;
import adams.gui.visualization.sequence.PaintletWithFixedXRange;
import adams.gui.visualization.sequence.XYSequenceLinePaintlet;
import adams.gui.visualization.sequence.XYSequencePaintlet;
import java.awt.Graphics;

public class XYSequencePaintletWithFixedXRange
extends AbstractXYSequencePaintlet
implements PaintletWithFixedXRange {
    private static final long serialVersionUID = 3270329510617886683L;
    protected double m_MinX;
    protected double m_MaxX;
    protected XYSequencePaintlet m_Paintlet;

    @Override
    public String globalInfo() {
        return "Meta-paintlet that uses a fixed X range (for faster drawing) and a base-paintlet to draw the actual data.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("min-x", "minX", 0.0, null, null);
        this.m_OptionManager.add("max-x", "maxX", 1000.0, null, null);
        this.m_OptionManager.add("paintlet", "paintlet", this.getDefaultPaintlet());
    }

    @Override
    protected void initialize() {
        this.setPaintlet(this.getDefaultPaintlet());
        super.initialize();
    }

    protected XYSequencePaintlet getDefaultPaintlet() {
        return new XYSequenceLinePaintlet();
    }

    @Override
    public void setPanel(PaintablePanel value) {
        if (this.m_Paintlet != null) {
            this.m_Paintlet.setPanel(value);
        }
        super.setPanel(value);
    }

    public void setMinX(double value) {
        this.m_MinX = value;
        this.memberChanged(true);
    }

    @Override
    public double getMinX() {
        return this.m_MinX;
    }

    public String minXTipText() {
        return "The minimum value for the X range.";
    }

    public void setMaxX(double value) {
        this.m_MaxX = value;
        this.memberChanged(true);
    }

    @Override
    public double getMaxX() {
        return this.m_MaxX;
    }

    public String maxXTipText() {
        return "The maximum value for the X range.";
    }

    public void setPaintlet(XYSequencePaintlet value) {
        if (this.m_Paintlet != null) {
            this.m_Paintlet.setPanel(null);
        }
        this.m_Paintlet = value;
        this.m_Paintlet.setPanel(this.getPanel());
        this.memberChanged();
    }

    public XYSequencePaintlet getPaintlet() {
        return this.m_Paintlet;
    }

    public String paintletTipText() {
        return "The actual paintlet to use for drawing the data.";
    }

    @Override
    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        this.m_Paintlet.performPaint(g, moment);
    }

    @Override
    public AbstractXYSequencePointHitDetector newHitDetector() {
        return this.m_Paintlet.newHitDetector();
    }
}

