/*
 * Decompiled with CFR 0.152.
 */
package adams.parser;

import adams.parser.AbstractExpressionEvaluator;
import adams.parser.basetime.Parser;
import adams.parser.basetime.Scanner;
import java.io.ByteArrayInputStream;
import java.util.Date;
import java.util.logging.Level;
import java_cup.runtime.DefaultSymbolFactory;
import java_cup.runtime.SymbolFactory;

public class BaseTimeExpression
extends AbstractExpressionEvaluator<Date> {
    private static final long serialVersionUID = -5923987640355752595L;

    @Override
    public String globalInfo() {
        return "Evaluates time expressions.\n\nFormat:\n" + this.getGrammar() + "\n" + "\n" + "Examples:\n" + "01:02:03\n" + "01:02:03 +1 MINUTE\n" + "NOW\n" + "+INF\n" + "NOW +1 HOUR\n" + "NOW +14 MINUTE\n" + "NOW +(2*3) MINUTE\n" + "\n" + "Amounts can be chained as well:\n" + "NOW -1 MINUTE +1 HOUR\n" + "\n" + "START and END can only be set programmatically; by default they are equal to -INF and +INF.";
    }

    @Override
    public String getGrammar() {
        return "(<date>|NOW|-INF|+INF|START|END) [expr (SECOND|MINUTE|HOUR)]*\nexpr ::=   ( expr )\n         | - expr\n         | + expr\n         | expr + expr\n         | expr - expr\n         | expr * expr\n         | expr / expr\n         | expr % expr\n         | expr ^ expr\n         | abs ( expr )\n         | sqrt ( expr )\n         | log ( expr )\n         | exp ( expr )\n         | rint ( expr )\n         | floor ( expr )\n         | pow[er] ( expr , expr )\n         | ceil ( expr )\n         | NUMBER\n";
    }

    @Override
    protected String getDefaultExpression() {
        return "NOW";
    }

    @Override
    public String expressionTipText() {
        return "The boolean expression to evaluate (must evaluate to a boolean).";
    }

    protected Object initializeSymbol(String name, String value) {
        Double result;
        try {
            result = new Double(value);
        }
        catch (Exception e) {
            result = null;
            this.getLogger().log(Level.SEVERE, "Failed to parse the value of symbol '" + name + "': " + value, e);
        }
        return result;
    }

    @Override
    public Date evaluate() throws Exception {
        return BaseTimeExpression.evaluate(this.m_Expression);
    }

    public Date evaluate(Date start, Date end) throws Exception {
        return BaseTimeExpression.evaluate(this.m_Expression, start, end);
    }

    public static Date evaluate(String expr) throws Exception {
        return BaseTimeExpression.evaluate(expr, null, null);
    }

    public static Date evaluate(String expr, Date start, Date end) throws Exception {
        DefaultSymbolFactory sf = new DefaultSymbolFactory();
        ByteArrayInputStream parserInput = new ByteArrayInputStream(expr.getBytes());
        Parser parser = new Parser(new Scanner(parserInput, (SymbolFactory)sf), (SymbolFactory)sf);
        parser.setStart(start);
        parser.setEnd(end);
        parser.parse();
        return parser.getResult();
    }

    public static void main(String[] args) {
        BaseTimeExpression.runEvaluator(BaseTimeExpression.class, args);
    }
}

