/*
 * Decompiled with CFR 0.152.
 */
package adams.parser;

import adams.core.DateUtils;
import adams.core.base.BaseDate;
import adams.core.base.BaseDateTime;
import adams.core.base.BaseTime;
import adams.core.logging.LoggingObject;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public class ParserHelper
extends LoggingObject {
    private static final long serialVersionUID = -4265720482014655040L;
    protected HashMap m_Symbols;
    protected Calendar m_Calendar;

    public ParserHelper() {
        this.initialize();
    }

    protected void initialize() {
        this.m_Calendar = DateUtils.getCalendar();
        this.m_Symbols = new HashMap();
    }

    public void setSymbols(HashMap value) {
        this.m_Symbols = value;
    }

    public HashMap getSymbols() {
        return this.m_Symbols;
    }

    public Calendar getCalendar() {
        return this.m_Calendar;
    }

    public Calendar getCalendar(Date date) {
        this.m_Calendar.setTime(date);
        return this.m_Calendar;
    }

    public Double getDateFieldFromString(Object obj, int field) {
        Double result = Double.NaN;
        Date date = null;
        if (obj instanceof String) {
            date = this.toDate((String)obj);
        } else if (obj instanceof Date) {
            date = (Date)obj;
        }
        if (date != null) {
            result = new Double(this.getCalendar(date).get(field));
        }
        return result;
    }

    public Double toDouble(Object obj) {
        if (obj instanceof Double) {
            return (Double)obj;
        }
        return Double.NaN;
    }

    public Integer toInteger(Object obj) {
        if (obj instanceof Double) {
            return ((Double)obj).intValue();
        }
        return Integer.MAX_VALUE;
    }

    public Boolean toBoolean(Object obj) {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    public String toString(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.toString();
    }

    public Date toDate(String s) {
        BaseTime bt;
        Date result = null;
        int posDash = s.indexOf("-");
        int posColon = s.indexOf(":");
        if (posDash > -1 && posColon > -1) {
            BaseDateTime bdt = new BaseDateTime();
            if (bdt.isValid(s)) {
                bdt.setValue(s);
                result = bdt.dateValue();
            }
        } else if (posDash > -1) {
            BaseDate bd = new BaseDate();
            if (bd.isValid(s)) {
                bd.setValue(s);
                result = bd.dateValue();
            }
        } else if (posColon > -1 && (bt = new BaseTime()).isValid(s)) {
            bt.setValue(s);
            result = bt.dateValue();
        }
        return result;
    }

    public Double compare(Object o1, Object o2) {
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            return new Double(((Comparable)o1).compareTo((Comparable)o2));
        }
        return Double.NaN;
    }

    public String substitute(String str, String find, String replace) {
        return this.substitute(str, find, replace, -1);
    }

    public String repeat(String str, int num) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < num; ++i) {
            result.append(str);
        }
        return result.toString();
    }

    public String replace(String str, int pos, int len, String newStr) {
        StringBuilder result = new StringBuilder();
        if (pos > 0) {
            result.append(str.substring(0, pos + 1));
        }
        result.append(newStr);
        result.append(str.substring(pos + len));
        return result.toString();
    }

    public String substitute(String str, String find, String replace, int occurrences) {
        StringBuilder result = new StringBuilder();
        int count = 0;
        while (str.length() > 0) {
            int pos = str.indexOf(find);
            if (pos > -1) {
                ++count;
                result.append(str.substring(0, pos));
                result.append(replace);
                str = str.substring(pos + find.length());
                if (count != occurrences) continue;
                result.append(str);
                break;
            }
            result.append(str);
            break;
        }
        return result.toString();
    }

    public String left(String str, int len) {
        if (str.length() >= len) {
            return str.substring(0, len);
        }
        return str;
    }

    public String mid(String str, int pos, int len) {
        if (str.length() > pos) {
            if (str.length() >= pos + len) {
                return str.substring(pos, pos + len);
            }
            return str.substring(pos);
        }
        return "";
    }

    public String right(String str, int len) {
        if (str.length() >= len) {
            return str.substring(str.length() - len, str.length());
        }
        return str;
    }
}

