/*
 * Decompiled with CFR 0.152.
 */
package adams.parser.spreadsheetformula;

import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.statistics.StatUtils;
import adams.parser.SpreadSheetFormula;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ParserHelper
extends adams.parser.ParserHelper {
    private static final long serialVersionUID = 3412549255873159225L;
    protected SpreadSheet m_Sheet;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Sheet = null;
    }

    public void setSheet(SpreadSheet value) {
        this.m_Sheet = value;
    }

    public SpreadSheet getSheet() {
        return this.m_Sheet;
    }

    public Double toDouble(String loc) throws Exception {
        Cell cell;
        Double result = Double.NaN;
        int[] pos = SpreadSheet.getCellLocation(loc);
        if (this.m_Sheet != null && this.m_Sheet.hasCell(pos[0], pos[1]) && !(cell = this.m_Sheet.getCell(pos[0], pos[1])).isMissing() && cell.isNumeric()) {
            result = cell.toDouble();
        }
        return result;
    }

    public Double getDateFieldFromCell(String loc, int field) throws Exception {
        Double result = Double.NaN;
        Cell cell = this.getCell(loc);
        if (cell != null) {
            result = cell.isDate() ? new Double(this.getCalendar(cell.toDate()).get(field)) : (cell.isDateTime() ? new Double(this.getCalendar(cell.toDateTime()).get(field)) : (cell.isTime() ? new Double(this.getCalendar(cell.toTime()).get(field)) : new Double(this.getCalendar(this.toDate(cell.getContent())).get(field))));
        }
        return result;
    }

    public boolean hasCell(String loc) throws Exception {
        boolean result = false;
        int[] pos = SpreadSheet.getCellLocation(loc);
        if (this.m_Sheet != null) {
            result = this.m_Sheet.hasCell(pos[0], pos[1]);
        }
        return result;
    }

    public Cell getCell(String loc) throws Exception {
        Cell result = null;
        int[] pos = SpreadSheet.getCellLocation(loc);
        if (this.m_Sheet != null && this.m_Sheet.hasCell(pos[0], pos[1])) {
            result = this.m_Sheet.getCell(pos[0], pos[1]);
        }
        return result;
    }

    public List<Cell> rangeToList(String fromCell, String toCell, boolean onlyNumeric) throws Exception {
        ArrayList<Cell> result = new ArrayList<Cell>();
        int[] from = SpreadSheet.getCellLocation(fromCell);
        int[] to = SpreadSheet.getCellLocation(toCell);
        if (this.m_Sheet != null && from[0] <= to[0] && from[1] <= to[1]) {
            for (int i = from[0]; i <= to[0]; ++i) {
                for (int n = from[1]; n <= to[1]; ++n) {
                    Cell cell;
                    if (!this.m_Sheet.hasCell(i, n) || (cell = this.m_Sheet.getCell(i, n)).isMissing() || onlyNumeric && !cell.isNumeric()) continue;
                    result.add(cell);
                }
            }
        }
        return result;
    }

    public Double[] rangeToDoubleArray(String fromCell, String toCell) throws Exception {
        List<Cell> cells = this.rangeToList(fromCell, toCell, true);
        Double[] result = new Double[cells.size()];
        for (int i = 0; i < cells.size(); ++i) {
            result[i] = cells.get(i).toDouble();
        }
        return result;
    }

    public Double sum(String fromCell, String toCell) throws Exception {
        return StatUtils.sum((Number[])this.rangeToDoubleArray(fromCell, toCell));
    }

    public Double min(String fromCell, String toCell) throws Exception {
        return StatUtils.min((Number[])this.rangeToDoubleArray(fromCell, toCell)).doubleValue();
    }

    public Double max(String fromCell, String toCell) throws Exception {
        return StatUtils.max((Number[])this.rangeToDoubleArray(fromCell, toCell)).doubleValue();
    }

    public Double average(String fromCell, String toCell) throws Exception {
        return StatUtils.mean((Number[])this.rangeToDoubleArray(fromCell, toCell));
    }

    public Double stdev(String fromCell, String toCell) throws Exception {
        return StatUtils.stddev((Number[])this.rangeToDoubleArray(fromCell, toCell), true);
    }

    public Double stdevp(String fromCell, String toCell) throws Exception {
        return StatUtils.stddev((Number[])this.rangeToDoubleArray(fromCell, toCell), false);
    }

    public Double countif(String fromCell, String toCell, Double value) throws Exception {
        Double result = 0.0;
        List<Cell> cells = this.rangeToList(fromCell, toCell, true);
        for (Cell cell : cells) {
            if (!cell.isNumeric() || !value.equals(cell.toDouble())) continue;
            Double d = result;
            Double d2 = result = Double.valueOf(result + 1.0);
        }
        return result;
    }

    public Double countif(String fromCell, String toCell, String value) throws Exception {
        Double result = 0.0;
        String expr = (value = value.trim()).startsWith(">") || value.startsWith("<") || value.startsWith("=") || value.startsWith("!") ? value : "=" + value;
        List<Cell> cells = this.rangeToList(fromCell, toCell, false);
        for (Cell cell : cells) {
            Object eval = SpreadSheetFormula.evaluate(cell.getContent() + expr, new HashMap(), this.getSheet());
            if (!(eval instanceof Boolean) || !((Boolean)eval).booleanValue()) continue;
            Double d = result;
            Double d2 = result = Double.valueOf(result + 1.0);
        }
        return result;
    }

    public Double countif(String fromCell, String toCell, Boolean value) throws Exception {
        Double result = 0.0;
        List<Cell> cells = this.rangeToList(fromCell, toCell, false);
        for (Cell cell : cells) {
            if (cell.isBoolean() || !value.equals(cell.toBoolean())) continue;
            Double d = result;
            Double d2 = result = Double.valueOf(result + 1.0);
        }
        return result;
    }

    public Double countif(String fromCell, String toCell, Object value) throws Exception {
        if (value instanceof Double) {
            return this.countif(fromCell, toCell, (Double)value);
        }
        if (value instanceof String) {
            return this.countif(fromCell, toCell, (String)value);
        }
        if (value instanceof Boolean) {
            return this.countif(fromCell, toCell, (Boolean)value);
        }
        return Double.NaN;
    }

    public Double sumif(String fromCell, String toCell, Double value) throws Exception {
        Double result = 0.0;
        List<Cell> cells = this.rangeToList(fromCell, toCell, false);
        for (Cell cell : cells) {
            if (!cell.isNumeric() || !value.equals(cell.toDouble())) continue;
            result = result + cell.toDouble();
        }
        return result;
    }

    public Double sumif(String fromCell, String toCell, String value) throws Exception {
        Double result = 0.0;
        value = value.trim();
        String expr = null;
        if (value.startsWith(">") || value.startsWith("<") || value.startsWith("=") || value.startsWith("!")) {
            expr = value;
        }
        List<Cell> cells = this.rangeToList(fromCell, toCell, false);
        for (Cell cell : cells) {
            if (!cell.isNumeric()) continue;
            if (expr == null) {
                if (!value.equals(cell.getContent())) continue;
                result = result + cell.toDouble();
                continue;
            }
            Object eval = SpreadSheetFormula.evaluate(cell.getContent() + expr, this.getSymbols(), this.getSheet());
            if (!(eval instanceof Boolean) || !((Boolean)eval).booleanValue()) continue;
            result = result + cell.toDouble();
        }
        return result;
    }

    public Double sumif(String fromCell, String toCell, Object value) throws Exception {
        if (value instanceof Double) {
            return this.sumif(fromCell, toCell, (Double)value);
        }
        if (value instanceof String) {
            return this.sumif(fromCell, toCell, (String)value);
        }
        return Double.NaN;
    }

    public Double sumif(String fromCell, String toCell, Double value, String fromSum, String toSum) throws Exception {
        Double result = 0.0;
        List<Cell> cells = this.rangeToList(fromCell, toCell, false);
        List<Cell> cellsSum = this.rangeToList(fromSum, toSum, false);
        if (cells.size() != cellsSum.size()) {
            throw new IllegalArgumentException("Search cell range and summ cell range have different length: " + cells.size() + " != " + cellsSum.size());
        }
        for (int i = 0; i < cells.size(); ++i) {
            if (!cells.get(i).isNumeric() || !cellsSum.get(i).isNumeric() || !value.equals(cells.get(i).toDouble())) continue;
            result = result + cellsSum.get(i).toDouble();
        }
        return result;
    }

    public Double sumif(String fromCell, String toCell, String value, String fromSum, String toSum) throws Exception {
        Double result = 0.0;
        value = value.trim();
        String expr = null;
        if (value.startsWith(">") || value.startsWith("<") || value.startsWith("=") || value.startsWith("!")) {
            expr = value;
        }
        List<Cell> cells = this.rangeToList(fromCell, toCell, false);
        List<Cell> cellsSum = this.rangeToList(fromSum, toSum, false);
        if (cells.size() != cellsSum.size()) {
            throw new IllegalArgumentException("Search cell range and summ cell range have different length: " + cells.size() + " != " + cellsSum.size());
        }
        for (int i = 0; i < cells.size(); ++i) {
            if (!cells.get(i).isNumeric() || !cellsSum.get(i).isNumeric()) continue;
            if (expr == null) {
                if (!value.equals(cells.get(i).getContent())) continue;
                result = result + cellsSum.get(i).toDouble();
                continue;
            }
            Object eval = SpreadSheetFormula.evaluate(cells.get(i).getContent() + expr, this.getSymbols(), this.getSheet());
            if (!(eval instanceof Boolean) || !((Boolean)eval).booleanValue()) continue;
            result = result + cellsSum.get(i).toDouble();
        }
        return result;
    }

    public Double sumif(String fromCell, String toCell, Object value, String fromSum, String toSum) throws Exception {
        if (value instanceof Double) {
            return this.sumif(fromCell, toCell, (Double)value, fromSum, toSum);
        }
        if (value instanceof String) {
            return this.sumif(fromCell, toCell, (String)value, fromSum, toSum);
        }
        return Double.NaN;
    }
}

