/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.se;

import georegression.fitting.MotionTransformPoint;
import georegression.geometry.GeometryMath_F64;
import georegression.geometry.UtilPoint2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se2_F64;
import java.util.List;
import org.ejml.simple.SimpleMatrix;
import org.ejml.simple.SimpleSVD;

public class MotionSe2PointSVD_F64
implements MotionTransformPoint<Se2_F64, Point2D_F64> {
    Se2_F64 motion = new Se2_F64();
    Point2D_F64 meanFrom = new Point2D_F64();
    Point2D_F64 meanTo = new Point2D_F64();

    @Override
    public Se2_F64 getMotion() {
        return this.motion;
    }

    @Override
    public boolean process(List<Point2D_F64> fromPts, List<Point2D_F64> toPts) {
        if (fromPts.size() != toPts.size()) {
            throw new IllegalArgumentException("There must be a 1 to 1 correspondence between the two sets of points");
        }
        UtilPoint2D_F64.mean(fromPts, this.meanFrom);
        UtilPoint2D_F64.mean(toPts, this.meanTo);
        int N = fromPts.size();
        double s11 = 0.0;
        double s12 = 0.0;
        double s21 = 0.0;
        double s22 = 0.0;
        double m11 = this.meanFrom.x * this.meanTo.x;
        double m12 = this.meanFrom.x * this.meanTo.y;
        double m21 = this.meanFrom.y * this.meanTo.x;
        double m22 = this.meanFrom.y * this.meanTo.y;
        for (int i = 0; i < N; ++i) {
            Point2D_F64 f = fromPts.get(i);
            Point2D_F64 t = toPts.get(i);
            s11 += f.x * t.x;
            s12 += f.x * t.y;
            s21 += f.y * t.x;
            s22 += f.y * t.y;
        }
        s11 = s11 / (double)N - m11;
        s12 = s12 / (double)N - m12;
        s21 = s21 / (double)N - m21;
        s22 = s22 / (double)N - m22;
        SimpleMatrix Sigma = new SimpleMatrix(2, 2, true, new double[]{s11, s12, s21, s22});
        SimpleSVD evd = Sigma.svd(false);
        SimpleMatrix U = evd.getU();
        SimpleMatrix V = evd.getV();
        SimpleMatrix R = (SimpleMatrix)V.mult(U.transpose());
        if (R.determinant() < 0.0) {
            for (int i = 0; i < 2; ++i) {
                V.set(i, 1, -V.get(i, 1));
            }
            R = (SimpleMatrix)V.mult(U.transpose());
            double det = R.determinant();
            if (det < 0.0) {
                System.out.println("Crap");
            }
        }
        double yaw = Math.atan2(R.get(1, 0), R.get(0, 0));
        GeometryMath_F64.rotate(yaw, this.meanFrom, this.meanFrom);
        this.motion.getTranslation().x = this.meanTo.x - this.meanFrom.x;
        this.motion.getTranslation().y = this.meanTo.y - this.meanFrom.y;
        this.motion.setYaw(yaw);
        return true;
    }

    @Override
    public int getMinimumPoints() {
        return 3;
    }
}

