/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.struct.GeoTuple2D_F32;
import georegression.struct.GeoTuple3D_F32;
import org.ejml.alg.dense.mult.VectorVectorMult;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;

public class GeometryMath_F32 {
    public static DenseMatrix64F crossMatrix(float x0, float x1, float x2, DenseMatrix64F ret) {
        if (ret == null) {
            ret = new DenseMatrix64F(3, 3);
        } else {
            ret.zero();
        }
        ret.set(0, 1, (double)(-x2));
        ret.set(0, 2, (double)x1);
        ret.set(1, 0, (double)x2);
        ret.set(1, 2, (double)(-x0));
        ret.set(2, 0, (double)(-x1));
        ret.set(2, 1, (double)x0);
        return ret;
    }

    public static DenseMatrix64F crossMatrix(GeoTuple3D_F32 v, DenseMatrix64F ret) {
        if (ret == null) {
            ret = new DenseMatrix64F(3, 3);
        } else {
            ret.zero();
        }
        float x = v.getX();
        float y = v.getY();
        float z = v.getZ();
        ret.set(0, 1, (double)(-z));
        ret.set(0, 2, (double)y);
        ret.set(1, 0, (double)z);
        ret.set(1, 2, (double)(-x));
        ret.set(2, 0, (double)(-y));
        ret.set(2, 1, (double)x);
        return ret;
    }

    public static void cross(GeoTuple3D_F32 a, GeoTuple3D_F32 b, GeoTuple3D_F32 c) {
        c.x = a.y * b.z - a.z * b.y;
        c.y = a.z * b.x - a.x * b.z;
        c.z = a.x * b.y - a.y * b.x;
    }

    public static void cross(float a_x, float a_y, float a_z, float b_x, float b_y, float b_z, GeoTuple3D_F32 c) {
        c.x = a_y * b_z - a_z * b_y;
        c.y = a_z * b_x - a_x * b_z;
        c.z = a_x * b_y - a_y * b_x;
    }

    public static void cross(GeoTuple2D_F32 a, GeoTuple3D_F32 b, GeoTuple3D_F32 c) {
        c.x = a.y * b.z - b.y;
        c.y = b.x - a.x * b.z;
        c.z = a.x * b.y - a.y * b.x;
    }

    public static void cross(GeoTuple2D_F32 a, GeoTuple2D_F32 b, GeoTuple3D_F32 c) {
        c.x = a.y * 1.0f - b.y;
        c.y = b.x - a.x;
        c.z = a.x * b.y - a.y * b.x;
    }

    public static void add(GeoTuple3D_F32 a, GeoTuple3D_F32 b, GeoTuple3D_F32 c) {
        c.x = a.x + b.x;
        c.y = a.y + b.y;
        c.z = a.z + b.z;
    }

    public static void add(float a0, GeoTuple3D_F32 pt0, float a1, GeoTuple3D_F32 pt1, GeoTuple3D_F32 pt2) {
        pt2.x = a0 * pt0.x + a1 * pt1.x;
        pt2.y = a0 * pt0.y + a1 * pt1.y;
        pt2.z = a0 * pt0.z + a1 * pt1.z;
    }

    public static <T extends GeoTuple3D_F32> T addMult(T p0, DenseMatrix64F M, T p1, T ret) {
        ret = GeometryMath_F32.mult(M, p1, ret);
        ret.x += p0.x;
        ret.y += p0.y;
        ret.z += p0.z;
        return ret;
    }

    public static void sub(GeoTuple3D_F32 a, GeoTuple3D_F32 b, GeoTuple3D_F32 c) {
        c.x = a.x - b.x;
        c.y = a.y - b.y;
        c.z = a.z - b.z;
    }

    public static void rotate(float theta, GeoTuple2D_F32 pt, GeoTuple2D_F32 solution) {
        float c = (float)Math.cos(theta);
        float s = (float)Math.sin(theta);
        float x = pt.x;
        float y = pt.y;
        solution.x = c * x - s * y;
        solution.y = s * x + c * y;
    }

    public static void rotate(float c, float s, GeoTuple2D_F32 pt, GeoTuple2D_F32 solution) {
        float x = pt.x;
        float y = pt.y;
        solution.x = c * x - s * y;
        solution.y = s * x + c * y;
    }

    public static <T extends GeoTuple3D_F32> T mult(DenseMatrix64F M, T pt, T result) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Input matrix must be 3 by 3, not " + M.numRows + " " + M.numCols);
        }
        if (result == null) {
            result = (GeoTuple3D_F32)pt.createNewInstance();
        }
        float x = pt.x;
        float y = pt.y;
        float z = pt.z;
        result.x = (float)(M.unsafe_get(0, 0) * (double)x + M.unsafe_get(0, 1) * (double)y + M.unsafe_get(0, 2) * (double)z);
        result.y = (float)(M.unsafe_get(1, 0) * (double)x + M.unsafe_get(1, 1) * (double)y + M.unsafe_get(1, 2) * (double)z);
        result.z = (float)(M.unsafe_get(2, 0) * (double)x + M.unsafe_get(2, 1) * (double)y + M.unsafe_get(2, 2) * (double)z);
        return result;
    }

    public static <T extends GeoTuple2D_F32> T mult(DenseMatrix64F M, GeoTuple3D_F32 pt, T mod) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Input matrix must be 3 by 3, not " + M.numRows + " " + M.numCols);
        }
        float x = pt.x;
        float y = pt.y;
        float z = pt.z;
        mod.x = (float)(M.unsafe_get(0, 0) * (double)x + M.unsafe_get(0, 1) * (double)y + M.unsafe_get(0, 2) * (double)z);
        mod.y = (float)(M.unsafe_get(1, 0) * (double)x + M.unsafe_get(1, 1) * (double)y + M.unsafe_get(1, 2) * (double)z);
        z = (float)(M.unsafe_get(2, 0) * (double)x + M.unsafe_get(2, 1) * (double)y + M.unsafe_get(2, 2) * (double)z);
        mod.x /= z;
        mod.y /= z;
        return mod;
    }

    public static void mult(DenseMatrix64F M, GeoTuple2D_F32 pt, GeoTuple3D_F32 mod) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Input matrix must be 3 by 3, not " + M.numRows + " " + M.numCols);
        }
        float x = pt.x;
        float y = pt.y;
        mod.x = (float)(M.unsafe_get(0, 0) * (double)x + M.unsafe_get(0, 1) * (double)y + M.unsafe_get(0, 2));
        mod.y = (float)(M.unsafe_get(1, 0) * (double)x + M.unsafe_get(1, 1) * (double)y + M.unsafe_get(1, 2));
        mod.z = (float)(M.unsafe_get(2, 0) * (double)x + M.unsafe_get(2, 1) * (double)y + M.unsafe_get(2, 2));
    }

    public static <T extends GeoTuple2D_F32> T mult(DenseMatrix64F M, T pt, T mod) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Input matrix must be 3 by 3, not " + M.numRows + " " + M.numCols);
        }
        if (mod == null) {
            throw new IllegalArgumentException("Must provide an instance in mod");
        }
        float x = pt.x;
        float y = pt.y;
        float modz = (float)(M.unsafe_get(2, 0) * (double)x + M.unsafe_get(2, 1) * (double)y + M.unsafe_get(2, 2));
        mod.x = (float)((M.unsafe_get(0, 0) * (double)x + M.unsafe_get(0, 1) * (double)y + M.unsafe_get(0, 2)) / (double)modz);
        mod.y = (float)((M.unsafe_get(1, 0) * (double)x + M.unsafe_get(1, 1) * (double)y + M.unsafe_get(1, 2)) / (double)modz);
        return mod;
    }

    public static DenseMatrix64F multCrossA(GeoTuple2D_F32 A, DenseMatrix64F M, DenseMatrix64F result) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Input matrix must be 3 by 3, not " + M.numRows + " " + M.numCols);
        }
        if (result == null) {
            result = new DenseMatrix64F(3, 3);
        }
        double x = A.x;
        double y = A.y;
        double a11 = M.data[0];
        double a12 = M.data[1];
        double a13 = M.data[2];
        double a21 = M.data[3];
        double a22 = M.data[4];
        double a23 = M.data[5];
        double a31 = M.data[6];
        double a32 = M.data[7];
        double a33 = M.data[8];
        result.data[0] = -a21 + a31 * y;
        result.data[1] = -a22 + a32 * y;
        result.data[2] = -a23 + a33 * y;
        result.data[3] = a11 - a31 * x;
        result.data[4] = a12 - a32 * x;
        result.data[5] = a13 - a33 * x;
        result.data[6] = -a11 * y + a21 * x;
        result.data[7] = -a12 * y + a22 * x;
        result.data[8] = -a13 * y + a23 * x;
        return result;
    }

    public static DenseMatrix64F multCrossA(GeoTuple3D_F32 A, DenseMatrix64F M, DenseMatrix64F result) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Input matrix must be 3 by 3, not " + M.numRows + " " + M.numCols);
        }
        if (result == null) {
            result = new DenseMatrix64F(3, 3);
        }
        double x = A.x;
        double y = A.y;
        double z = A.z;
        double a11 = M.data[0];
        double a12 = M.data[1];
        double a13 = M.data[2];
        double a21 = M.data[3];
        double a22 = M.data[4];
        double a23 = M.data[5];
        double a31 = M.data[6];
        double a32 = M.data[7];
        double a33 = M.data[8];
        result.data[0] = -a21 * z + a31 * y;
        result.data[1] = -a22 * z + a32 * y;
        result.data[2] = -a23 * z + a33 * y;
        result.data[3] = a11 * z - a31 * x;
        result.data[4] = a12 * z - a32 * x;
        result.data[5] = a13 * z - a33 * x;
        result.data[6] = -a11 * y + a21 * x;
        result.data[7] = -a12 * y + a22 * x;
        result.data[8] = -a13 * y + a23 * x;
        return result;
    }

    public static <T extends GeoTuple3D_F32> T multTran(DenseMatrix64F M, T pt, T mod) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Rotation matrices are 3 by 3.");
        }
        if (mod == null) {
            mod = (GeoTuple3D_F32)pt.createNewInstance();
        }
        float x = pt.x;
        float y = pt.y;
        float z = pt.z;
        mod.x = (float)(M.unsafe_get(0, 0) * (double)x + M.unsafe_get(1, 0) * (double)y + M.unsafe_get(2, 0) * (double)z);
        mod.y = (float)(M.unsafe_get(0, 1) * (double)x + M.unsafe_get(1, 1) * (double)y + M.unsafe_get(2, 1) * (double)z);
        mod.z = (float)(M.unsafe_get(0, 2) * (double)x + M.unsafe_get(1, 2) * (double)y + M.unsafe_get(2, 2) * (double)z);
        return mod;
    }

    public static <T extends GeoTuple3D_F32> T multTran(DenseMatrix64F M, GeoTuple2D_F32 pt, T mod) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Rotation matrices are 3 by 3.");
        }
        if (mod == null) {
            throw new IllegalArgumentException("Must provide an instance in mod");
        }
        float x = pt.x;
        float y = pt.y;
        mod.x = (float)(M.unsafe_get(0, 0) * (double)x + M.unsafe_get(1, 0) * (double)y + M.unsafe_get(2, 0));
        mod.y = (float)(M.unsafe_get(0, 1) * (double)x + M.unsafe_get(1, 1) * (double)y + M.unsafe_get(2, 1));
        mod.z = (float)(M.unsafe_get(0, 2) * (double)x + M.unsafe_get(1, 2) * (double)y + M.unsafe_get(2, 2));
        return mod;
    }

    public static <T extends GeoTuple2D_F32> T multTran(DenseMatrix64F M, GeoTuple2D_F32 pt, T mod) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("Rotation matrices are 3 by 3.");
        }
        if (mod == null) {
            throw new IllegalArgumentException("Must provide an instance in mod");
        }
        float x = pt.x;
        float y = pt.y;
        float modZ = (float)(M.unsafe_get(0, 2) * (double)x + M.unsafe_get(1, 2) * (double)y + M.unsafe_get(2, 2));
        mod.x = (float)(M.unsafe_get(0, 0) * (double)x + M.unsafe_get(1, 0) * (double)y + M.unsafe_get(2, 0)) / modZ;
        mod.y = (float)(M.unsafe_get(0, 1) * (double)x + M.unsafe_get(1, 1) * (double)y + M.unsafe_get(2, 1)) / modZ;
        return mod;
    }

    public static float innerProd(GeoTuple3D_F32 a, DenseMatrix64F M, GeoTuple3D_F32 b) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("M must be 3 by 3.");
        }
        DenseMatrix64F m1 = new DenseMatrix64F(3, 1, true, new double[]{a.x, a.y, a.z});
        DenseMatrix64F m2 = new DenseMatrix64F(3, 1, true, new double[]{b.x, b.y, b.z});
        return (float)VectorVectorMult.innerProdA((D1Matrix64F)m1, (D1Matrix64F)M, (D1Matrix64F)m2);
    }

    public static float innerProdTranM(GeoTuple3D_F32 a, DenseMatrix64F M, GeoTuple3D_F32 b) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("M must be 3 by 3.");
        }
        DenseMatrix64F m1 = new DenseMatrix64F(3, 1, true, new double[]{a.x, a.y, a.z});
        DenseMatrix64F m2 = new DenseMatrix64F(3, 1, true, new double[]{b.x, b.y, b.z});
        return (float)VectorVectorMult.innerProdTranA((D1Matrix64F)m1, (D1Matrix64F)M, (D1Matrix64F)m2);
    }

    public static DenseMatrix64F outerProd(GeoTuple3D_F32 a, GeoTuple3D_F32 b, DenseMatrix64F ret) {
        if (ret == null) {
            ret = new DenseMatrix64F(3, 3);
        }
        ret.data[0] = a.x * b.x;
        ret.data[1] = a.x * b.y;
        ret.data[2] = a.x * b.z;
        ret.data[3] = a.y * b.x;
        ret.data[4] = a.y * b.y;
        ret.data[5] = a.y * b.z;
        ret.data[6] = a.z * b.x;
        ret.data[7] = a.z * b.y;
        ret.data[8] = a.z * b.z;
        return ret;
    }

    public static DenseMatrix64F addOuterProd(DenseMatrix64F A, float scalar, GeoTuple3D_F32 b, GeoTuple3D_F32 c, DenseMatrix64F ret) {
        if (ret == null) {
            ret = new DenseMatrix64F(3, 3);
        }
        ret.data[0] = A.data[0] + (double)(scalar * b.x * c.x);
        ret.data[1] = A.data[1] + (double)(scalar * b.x * c.y);
        ret.data[2] = A.data[2] + (double)(scalar * b.x * c.z);
        ret.data[3] = A.data[3] + (double)(scalar * b.y * c.x);
        ret.data[4] = A.data[4] + (double)(scalar * b.y * c.y);
        ret.data[5] = A.data[5] + (double)(scalar * b.y * c.z);
        ret.data[6] = A.data[6] + (double)(scalar * b.z * c.x);
        ret.data[7] = A.data[7] + (double)(scalar * b.z * c.y);
        ret.data[8] = A.data[8] + (double)(scalar * b.z * c.z);
        return ret;
    }

    public static float innerProd(GeoTuple2D_F32 a, DenseMatrix64F M, GeoTuple2D_F32 b) {
        if (M.numRows != 3 || M.numCols != 3) {
            throw new IllegalArgumentException("M must be 3 by 3.");
        }
        DenseMatrix64F m1 = new DenseMatrix64F(3, 1, true, new double[]{a.x, a.y, 1.0});
        DenseMatrix64F m2 = new DenseMatrix64F(3, 1, true, new double[]{b.x, b.y, 1.0});
        return (float)VectorVectorMult.innerProdA((D1Matrix64F)m1, (D1Matrix64F)M, (D1Matrix64F)m2);
    }

    public static float dot(GeoTuple3D_F32 a, GeoTuple3D_F32 b) {
        return a.x * b.x + a.y * b.y + a.z * b.z;
    }

    public static void scale(GeoTuple3D_F32 p, float v) {
        p.x *= v;
        p.y *= v;
        p.z *= v;
    }

    public static void changeSign(GeoTuple3D_F32 t) {
        t.x = -t.x;
        t.y = -t.y;
        t.z = -t.z;
    }

    public static DenseMatrix64F toMatrix(GeoTuple3D_F32 in, DenseMatrix64F out) {
        if (out == null) {
            out = new DenseMatrix64F(3, 1);
        } else if (out.getNumElements() != 3) {
            throw new IllegalArgumentException("Vector with 3 elements expected");
        }
        out.data[0] = in.x;
        out.data[1] = in.y;
        out.data[2] = in.z;
        return out;
    }

    public static void toTuple3D(DenseMatrix64F in, GeoTuple3D_F32 out) {
        out.x = (float)in.get(0);
        out.y = (float)in.get(1);
        out.z = (float)in.get(2);
    }
}

