/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.struct.plane.PlaneGeneral3D_F32;
import georegression.struct.plane.PlaneNormal3D_F32;
import georegression.struct.plane.PlaneTangent3D_F32;
import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Vector3D_F32;

public class UtilPlane3D_F32 {
    public static PlaneGeneral3D_F32 convert(PlaneNormal3D_F32 input, PlaneGeneral3D_F32 output) {
        if (output == null) {
            output = new PlaneGeneral3D_F32();
        }
        Vector3D_F32 n = input.n;
        Point3D_F32 p = input.p;
        output.A = n.x;
        output.B = n.y;
        output.C = n.z;
        output.D = n.x * p.x + n.y * p.y + n.z * p.z;
        return output;
    }

    public static PlaneNormal3D_F32 convert(PlaneTangent3D_F32 input, PlaneNormal3D_F32 output) {
        if (output == null) {
            output = new PlaneNormal3D_F32();
        }
        output.n.x = input.x;
        output.n.y = input.y;
        output.n.z = input.z;
        output.p.set(input);
        return output;
    }

    public static void hessianNormalForm(PlaneGeneral3D_F32 plane) {
        float n = (float)Math.sqrt(plane.A * plane.A + plane.B * plane.B + plane.C * plane.C);
        plane.A /= n;
        plane.B /= n;
        plane.C /= n;
        plane.D /= n;
    }

    public static float evaluate(PlaneGeneral3D_F32 plane, Point3D_F32 point) {
        return plane.A * point.x + plane.B * point.y + plane.C * point.z - plane.D;
    }

    public static float evaluate(PlaneNormal3D_F32 plane, Point3D_F32 point) {
        float dx = point.x - plane.p.x;
        float dy = point.y - plane.p.y;
        float dz = point.z - plane.p.z;
        return plane.n.x * dx + plane.n.y * dy + plane.n.z * dz;
    }
}

