/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct;

import georegression.struct.GeoTuple_F32;

public abstract class GeoTuple2D_F32<T extends GeoTuple2D_F32>
extends GeoTuple_F32<T> {
    public float x;
    public float y;

    public GeoTuple2D_F32(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public GeoTuple2D_F32() {
    }

    protected void _set(GeoTuple2D_F32 a) {
        this.x = a.x;
        this.y = a.y;
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public boolean isIdentical(float x, float y) {
        return this.x == x && this.y == y;
    }

    public boolean isIdentical(float x, float y, float tol) {
        return Math.abs(this.x - x) < tol && Math.abs(this.y - y) < tol;
    }

    @Override
    public boolean isIdentical(T t, float tol) {
        return Math.abs(this.x - ((GeoTuple2D_F32)t).x) < tol && Math.abs(this.y - ((GeoTuple2D_F32)t).y) < tol;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    @Override
    public float distance(T t) {
        float dx = ((GeoTuple2D_F32)t).x - this.x;
        float dy = ((GeoTuple2D_F32)t).y - this.y;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    @Override
    public float distance2(T t) {
        float dx = ((GeoTuple2D_F32)t).x - this.x;
        float dy = ((GeoTuple2D_F32)t).y - this.y;
        return dx * dx + dy * dy;
    }

    @Override
    public float getIndex(int index) {
        switch (index) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IllegalArgumentException("Invalid index");
    }

    @Override
    public void setIndex(int index, float value) {
        switch (index) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid index");
            }
        }
    }

    @Override
    public float norm() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    @Override
    public float normSq() {
        return this.x * this.x + this.y * this.y;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    public void print() {
        System.out.println(this);
    }
}

