/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.point;

import georegression.geometry.GeometryMath_F32;
import georegression.struct.GeoTuple3D_F32;
import georegression.struct.point.Point3D_F32;

public class Vector3D_F32
extends GeoTuple3D_F32 {
    public Vector3D_F32(float x, float y, float z) {
        super(x, y, z);
    }

    public Vector3D_F32() {
    }

    public Vector3D_F32(Point3D_F32 a, Point3D_F32 b) {
        this.x = b.getX() - a.getX();
        this.y = b.getY() - a.getY();
        this.z = b.getZ() - a.getZ();
    }

    public void set(Vector3D_F32 v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public void ip_times(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
    }

    public Vector3D_F32 times(float scalar) {
        return new Vector3D_F32(this.x * scalar, this.y * scalar, this.z * scalar);
    }

    @Override
    public Vector3D_F32 copy() {
        return new Vector3D_F32(this.x, this.y, this.z);
    }

    public Vector3D_F32 cross(Vector3D_F32 b) {
        Vector3D_F32 c = new Vector3D_F32();
        GeometryMath_F32.cross(this, (GeoTuple3D_F32)b, (GeoTuple3D_F32)c);
        return c;
    }

    @Override
    public Vector3D_F32 createNewInstance() {
        return new Vector3D_F32();
    }

    public String toString() {
        return "V( " + this.x + " " + this.y + " " + this.z + " )";
    }

    public void normalize() {
        float r = this.norm();
        this.x /= r;
        this.y /= r;
        this.z /= r;
    }

    public float dot(Vector3D_F32 a) {
        return this.x * a.x + this.y * a.y + this.z * a.z;
    }
}

