/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.convolve;

import boofcv.abst.filter.convolve.ConvolveInterface;
import boofcv.core.image.border.BorderType;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.core.image.border.ImageBorder;
import boofcv.struct.convolve.KernelBase;
import boofcv.struct.image.ImageSingleBand;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class GenericConvolve<Input extends ImageSingleBand, Output extends ImageSingleBand>
implements ConvolveInterface<Input, Output> {
    Method m;
    KernelBase kernel;
    BorderType type;
    ImageBorder borderRule;
    Class<Input> imageType;

    public GenericConvolve(Method m, KernelBase kernel, BorderType type, Class<Input> imageType) {
        this.m = m;
        this.kernel = kernel;
        this.type = type;
        this.imageType = imageType;
        Class<?>[] params = m.getParameterTypes();
        this.borderRule = type == BorderType.SKIP || type == BorderType.NORMALIZED ? null : FactoryImageBorder.general(params[1], type);
    }

    @Override
    public void process(Input input, Output output) {
        try {
            if (this.kernel.getDimension() == 1) {
                switch (this.type) {
                    case SKIP: {
                        this.m.invoke(null, this.kernel, input, output, false);
                        break;
                    }
                    case NORMALIZED: {
                        this.m.invoke(null, this.kernel, input, output);
                        break;
                    }
                    default: {
                        this.m.invoke(null, this.kernel, input, output, this.borderRule);
                        break;
                    }
                }
            } else {
                switch (this.type) {
                    case SKIP: 
                    case NORMALIZED: {
                        this.m.invoke(null, this.kernel, input, output);
                        break;
                    }
                    default: {
                        this.m.invoke(null, this.kernel, input, output, this.borderRule);
                    }
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getHorizontalBorder() {
        if (this.type == BorderType.SKIP) {
            return this.kernel.getRadius();
        }
        return 0;
    }

    @Override
    public BorderType getBorderType() {
        return this.type;
    }

    @Override
    public int getVerticalBorder() {
        return this.getHorizontalBorder();
    }

    @Override
    public Class<Input> getInputType() {
        return this.imageType;
    }
}

