/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.alg.distort.ImageDistort;
import boofcv.alg.interpolate.InterpolatePixel;
import boofcv.core.image.border.ImageBorder;
import boofcv.struct.distort.PixelTransform_F32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageSingleBand;

public abstract class ImageDistortBasic<T extends ImageSingleBand>
implements ImageDistort<T> {
    private PixelTransform_F32 dstToSrc;
    private InterpolatePixel<T> interp;
    private ImageBorder<T> border;
    private int x0;
    private int y0;
    private int x1;
    private int y1;
    protected T srcImg;
    protected T dstImg;

    public ImageDistortBasic(InterpolatePixel<T> interp, ImageBorder<T> border) {
        this.interp = interp;
        this.border = border;
    }

    @Override
    public void setModel(PixelTransform_F32 dstToSrc) {
        this.dstToSrc = dstToSrc;
    }

    @Override
    public void apply(T srcImg, T dstImg) {
        this.init(srcImg, dstImg);
        this.x0 = 0;
        this.y0 = 0;
        this.x1 = ((ImageSingleBand)dstImg).width;
        this.y1 = ((ImageSingleBand)dstImg).height;
        if (this.border != null) {
            this.applyBorder();
        } else {
            this.applyNoBorder();
        }
    }

    @Override
    public void apply(T srcImg, T dstImg, int dstX0, int dstY0, int dstX1, int dstY1) {
        this.init(srcImg, dstImg);
        this.x0 = dstX0;
        this.y0 = dstY0;
        this.x1 = dstX1;
        this.y1 = dstY1;
        if (this.border != null) {
            this.applyBorder();
        } else {
            this.applyNoBorder();
        }
    }

    private void init(T srcImg, T dstImg) {
        this.srcImg = srcImg;
        this.dstImg = dstImg;
        this.interp.setImage(srcImg);
    }

    public void applyBorder() {
        this.border.setImage(this.srcImg);
        float minInterpX = this.interp.getUnsafeBorderX();
        float minInterpY = this.interp.getUnsafeBorderY();
        float maxInterpX = ((ImageBase)this.srcImg).getWidth() - this.interp.getUnsafeBorderX();
        float maxInterpY = ((ImageBase)this.srcImg).getHeight() - this.interp.getUnsafeBorderY();
        float widthF = ((ImageBase)this.srcImg).getWidth();
        float heightF = ((ImageBase)this.srcImg).getHeight();
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageSingleBand)this.dstImg).startIndex + ((ImageSingleBand)this.dstImg).stride * y + this.x0;
            int x = this.x0;
            while (x < this.x1) {
                this.dstToSrc.compute(x, y);
                if (this.dstToSrc.distX < minInterpX || this.dstToSrc.distX >= maxInterpX || this.dstToSrc.distY < minInterpY || this.dstToSrc.distY >= maxInterpY) {
                    if (this.dstToSrc.distX < 0.0f || this.dstToSrc.distX >= widthF || this.dstToSrc.distY < 0.0f || this.dstToSrc.distY >= heightF) {
                        this.assign(indexDst, (float)this.border.getGeneral((int)this.dstToSrc.distX, (int)this.dstToSrc.distY));
                    } else {
                        this.assign(indexDst, this.interp.get(this.dstToSrc.distX, this.dstToSrc.distY));
                    }
                } else {
                    this.assign(indexDst, this.interp.get_unsafe(this.dstToSrc.distX, this.dstToSrc.distY));
                }
                ++x;
                ++indexDst;
            }
        }
    }

    public void applyNoBorder() {
        float minInterpX = this.interp.getUnsafeBorderX();
        float minInterpY = this.interp.getUnsafeBorderY();
        float maxInterpX = ((ImageBase)this.srcImg).getWidth() - this.interp.getUnsafeBorderX();
        float maxInterpY = ((ImageBase)this.srcImg).getHeight() - this.interp.getUnsafeBorderY();
        float widthF = ((ImageBase)this.srcImg).getWidth();
        float heightF = ((ImageBase)this.srcImg).getHeight();
        for (int y = this.y0; y < this.y1; ++y) {
            int indexDst = ((ImageSingleBand)this.dstImg).startIndex + ((ImageSingleBand)this.dstImg).stride * y + this.x0;
            int x = this.x0;
            while (x < this.x1) {
                this.dstToSrc.compute(x, y);
                if (this.dstToSrc.distX < minInterpX || this.dstToSrc.distX >= maxInterpX || this.dstToSrc.distY < minInterpY || this.dstToSrc.distY >= maxInterpY) {
                    if (this.dstToSrc.distX >= 0.0f && this.dstToSrc.distX < widthF && this.dstToSrc.distY >= 0.0f && this.dstToSrc.distY < heightF) {
                        this.assign(indexDst, this.interp.get(this.dstToSrc.distX, this.dstToSrc.distY));
                    }
                } else {
                    this.assign(indexDst, this.interp.get_unsafe(this.dstToSrc.distX, this.dstToSrc.distY));
                }
                ++x;
                ++indexDst;
            }
        }
    }

    protected abstract void assign(int var1, float var2);
}

