/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.alg.distort.AddRadialNtoN_F64;
import boofcv.alg.distort.AddRadialPtoP_F32;
import boofcv.alg.distort.DistortImageOps;
import boofcv.alg.distort.FlipVerticalNorm_F64;
import boofcv.alg.distort.FlipVertical_F32;
import boofcv.alg.distort.FlipVertical_F64;
import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.NormalizedToPixel_F64;
import boofcv.alg.distort.PointToPixelTransform_F32;
import boofcv.alg.distort.RemoveRadialPtoN_F64;
import boofcv.alg.distort.RemoveRadialPtoP_F32;
import boofcv.alg.distort.RemoveRadialPtoP_F64;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.interpolate.InterpolatePixel;
import boofcv.core.image.border.BorderType;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.core.image.border.ImageBorder;
import boofcv.factory.distort.FactoryDistort;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.distort.PixelTransform_F32;
import boofcv.struct.distort.PointTransform_F32;
import boofcv.struct.distort.PointTransform_F64;
import boofcv.struct.distort.SequencePointTransform_F32;
import boofcv.struct.distort.SequencePointTransform_F64;
import boofcv.struct.image.ImageSingleBand;
import georegression.struct.shapes.Rectangle2D_F32;
import org.ejml.data.DenseMatrix64F;

public class LensDistortionOps {
    public static PointTransform_F32 fullView(IntrinsicParameters param, IntrinsicParameters paramAdj) {
        RemoveRadialPtoP_F32 removeDistort = new RemoveRadialPtoP_F32();
        AddRadialPtoP_F32 addDistort = new AddRadialPtoP_F32();
        removeDistort.set(param.fx, param.fy, param.skew, param.cx, param.cy, param.radial);
        addDistort.set(param.fx, param.fy, param.skew, param.cx, param.cy, param.radial);
        Rectangle2D_F32 bound = DistortImageOps.boundBox_F32(param.width, param.height, new PointToPixelTransform_F32(removeDistort));
        double scaleX = bound.width / (float)param.width;
        double scaleY = bound.height / (float)param.height;
        double scale = Math.max(scaleX, scaleY);
        double deltaX = bound.tl_x;
        double deltaY = bound.tl_y;
        DenseMatrix64F A = new DenseMatrix64F(3, 3, true, new double[]{scale, 0.0, deltaX, 0.0, scale, deltaY, 0.0, 0.0, 1.0});
        PointTransform_F32 tranAdj = PerspectiveOps.adjustIntrinsic_F32(addDistort, false, param, A, paramAdj);
        if (param.flipY) {
            FlipVertical_F32 flip = new FlipVertical_F32(param.height);
            return new SequencePointTransform_F32(flip, tranAdj, flip);
        }
        return tranAdj;
    }

    public static PointTransform_F32 allInside(IntrinsicParameters param, IntrinsicParameters paramAdj) {
        RemoveRadialPtoP_F32 removeDistort = new RemoveRadialPtoP_F32();
        AddRadialPtoP_F32 addDistort = new AddRadialPtoP_F32();
        removeDistort.set(param.fx, param.fy, param.skew, param.cx, param.cy, param.radial);
        addDistort.set(param.fx, param.fy, param.skew, param.cx, param.cy, param.radial);
        Rectangle2D_F32 bound = LensDistortionOps.boundBoxInside(param.width, param.height, new PointToPixelTransform_F32(removeDistort));
        LensDistortionOps.roundInside(bound);
        double scaleX = bound.width / (float)param.width;
        double scaleY = bound.height / (float)param.height;
        double scale = Math.min(scaleX, scaleY);
        double deltaX = (double)bound.tl_x + (scaleX - scale) * (double)param.width / 2.0;
        double deltaY = (double)bound.tl_y + (scaleY - scale) * (double)param.height / 2.0;
        DenseMatrix64F A = new DenseMatrix64F(3, 3, true, new double[]{scale, 0.0, deltaX, 0.0, scale, deltaY, 0.0, 0.0, 1.0});
        PointTransform_F32 tranAdj = PerspectiveOps.adjustIntrinsic_F32(addDistort, false, param, A, paramAdj);
        if (param.flipY) {
            FlipVertical_F32 flip = new FlipVertical_F32(param.height);
            return new SequencePointTransform_F32(flip, tranAdj, flip);
        }
        return tranAdj;
    }

    public static PointTransform_F64 transformRadialToNorm_F64(IntrinsicParameters param) {
        RemoveRadialPtoN_F64 radialDistort = new RemoveRadialPtoN_F64();
        radialDistort.set(param.fx, param.fy, param.skew, param.cx, param.cy, param.radial);
        if (param.flipY) {
            return new FlipVerticalNorm_F64(radialDistort, param.height);
        }
        return radialDistort;
    }

    public static PointTransform_F64 transformRadialToPixel_F64(IntrinsicParameters param) {
        RemoveRadialPtoP_F64 removeRadial = new RemoveRadialPtoP_F64();
        removeRadial.set(param.fx, param.fy, param.skew, param.cx, param.cy, param.radial);
        if (param.flipY) {
            FlipVertical_F64 flip = new FlipVertical_F64(param.height);
            return new SequencePointTransform_F64(flip, removeRadial, flip);
        }
        return removeRadial;
    }

    public static PointTransform_F64 transformNormToRadial_F64(IntrinsicParameters param) {
        AddRadialNtoN_F64 addRadial = new AddRadialNtoN_F64();
        addRadial.set(param.radial);
        NormalizedToPixel_F64 toPixel = new NormalizedToPixel_F64();
        toPixel.set(param.fx, param.fy, param.skew, param.cx, param.cy);
        if (param.flipY) {
            return new SequencePointTransform_F64(addRadial, toPixel, new FlipVertical_F64(param.height));
        }
        return new SequencePointTransform_F64(addRadial, toPixel);
    }

    public static PointTransform_F32 transformPixelToRadial_F32(IntrinsicParameters param) {
        AddRadialPtoP_F32 radialDistort = new AddRadialPtoP_F32();
        radialDistort.set(param.fx, param.fy, param.skew, param.cx, param.cy, param.radial);
        if (param.flipY) {
            FlipVertical_F32 flip = new FlipVertical_F32(param.height);
            return new SequencePointTransform_F32(flip, radialDistort, flip);
        }
        return radialDistort;
    }

    public static <T extends ImageSingleBand> ImageDistort<T> removeRadialImage(IntrinsicParameters param, BorderType borderType, Class<T> imageType) {
        InterpolatePixel<T> interp = FactoryInterpolation.bilinearPixel(imageType);
        ImageBorder<T> border = borderType == BorderType.VALUE ? FactoryImageBorder.value(imageType, 0.0) : FactoryImageBorder.general(imageType, borderType);
        ImageDistort<T> ret = FactoryDistort.distortCached(interp, border, imageType);
        PointTransform_F32 transform = LensDistortionOps.transformPixelToRadial_F32(param);
        ret.setModel(new PointToPixelTransform_F32(transform));
        return ret;
    }

    public static Rectangle2D_F32 boundBoxInside(int srcWidth, int srcHeight, PixelTransform_F32 transform) {
        transform.compute(0, 0);
        float x0 = transform.distX;
        float y0 = transform.distY;
        transform.compute(srcWidth, 0);
        float x1 = transform.distX;
        transform.compute(0, srcHeight);
        float y1 = transform.distY;
        for (int x = 0; x < srcWidth; ++x) {
            transform.compute(x, 0);
            if (transform.distY > y0) {
                y0 = transform.distY;
            }
            transform.compute(x, srcHeight);
            if (!(transform.distY < y1)) continue;
            y1 = transform.distY;
        }
        for (int y = 0; y < srcHeight; ++y) {
            transform.compute(0, y);
            if (transform.distX > x0) {
                x0 = transform.distX;
            }
            transform.compute(srcWidth, y);
            if (!(transform.distX < x1)) continue;
            x1 = transform.distX;
        }
        return new Rectangle2D_F32(x0, y0, x1 - x0, y1 - y0);
    }

    public static void roundInside(Rectangle2D_F32 bound) {
        float x0 = (float)Math.ceil(bound.tl_x);
        float y0 = (float)Math.ceil(bound.tl_y);
        float x1 = (float)Math.floor(bound.tl_x + bound.width);
        float y1 = (float)Math.floor(bound.tl_y + bound.height);
        bound.tl_x = x0;
        bound.tl_y = y0;
        bound.width = x1 - x0;
        bound.height = y1 - y0;
    }
}

