/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.struct.distort.PointTransform_F64;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class RemoveRadialPtoN_F64
implements PointTransform_F64 {
    protected double x_c;
    protected double y_c;
    protected double[] radial;
    protected double sum;
    protected DenseMatrix64F K_inv = new DenseMatrix64F(3, 3);
    private double tol = 1.0E-10;

    public RemoveRadialPtoN_F64() {
    }

    public RemoveRadialPtoN_F64(double tol) {
        this.tol = tol;
    }

    public void setTolerance(double tol) {
        this.tol = tol;
    }

    public void set(double fx, double fy, double skew, double x_c, double y_c, double ... radial) {
        this.K_inv.set(0, 0, fx);
        this.K_inv.set(1, 1, fy);
        this.K_inv.set(0, 1, skew);
        this.K_inv.set(0, 2, x_c);
        this.K_inv.set(1, 2, y_c);
        this.K_inv.set(2, 2, 1.0);
        CommonOps.invert((DenseMatrix64F)this.K_inv);
        this.x_c = x_c;
        this.y_c = y_c;
        this.radial = new double[radial.length];
        System.arraycopy(radial, 0, this.radial, 0, radial.length);
    }

    @Override
    public void compute(double x, double y, Point2D_F64 out) {
        out.x = x;
        out.y = y;
        GeometryMath_F64.mult((DenseMatrix64F)this.K_inv, (GeoTuple2D_F64)out, (GeoTuple2D_F64)out);
        double origX = out.x;
        double origY = out.y;
        double prevSum = 0.0;
        for (int iter = 0; iter < 20; ++iter) {
            double r2;
            double r = r2 = out.x * out.x + out.y * out.y;
            this.sum = 0.0;
            for (int i = 0; i < this.radial.length; ++i) {
                this.sum += this.radial[i] * r;
                r *= r2;
            }
            out.x = origX / (1.0 + this.sum);
            out.y = origY / (1.0 + this.sum);
            if (Math.abs(prevSum - this.sum) <= this.tol) break;
            prevSum = this.sum;
        }
    }
}

