/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.associate;

import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.RectifyImageOps;
import boofcv.alg.geo.rectify.RectifyCalibrated;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.distort.PointTransform_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se3_F64;
import org.ejml.data.DenseMatrix64F;

public class StereoConsistencyCheck {
    protected PointTransform_F64 leftImageToRect;
    protected PointTransform_F64 rightImageToRect;
    Point2D_F64 rectLeft = new Point2D_F64();
    Point2D_F64 rectRight = new Point2D_F64();
    double toleranceY;
    double toleranceX;

    public StereoConsistencyCheck(double toleranceX, double toleranceY) {
        this.toleranceX = toleranceX;
        this.toleranceY = toleranceY;
    }

    public void setCalibration(StereoParameters param) {
        IntrinsicParameters left = param.getLeft();
        IntrinsicParameters right = param.getRight();
        RectifyCalibrated rectifyAlg = RectifyImageOps.createCalibrated();
        Se3_F64 leftToRight = param.getRightToLeft().invert(null);
        DenseMatrix64F K1 = PerspectiveOps.calibrationMatrix(left, null);
        DenseMatrix64F K2 = PerspectiveOps.calibrationMatrix(right, null);
        rectifyAlg.process(K1, new Se3_F64(), K2, leftToRight);
        DenseMatrix64F rect1 = rectifyAlg.getRect1();
        DenseMatrix64F rect2 = rectifyAlg.getRect2();
        this.leftImageToRect = RectifyImageOps.transformPixelToRect_F64(param.left, rect1);
        this.rightImageToRect = RectifyImageOps.transformPixelToRect_F64(param.right, rect2);
    }

    public boolean checkPixel(Point2D_F64 left, Point2D_F64 right) {
        this.leftImageToRect.compute(left.x, left.y, this.rectLeft);
        this.rightImageToRect.compute(right.x, right.y, this.rectRight);
        return this.checkRectified(this.rectLeft, this.rectRight);
    }

    public boolean checkRectified(Point2D_F64 left, Point2D_F64 right) {
        if (Math.abs(left.y - right.y) > this.toleranceY) {
            return false;
        }
        return right.x <= left.x + this.toleranceX;
    }
}

