/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.describe;

import boofcv.abst.filter.blur.BlurFilter;
import boofcv.alg.feature.describe.DescribePointBinaryCompare;
import boofcv.alg.feature.describe.brief.BinaryCompareDefinition_I32;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.feature.TupleDesc_B;
import boofcv.struct.image.ImageSingleBand;

public class DescribePointBrief<T extends ImageSingleBand> {
    protected BlurFilter<T> filterBlur;
    protected T blur;
    protected DescribePointBinaryCompare<T> describe;

    public DescribePointBrief(DescribePointBinaryCompare<T> describe, BlurFilter<T> filterBlur) {
        this.filterBlur = filterBlur;
        this.describe = describe;
        this.blur = GeneralizedImageOps.createSingleBand(filterBlur.getInputType(), 1, 1);
    }

    public TupleDesc_B createFeature() {
        return new TupleDesc_B(this.describe.getDefinition().getLength());
    }

    public void setImage(T image) {
        ((ImageSingleBand)this.blur).reshape(((ImageSingleBand)image).width, ((ImageSingleBand)image).height);
        this.filterBlur.process(image, this.blur);
        this.describe.setImage(image);
    }

    public void process(double c_x, double c_y, TupleDesc_B feature) {
        this.describe.process((int)c_x, (int)c_y, feature);
    }

    public BinaryCompareDefinition_I32 getDefinition() {
        return this.describe.getDefinition();
    }
}

