/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.grid;

import boofcv.alg.feature.detect.quadblob.QuadBlob;
import georegression.metric.Intersection2D_F64;
import georegression.struct.line.LineSegment2D_F64;
import georegression.struct.point.Point2D_I32;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class ConnectGridSquares {
    public static List<QuadBlob> pruneSmallIslands(List<QuadBlob> blobs) {
        blobs = new ArrayList<QuadBlob>(blobs);
        List<QuadBlob> largest = new ArrayList<QuadBlob>();
        while (blobs.size() > 0) {
            List<QuadBlob> c = ConnectGridSquares.findIsland(blobs.remove(0), blobs);
            if (c.size() <= largest.size()) continue;
            largest = c;
        }
        return largest;
    }

    public static List<QuadBlob> findIsland(QuadBlob seed, List<QuadBlob> all) {
        ArrayList<QuadBlob> ret = new ArrayList<QuadBlob>();
        Stack<QuadBlob> open = new Stack<QuadBlob>();
        ret.add(seed);
        open.push(seed);
        while (open.size() > 0) {
            QuadBlob s = (QuadBlob)open.pop();
            for (QuadBlob c : s.conn) {
                if (ret.contains(c)) continue;
                all.remove(c);
                ret.add(c);
                open.add(c);
            }
        }
        return ret;
    }

    public static void connect(List<QuadBlob> blobs) {
        LineSegment2D_F64 centerLine = new LineSegment2D_F64();
        LineSegment2D_F64 cornerLine = new LineSegment2D_F64();
        for (int i = 0; i < blobs.size(); ++i) {
            QuadBlob b = blobs.get(i);
            centerLine.a.set((double)b.center.x, (double)b.center.y);
            for (int j = 0; j < 4; ++j) {
                Point2D_I32 c0 = b.corners.get(j);
                Point2D_I32 c1 = b.corners.get((j + 1) % 4);
                cornerLine.a.set((double)c0.x, (double)c0.y);
                cornerLine.b.set((double)c1.x, (double)c1.y);
                if (ConnectGridSquares.checkConnection(b.conn, centerLine, cornerLine)) continue;
                double best = Double.MAX_VALUE;
                QuadBlob bestBlob = null;
                for (int k = i + 1; k < blobs.size(); ++k) {
                    double max;
                    double d;
                    QuadBlob c = blobs.get(k);
                    centerLine.b.set((double)c.center.x, (double)c.center.y);
                    if (Intersection2D_F64.intersection((LineSegment2D_F64)cornerLine, (LineSegment2D_F64)centerLine, null) == null || !((d = (double)c.center.distance2(b.center)) < best) || !(d < (max = Math.min(c.largestSide, b.largestSide) * 2.5) * max)) continue;
                    best = d;
                    bestBlob = c;
                }
                if (bestBlob == null) continue;
                bestBlob.conn.add(b);
                b.conn.add(bestBlob);
            }
        }
    }

    private static boolean checkConnection(List<QuadBlob> connections, LineSegment2D_F64 centerLine, LineSegment2D_F64 cornerLine) {
        for (QuadBlob b : connections) {
            centerLine.b.set((double)b.center.x, (double)b.center.y);
            if (Intersection2D_F64.intersection((LineSegment2D_F64)cornerLine, (LineSegment2D_F64)centerLine, null) == null) continue;
            return true;
        }
        return false;
    }

    public static List<QuadBlob> copy(List<QuadBlob> input) {
        ArrayList<QuadBlob> output = new ArrayList<QuadBlob>();
        for (QuadBlob i : input) {
            QuadBlob o = new QuadBlob();
            o.contour = i.contour;
            o.corners = i.corners;
            o.center = i.center;
            o.largestSide = i.largestSide;
            o.smallestSide = i.smallestSide;
            output.add(o);
        }
        for (int index = 0; index < input.size(); ++index) {
            QuadBlob in = input.get(index);
            QuadBlob out = (QuadBlob)output.get(index);
            for (QuadBlob c : in.conn) {
                int i = input.indexOf(c);
                if (i < 0) continue;
                out.conn.add((QuadBlob)output.get(i));
            }
        }
        return output;
    }
}

