/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.interest;

import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.alg.feature.detect.extract.SelectNBestFeatures;
import boofcv.alg.feature.detect.intensity.GIntegralImageFeatureIntensity;
import boofcv.core.image.border.FactoryImageBorderAlgs;
import boofcv.core.image.border.ImageBorder_F32;
import boofcv.struct.FastQueue;
import boofcv.struct.QueueCorner;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;
import georegression.struct.point.Point2D_I16;
import java.util.List;

public class FastHessianFeatureDetector<II extends ImageSingleBand> {
    private NonMaxSuppression extractor;
    private SelectNBestFeatures sortBest;
    private int maxFeaturesPerScale;
    private ImageFloat32[] intensity;
    private int spaceIndex = 0;
    private QueueCorner foundFeatures = new QueueCorner(100);
    private FastQueue<ScalePoint> foundPoints = new FastQueue<ScalePoint>(10, ScalePoint.class, true);
    private int initialSize;
    private int numberOfOctaves;
    private int[] sizes;
    private int initialSampleRate;

    public FastHessianFeatureDetector(NonMaxSuppression extractor, int maxFeaturesPerScale, int initialSampleRate, int initialSize, int numberScalesPerOctave, int numberOfOctaves) {
        this.extractor = extractor;
        if (maxFeaturesPerScale > 0) {
            this.maxFeaturesPerScale = maxFeaturesPerScale;
            this.sortBest = new SelectNBestFeatures(maxFeaturesPerScale);
        }
        this.initialSampleRate = initialSampleRate;
        this.initialSize = initialSize;
        this.numberOfOctaves = numberOfOctaves;
        this.sizes = new int[numberScalesPerOctave];
    }

    public void detect(II integral) {
        if (this.intensity == null) {
            this.intensity = new ImageFloat32[3];
            for (int i = 0; i < this.intensity.length; ++i) {
                this.intensity[i] = new ImageFloat32(((ImageSingleBand)integral).width, ((ImageSingleBand)integral).height);
            }
        }
        this.foundPoints.reset();
        int skip = this.initialSampleRate;
        int sizeStep = 6;
        int octaveSize = this.initialSize;
        for (int octave = 0; octave < this.numberOfOctaves; ++octave) {
            for (int i = 0; i < this.sizes.length; ++i) {
                this.sizes[i] = octaveSize + i * sizeStep;
            }
            int maxSize = this.sizes[this.sizes.length - 1];
            if (maxSize > ((ImageSingleBand)integral).width || maxSize > ((ImageSingleBand)integral).height) break;
            this.detectOctave(integral, skip, this.sizes);
            skip += skip;
            octaveSize += sizeStep;
            sizeStep += sizeStep;
        }
    }

    protected void detectOctave(II integral, int skip, int ... featureSize) {
        int i;
        int w = ((ImageSingleBand)integral).width / skip;
        int h = ((ImageSingleBand)integral).height / skip;
        for (i = 0; i < this.intensity.length; ++i) {
            this.intensity[i].reshape(w, h);
        }
        for (i = 0; i < featureSize.length; ++i) {
            GIntegralImageFeatureIntensity.hessian(integral, skip, featureSize[i], this.intensity[this.spaceIndex]);
            ++this.spaceIndex;
            if (this.spaceIndex >= 3) {
                this.spaceIndex = 0;
            }
            if (i < 2) continue;
            this.findLocalScaleSpaceMax(featureSize, i - 1, skip);
        }
    }

    private void findLocalScaleSpaceMax(int[] size, int level, int skip) {
        int numberRemaining;
        QueueCorner features;
        int index0 = this.spaceIndex;
        int index1 = (this.spaceIndex + 1) % 3;
        int index2 = (this.spaceIndex + 2) % 3;
        ImageBorder_F32 inten0 = FactoryImageBorderAlgs.value(this.intensity[index0], 0.0f);
        ImageFloat32 inten1 = this.intensity[index1];
        ImageBorder_F32 inten2 = FactoryImageBorderAlgs.value(this.intensity[index2], 0.0f);
        this.foundFeatures.reset();
        this.extractor.setIgnoreBorder(size[level] / (2 * skip) + this.extractor.getSearchRadius());
        this.extractor.process(this.intensity[index1], null, null, null, this.foundFeatures);
        if (this.sortBest != null) {
            this.sortBest.process(this.intensity[index1], this.foundFeatures, true);
            features = this.sortBest.getBestCorners();
            numberRemaining = this.maxFeaturesPerScale;
        } else {
            features = this.foundFeatures;
            numberRemaining = Integer.MAX_VALUE;
        }
        int levelSize = size[level];
        int sizeStep = levelSize - size[level - 1];
        for (int i = 0; i < features.size && numberRemaining > 0; ++i) {
            Point2D_I16 f = (Point2D_I16)features.get(i);
            float val = inten1.get(f.x, f.y);
            if (!FastHessianFeatureDetector.checkMax(inten0, val, f.x, f.y) || !FastHessianFeatureDetector.checkMax(inten2, val, f.x, f.y)) continue;
            float peakX = FastHessianFeatureDetector.polyPeak(inten1.get(f.x - 1, f.y), inten1.get(f.x, f.y), inten1.get(f.x + 1, f.y));
            float peakY = FastHessianFeatureDetector.polyPeak(inten1.get(f.x, f.y - 1), inten1.get(f.x, f.y), inten1.get(f.x, f.y + 1));
            float peakS = FastHessianFeatureDetector.polyPeak(inten0.get(f.x, f.y), inten1.get(f.x, f.y), inten2.get(f.x, f.y));
            float interpX = ((float)f.x + peakX) * (float)skip;
            float interpY = ((float)f.y + peakY) * (float)skip;
            float interpS = (float)levelSize + peakS * (float)sizeStep;
            double scale = 1.2 * (double)interpS / 9.0;
            this.foundPoints.grow().set(interpX, interpY, scale);
            --numberRemaining;
        }
    }

    protected static boolean checkMax(ImageBorder_F32 inten, float bestScore, int c_x, int c_y) {
        for (int y = c_y - 1; y <= c_y + 1; ++y) {
            for (int x = c_x - 1; x <= c_x + 1; ++x) {
                if (!(inten.get(x, y) >= bestScore)) continue;
                return false;
            }
        }
        return true;
    }

    public static float polyPeak(float lower, float middle, float upper) {
        float a = 0.5f * lower - middle + 0.5f * upper;
        float b = 0.5f * upper - 0.5f * lower;
        return -b / (2.0f * a);
    }

    public List<ScalePoint> getFoundPoints() {
        return this.foundPoints.toList();
    }

    public int getSmallestWidth() {
        return this.initialSize;
    }
}

