/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity.impl;

import boofcv.alg.InputSanityCheck;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;
import java.util.Arrays;

public class StereoDisparityWtoNaiveFive<I extends ImageSingleBand> {
    I imageLeft;
    I imageRight;
    int minDisparity;
    double[] score;
    double[] four = new double[4];
    int radiusX;
    int radiusY;
    int w;
    int h;

    public StereoDisparityWtoNaiveFive(int minDisparity, int maxDisparity, int radiusWidth, int radiusHeight) {
        this.minDisparity = minDisparity;
        this.score = new double[maxDisparity];
        this.radiusX = radiusWidth;
        this.radiusY = radiusHeight;
    }

    public void process(I left, I right, ImageFloat32 imageDisparity) {
        InputSanityCheck.checkSameShape(left, right, imageDisparity);
        this.imageLeft = left;
        this.imageRight = right;
        this.w = ((ImageSingleBand)left).width;
        this.h = ((ImageSingleBand)left).height;
        for (int y = this.radiusY * 2; y < this.h - this.radiusY * 2; ++y) {
            for (int x = this.radiusX * 2 + this.minDisparity; x < this.w - this.radiusX * 2; ++x) {
                int max = x - Math.max(this.radiusX * 2 - 1, x - this.score.length);
                this.processPixel(x, y, max);
                imageDisparity.set(x, y, (float)this.selectBest(max));
            }
        }
    }

    private void processPixel(int c_x, int c_y, int maxDisparity) {
        for (int i = this.minDisparity; i < maxDisparity; ++i) {
            this.score[i] = this.computeScore(c_x, c_x - i, c_y);
        }
    }

    protected double selectBest(int length) {
        double best = Double.MAX_VALUE;
        int index = -1;
        for (int i = this.minDisparity; i < length; ++i) {
            if (!(this.score[i] < best)) continue;
            best = this.score[i];
            index = i;
        }
        return index - this.minDisparity;
    }

    protected double computeScore(int leftX, int rightX, int centerY) {
        double center = this.computeScoreRect(leftX, rightX, centerY);
        this.four[0] = this.computeScoreRect(leftX - this.radiusX, rightX - this.radiusX, centerY - this.radiusY);
        this.four[1] = this.computeScoreRect(leftX + this.radiusX, rightX + this.radiusX, centerY - this.radiusY);
        this.four[2] = this.computeScoreRect(leftX - this.radiusX, rightX - this.radiusX, centerY + this.radiusY);
        this.four[3] = this.computeScoreRect(leftX + this.radiusX, rightX + this.radiusX, centerY + this.radiusY);
        Arrays.sort(this.four);
        return this.four[0] + this.four[1] + center;
    }

    protected double computeScoreRect(int leftX, int rightX, int centerY) {
        double ret = 0.0;
        for (int y = -this.radiusY; y <= this.radiusY; ++y) {
            for (int x = -this.radiusX; x <= this.radiusX; ++x) {
                double l = GeneralizedImageOps.get(this.imageLeft, leftX + x, centerY + y);
                double r = GeneralizedImageOps.get(this.imageRight, rightX + x, centerY + y);
                ret += Math.abs(l - r);
            }
        }
        return ret;
    }
}

