/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.convolve.ConvolveImageNoBorder;
import boofcv.alg.filter.convolve.border.ConvolveJustBorder_General;
import boofcv.core.image.border.ImageBorder_F32;
import boofcv.core.image.border.ImageBorder_I32;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_I32;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_I32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageUInt8;

public class ConvolveWithBorder {
    public static void horizontal(Kernel1D_F32 kernel, ImageFloat32 image, ImageFloat32 dest, ImageBorder_F32 border) {
        InputSanityCheck.checkSameShape(image, dest);
        border.setImage(image);
        ConvolveImageNoBorder.horizontal(kernel, image, dest, true);
        ConvolveJustBorder_General.horizontal(kernel, border, dest, kernel.getRadius());
    }

    public static void vertical(Kernel1D_F32 kernel, ImageFloat32 image, ImageFloat32 dest, ImageBorder_F32 border) {
        InputSanityCheck.checkSameShape(image, dest);
        border.setImage(image);
        ConvolveImageNoBorder.vertical(kernel, image, dest, true);
        ConvolveJustBorder_General.vertical(kernel, border, dest, kernel.getRadius());
    }

    public static void convolve(Kernel2D_F32 kernel, ImageFloat32 image, ImageFloat32 dest, ImageBorder_F32 border) {
        InputSanityCheck.checkSameShape(image, dest);
        border.setImage(image);
        ConvolveImageNoBorder.convolve(kernel, image, dest);
        ConvolveJustBorder_General.convolve(kernel, border, dest, kernel.getRadius());
    }

    public static void horizontal(Kernel1D_I32 kernel, ImageUInt8 image, ImageInt16 dest, ImageBorder_I32 border) {
        InputSanityCheck.checkSameShape(image, dest);
        border.setImage(image);
        ConvolveImageNoBorder.horizontal(kernel, image, dest, true);
        ConvolveJustBorder_General.horizontal(kernel, border, dest, kernel.getRadius());
    }

    public static void vertical(Kernel1D_I32 kernel, ImageUInt8 image, ImageInt16 dest, ImageBorder_I32 border) {
        InputSanityCheck.checkSameShape(image, dest);
        border.setImage(image);
        ConvolveImageNoBorder.vertical(kernel, image, dest, true);
        ConvolveJustBorder_General.vertical(kernel, border, dest, kernel.getRadius());
    }

    public static void convolve(Kernel2D_I32 kernel, ImageUInt8 image, ImageInt16 dest, ImageBorder_I32 border) {
        InputSanityCheck.checkSameShape(image, dest);
        border.setImage(image);
        ConvolveImageNoBorder.convolve(kernel, image, dest);
        ConvolveJustBorder_General.convolve(kernel, border, dest, kernel.getRadius());
    }

    public static void horizontal(Kernel1D_I32 kernel, ImageUInt8 image, ImageSInt32 dest, ImageBorder_I32 border) {
        InputSanityCheck.checkSameShape(image, dest);
        border.setImage(image);
        ConvolveImageNoBorder.horizontal(kernel, image, dest, true);
        ConvolveJustBorder_General.horizontal(kernel, border, dest, kernel.getRadius());
    }

    public static void vertical(Kernel1D_I32 kernel, ImageUInt8 image, ImageSInt32 dest, ImageBorder_I32 border) {
        InputSanityCheck.checkSameShape(image, dest);
        border.setImage(image);
        ConvolveImageNoBorder.vertical(kernel, image, dest, true);
        ConvolveJustBorder_General.vertical(kernel, border, dest, kernel.getRadius());
    }

    public static void convolve(Kernel2D_I32 kernel, ImageUInt8 image, ImageSInt32 dest, ImageBorder_I32 border) {
        InputSanityCheck.checkSameShape(image, dest);
        border.setImage(image);
        ConvolveImageNoBorder.convolve(kernel, image, dest);
        ConvolveJustBorder_General.convolve(kernel, border, dest, kernel.getRadius());
    }

    public static void horizontal(Kernel1D_I32 kernel, ImageSInt16 image, ImageInt16 dest, ImageBorder_I32 border) {
        InputSanityCheck.checkSameShape(image, dest);
        border.setImage(image);
        ConvolveImageNoBorder.horizontal(kernel, image, dest, true);
        ConvolveJustBorder_General.horizontal(kernel, border, dest, kernel.getRadius());
    }

    public static void vertical(Kernel1D_I32 kernel, ImageSInt16 image, ImageInt16 dest, ImageBorder_I32 border) {
        InputSanityCheck.checkSameShape(image, dest);
        border.setImage(image);
        ConvolveImageNoBorder.vertical(kernel, image, dest, true);
        ConvolveJustBorder_General.vertical(kernel, border, dest, kernel.getRadius());
    }

    public static void convolve(Kernel2D_I32 kernel, ImageSInt16 image, ImageInt16 dest, ImageBorder_I32 border) {
        InputSanityCheck.checkSameShape(image, dest);
        border.setImage(image);
        ConvolveImageNoBorder.convolve(kernel, image, dest);
        ConvolveJustBorder_General.convolve(kernel, border, dest, kernel.getRadius());
    }
}

