/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve.normalized;

import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_I32;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_I32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageInt8;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageUInt8;

public class ConvolveNormalized_JustBorder {
    public static void horizontal(Kernel1D_F32 kernel, ImageFloat32 input, ImageFloat32 output) {
        float[] dataSrc = input.data;
        float[] dataDst = output.data;
        float[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int kernelWidth = kernel.getWidth();
        int width = input.getWidth();
        int height = input.getHeight();
        for (int i = 0; i < height; ++i) {
            int indexSrc;
            float totalWeight;
            float total;
            int j;
            int indexDest = output.startIndex + i * output.stride;
            int jStart = j = input.startIndex + i * input.stride;
            int jEnd = j + radius;
            while (j < jEnd) {
                total = 0.0f;
                totalWeight = 0.0f;
                indexSrc = jStart;
                for (int k = kernelWidth - (radius + 1 + j - jStart); k < kernelWidth; ++k) {
                    float w = dataKer[k];
                    totalWeight += w;
                    total += dataSrc[indexSrc++] * w;
                }
                dataDst[indexDest++] = total / totalWeight;
                ++j;
            }
            j += width - 2 * radius;
            indexDest += width - 2 * radius;
            jEnd = jStart + width;
            while (j < jEnd) {
                total = 0.0f;
                totalWeight = 0.0f;
                indexSrc = j - radius;
                int kEnd = jEnd - indexSrc;
                for (int k = 0; k < kEnd; ++k) {
                    float w = dataKer[k];
                    totalWeight += w;
                    total += dataSrc[indexSrc++] * w;
                }
                dataDst[indexDest++] = total / totalWeight;
                ++j;
            }
        }
    }

    public static void vertical(Kernel1D_F32 kernel, ImageFloat32 input, ImageFloat32 output) {
        int k;
        int indexSrc;
        float weight;
        int iEnd;
        int i;
        int indexDst;
        int y;
        float[] dataSrc = input.data;
        float[] dataDst = output.data;
        float[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int kernelWidth = kernel.getWidth();
        int imgWidth = output.getWidth();
        int imgHeight = output.getHeight();
        int yEnd = imgHeight - radius;
        for (y = 0; y < radius; ++y) {
            indexDst = output.startIndex + y * output.stride;
            i = input.startIndex + y * input.stride;
            iEnd = i + imgWidth;
            int kStart = radius - y;
            weight = 0.0f;
            for (int k2 = kStart; k2 < kernelWidth; ++k2) {
                weight += dataKer[k2];
            }
            while (i < iEnd) {
                float total = 0.0f;
                indexSrc = i - y * input.stride;
                k = kStart;
                while (k < kernelWidth) {
                    total += dataSrc[indexSrc] * dataKer[k];
                    ++k;
                    indexSrc += input.stride;
                }
                dataDst[indexDst++] = total / weight;
                ++i;
            }
        }
        for (y = yEnd; y < imgHeight; ++y) {
            indexDst = output.startIndex + y * output.stride;
            i = input.startIndex + y * input.stride;
            iEnd = i + imgWidth;
            int kEnd = imgHeight - (y - radius);
            weight = 0.0f;
            for (int k3 = 0; k3 < kEnd; ++k3) {
                weight += dataKer[k3];
            }
            while (i < iEnd) {
                float total = 0.0f;
                indexSrc = i - radius * input.stride;
                k = 0;
                while (k < kEnd) {
                    total += dataSrc[indexSrc] * dataKer[k];
                    ++k;
                    indexSrc += input.stride;
                }
                dataDst[indexDst++] = total / weight;
                ++i;
            }
        }
    }

    public static void convolve(Kernel2D_F32 kernel, ImageFloat32 input, ImageFloat32 output) {
        int y;
        float[] dataSrc = input.data;
        float[] dataDst = output.data;
        float[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int kernelWidth = kernel.getWidth();
        int width = input.getWidth();
        int height = input.getHeight();
        for (y = 0; y < height; ++y) {
            int x;
            int minI = y >= radius ? -radius : -y;
            int maxI = y < height - radius ? radius : height - y - 1;
            int indexDst = output.startIndex + y * output.stride;
            for (x = 0; x < radius; ++x) {
                float total = 0.0f;
                float totalWeight = 0.0f;
                for (int i = minI; i <= maxI; ++i) {
                    int indexSrc = input.startIndex + (y + i) * input.stride + x;
                    int indexKer = (i + radius) * kernelWidth;
                    for (int j = -x; j <= radius; ++j) {
                        float w = dataKer[indexKer + j + radius];
                        totalWeight += w;
                        total += dataSrc[indexSrc + j] * w;
                    }
                }
                dataDst[indexDst++] = total / totalWeight;
            }
            indexDst = output.startIndex + y * output.stride + width - radius;
            for (x = width - radius; x < width; ++x) {
                int maxJ = width - x - 1;
                float total = 0.0f;
                float totalWeight = 0.0f;
                for (int i = minI; i <= maxI; ++i) {
                    int indexSrc = input.startIndex + (y + i) * input.stride + x;
                    int indexKer = (i + radius) * kernelWidth;
                    for (int j = -radius; j <= maxJ; ++j) {
                        float w = dataKer[indexKer + j + radius];
                        totalWeight += w;
                        total += dataSrc[indexSrc + j] * w;
                    }
                }
                dataDst[indexDst++] = total / totalWeight;
            }
        }
        for (y = 0; y < radius; ++y) {
            int indexDst = output.startIndex + y * output.stride + radius;
            for (int x = radius; x < width - radius; ++x) {
                float total = 0.0f;
                float totalWeight = 0.0f;
                for (int i = -y; i <= radius; ++i) {
                    int indexSrc = input.startIndex + (y + i) * input.stride + x;
                    int indexKer = (i + radius) * kernelWidth;
                    for (int j = -radius; j <= radius; ++j) {
                        float w = dataKer[indexKer + j + radius];
                        totalWeight += w;
                        total += dataSrc[indexSrc + j] * w;
                    }
                }
                dataDst[indexDst++] = total / totalWeight;
            }
        }
        for (y = height - radius; y < height; ++y) {
            int maxI = height - y - 1;
            int indexDst = output.startIndex + y * output.stride + radius;
            for (int x = radius; x < width - radius; ++x) {
                float total = 0.0f;
                float totalWeight = 0.0f;
                for (int i = -radius; i <= maxI; ++i) {
                    int indexSrc = input.startIndex + (y + i) * input.stride + x;
                    int indexKer = (i + radius) * kernelWidth;
                    for (int j = -radius; j <= radius; ++j) {
                        float w = dataKer[indexKer + j + radius];
                        totalWeight += w;
                        total += dataSrc[indexSrc + j] * w;
                    }
                }
                dataDst[indexDst++] = total / totalWeight;
            }
        }
    }

    public static void horizontal(Kernel1D_I32 kernel, ImageUInt8 input, ImageInt8 output) {
        byte[] dataSrc = input.data;
        byte[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int kernelWidth = kernel.getWidth();
        int width = input.getWidth();
        int height = input.getHeight();
        for (int i = 0; i < height; ++i) {
            int indexSrc;
            int totalWeight;
            int total;
            int j;
            int indexDest = output.startIndex + i * output.stride;
            int jStart = j = input.startIndex + i * input.stride;
            int jEnd = j + radius;
            while (j < jEnd) {
                total = 0;
                totalWeight = 0;
                indexSrc = jStart;
                for (int k = kernelWidth - (radius + 1 + j - jStart); k < kernelWidth; ++k) {
                    int w = dataKer[k];
                    totalWeight += w;
                    total += (dataSrc[indexSrc++] & 0xFF) * w;
                }
                dataDst[indexDest++] = (byte)(total / totalWeight);
                ++j;
            }
            j += width - 2 * radius;
            indexDest += width - 2 * radius;
            jEnd = jStart + width;
            while (j < jEnd) {
                total = 0;
                totalWeight = 0;
                indexSrc = j - radius;
                int kEnd = jEnd - indexSrc;
                for (int k = 0; k < kEnd; ++k) {
                    int w = dataKer[k];
                    totalWeight += w;
                    total += (dataSrc[indexSrc++] & 0xFF) * w;
                }
                dataDst[indexDest++] = (byte)(total / totalWeight);
                ++j;
            }
        }
    }

    public static void vertical(Kernel1D_I32 kernel, ImageUInt8 input, ImageInt8 output) {
        int k;
        int indexSrc;
        int total;
        int k2;
        int weight;
        int iEnd;
        int i;
        int indexDst;
        int y;
        byte[] dataSrc = input.data;
        byte[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int kernelWidth = kernel.getWidth();
        int imgWidth = output.getWidth();
        int imgHeight = output.getHeight();
        int yEnd = imgHeight - radius;
        for (y = 0; y < radius; ++y) {
            indexDst = output.startIndex + y * output.stride;
            i = input.startIndex + y * input.stride;
            iEnd = i + imgWidth;
            int kStart = radius - y;
            weight = 0;
            for (k2 = kStart; k2 < kernelWidth; ++k2) {
                weight += dataKer[k2];
            }
            while (i < iEnd) {
                total = 0;
                indexSrc = i - y * input.stride;
                k = kStart;
                while (k < kernelWidth) {
                    total += (dataSrc[indexSrc] & 0xFF) * dataKer[k];
                    ++k;
                    indexSrc += input.stride;
                }
                dataDst[indexDst++] = (byte)(total / weight);
                ++i;
            }
        }
        for (y = yEnd; y < imgHeight; ++y) {
            indexDst = output.startIndex + y * output.stride;
            i = input.startIndex + y * input.stride;
            iEnd = i + imgWidth;
            int kEnd = imgHeight - (y - radius);
            weight = 0;
            for (k2 = 0; k2 < kEnd; ++k2) {
                weight += dataKer[k2];
            }
            while (i < iEnd) {
                total = 0;
                indexSrc = i - radius * input.stride;
                k = 0;
                while (k < kEnd) {
                    total += (dataSrc[indexSrc] & 0xFF) * dataKer[k];
                    ++k;
                    indexSrc += input.stride;
                }
                dataDst[indexDst++] = (byte)(total / weight);
                ++i;
            }
        }
    }

    public static void convolve(Kernel2D_I32 kernel, ImageUInt8 input, ImageInt8 output) {
        int y;
        byte[] dataSrc = input.data;
        byte[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int kernelWidth = kernel.getWidth();
        int width = input.getWidth();
        int height = input.getHeight();
        for (y = 0; y < height; ++y) {
            int x;
            int minI = y >= radius ? -radius : -y;
            int maxI = y < height - radius ? radius : height - y - 1;
            int indexDst = output.startIndex + y * output.stride;
            for (x = 0; x < radius; ++x) {
                int total = 0;
                int totalWeight = 0;
                for (int i = minI; i <= maxI; ++i) {
                    int indexSrc = input.startIndex + (y + i) * input.stride + x;
                    int indexKer = (i + radius) * kernelWidth;
                    for (int j = -x; j <= radius; ++j) {
                        int w = dataKer[indexKer + j + radius];
                        totalWeight += w;
                        total += (dataSrc[indexSrc + j] & 0xFF) * w;
                    }
                }
                dataDst[indexDst++] = (byte)(total / totalWeight);
            }
            indexDst = output.startIndex + y * output.stride + width - radius;
            for (x = width - radius; x < width; ++x) {
                int maxJ = width - x - 1;
                int total = 0;
                int totalWeight = 0;
                for (int i = minI; i <= maxI; ++i) {
                    int indexSrc = input.startIndex + (y + i) * input.stride + x;
                    int indexKer = (i + radius) * kernelWidth;
                    for (int j = -radius; j <= maxJ; ++j) {
                        int w = dataKer[indexKer + j + radius];
                        totalWeight += w;
                        total += (dataSrc[indexSrc + j] & 0xFF) * w;
                    }
                }
                dataDst[indexDst++] = (byte)(total / totalWeight);
            }
        }
        for (y = 0; y < radius; ++y) {
            int indexDst = output.startIndex + y * output.stride + radius;
            for (int x = radius; x < width - radius; ++x) {
                int total = 0;
                int totalWeight = 0;
                for (int i = -y; i <= radius; ++i) {
                    int indexSrc = input.startIndex + (y + i) * input.stride + x;
                    int indexKer = (i + radius) * kernelWidth;
                    for (int j = -radius; j <= radius; ++j) {
                        int w = dataKer[indexKer + j + radius];
                        totalWeight += w;
                        total += (dataSrc[indexSrc + j] & 0xFF) * w;
                    }
                }
                dataDst[indexDst++] = (byte)(total / totalWeight);
            }
        }
        for (y = height - radius; y < height; ++y) {
            int maxI = height - y - 1;
            int indexDst = output.startIndex + y * output.stride + radius;
            for (int x = radius; x < width - radius; ++x) {
                int total = 0;
                int totalWeight = 0;
                for (int i = -radius; i <= maxI; ++i) {
                    int indexSrc = input.startIndex + (y + i) * input.stride + x;
                    int indexKer = (i + radius) * kernelWidth;
                    for (int j = -radius; j <= radius; ++j) {
                        int w = dataKer[indexKer + j + radius];
                        totalWeight += w;
                        total += (dataSrc[indexSrc + j] & 0xFF) * w;
                    }
                }
                dataDst[indexDst++] = (byte)(total / totalWeight);
            }
        }
    }

    public static void horizontal(Kernel1D_I32 kernel, ImageSInt16 input, ImageInt16 output) {
        short[] dataSrc = input.data;
        short[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int kernelWidth = kernel.getWidth();
        int width = input.getWidth();
        int height = input.getHeight();
        for (int i = 0; i < height; ++i) {
            int indexSrc;
            int totalWeight;
            int total;
            int j;
            int indexDest = output.startIndex + i * output.stride;
            int jStart = j = input.startIndex + i * input.stride;
            int jEnd = j + radius;
            while (j < jEnd) {
                total = 0;
                totalWeight = 0;
                indexSrc = jStart;
                for (int k = kernelWidth - (radius + 1 + j - jStart); k < kernelWidth; ++k) {
                    int w = dataKer[k];
                    totalWeight += w;
                    total += dataSrc[indexSrc++] * w;
                }
                dataDst[indexDest++] = (short)(total / totalWeight);
                ++j;
            }
            j += width - 2 * radius;
            indexDest += width - 2 * radius;
            jEnd = jStart + width;
            while (j < jEnd) {
                total = 0;
                totalWeight = 0;
                indexSrc = j - radius;
                int kEnd = jEnd - indexSrc;
                for (int k = 0; k < kEnd; ++k) {
                    int w = dataKer[k];
                    totalWeight += w;
                    total += dataSrc[indexSrc++] * w;
                }
                dataDst[indexDest++] = (short)(total / totalWeight);
                ++j;
            }
        }
    }

    public static void vertical(Kernel1D_I32 kernel, ImageSInt16 input, ImageInt16 output) {
        int k;
        int indexSrc;
        int total;
        int k2;
        int weight;
        int iEnd;
        int i;
        int indexDst;
        int y;
        short[] dataSrc = input.data;
        short[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int kernelWidth = kernel.getWidth();
        int imgWidth = output.getWidth();
        int imgHeight = output.getHeight();
        int yEnd = imgHeight - radius;
        for (y = 0; y < radius; ++y) {
            indexDst = output.startIndex + y * output.stride;
            i = input.startIndex + y * input.stride;
            iEnd = i + imgWidth;
            int kStart = radius - y;
            weight = 0;
            for (k2 = kStart; k2 < kernelWidth; ++k2) {
                weight += dataKer[k2];
            }
            while (i < iEnd) {
                total = 0;
                indexSrc = i - y * input.stride;
                k = kStart;
                while (k < kernelWidth) {
                    total += dataSrc[indexSrc] * dataKer[k];
                    ++k;
                    indexSrc += input.stride;
                }
                dataDst[indexDst++] = (short)(total / weight);
                ++i;
            }
        }
        for (y = yEnd; y < imgHeight; ++y) {
            indexDst = output.startIndex + y * output.stride;
            i = input.startIndex + y * input.stride;
            iEnd = i + imgWidth;
            int kEnd = imgHeight - (y - radius);
            weight = 0;
            for (k2 = 0; k2 < kEnd; ++k2) {
                weight += dataKer[k2];
            }
            while (i < iEnd) {
                total = 0;
                indexSrc = i - radius * input.stride;
                k = 0;
                while (k < kEnd) {
                    total += dataSrc[indexSrc] * dataKer[k];
                    ++k;
                    indexSrc += input.stride;
                }
                dataDst[indexDst++] = (short)(total / weight);
                ++i;
            }
        }
    }

    public static void convolve(Kernel2D_I32 kernel, ImageSInt16 input, ImageInt16 output) {
        int y;
        short[] dataSrc = input.data;
        short[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int kernelWidth = kernel.getWidth();
        int width = input.getWidth();
        int height = input.getHeight();
        for (y = 0; y < height; ++y) {
            int x;
            int minI = y >= radius ? -radius : -y;
            int maxI = y < height - radius ? radius : height - y - 1;
            int indexDst = output.startIndex + y * output.stride;
            for (x = 0; x < radius; ++x) {
                int total = 0;
                int totalWeight = 0;
                for (int i = minI; i <= maxI; ++i) {
                    int indexSrc = input.startIndex + (y + i) * input.stride + x;
                    int indexKer = (i + radius) * kernelWidth;
                    for (int j = -x; j <= radius; ++j) {
                        int w = dataKer[indexKer + j + radius];
                        totalWeight += w;
                        total += dataSrc[indexSrc + j] * w;
                    }
                }
                dataDst[indexDst++] = (short)(total / totalWeight);
            }
            indexDst = output.startIndex + y * output.stride + width - radius;
            for (x = width - radius; x < width; ++x) {
                int maxJ = width - x - 1;
                int total = 0;
                int totalWeight = 0;
                for (int i = minI; i <= maxI; ++i) {
                    int indexSrc = input.startIndex + (y + i) * input.stride + x;
                    int indexKer = (i + radius) * kernelWidth;
                    for (int j = -radius; j <= maxJ; ++j) {
                        int w = dataKer[indexKer + j + radius];
                        totalWeight += w;
                        total += dataSrc[indexSrc + j] * w;
                    }
                }
                dataDst[indexDst++] = (short)(total / totalWeight);
            }
        }
        for (y = 0; y < radius; ++y) {
            int indexDst = output.startIndex + y * output.stride + radius;
            for (int x = radius; x < width - radius; ++x) {
                int total = 0;
                int totalWeight = 0;
                for (int i = -y; i <= radius; ++i) {
                    int indexSrc = input.startIndex + (y + i) * input.stride + x;
                    int indexKer = (i + radius) * kernelWidth;
                    for (int j = -radius; j <= radius; ++j) {
                        int w = dataKer[indexKer + j + radius];
                        totalWeight += w;
                        total += dataSrc[indexSrc + j] * w;
                    }
                }
                dataDst[indexDst++] = (short)(total / totalWeight);
            }
        }
        for (y = height - radius; y < height; ++y) {
            int maxI = height - y - 1;
            int indexDst = output.startIndex + y * output.stride + radius;
            for (int x = radius; x < width - radius; ++x) {
                int total = 0;
                int totalWeight = 0;
                for (int i = -radius; i <= maxI; ++i) {
                    int indexSrc = input.startIndex + (y + i) * input.stride + x;
                    int indexKer = (i + radius) * kernelWidth;
                    for (int j = -radius; j <= radius; ++j) {
                        int w = dataKer[indexKer + j + radius];
                        totalWeight += w;
                        total += dataSrc[indexSrc + j] * w;
                    }
                }
                dataDst[indexDst++] = (short)(total / totalWeight);
            }
        }
    }

    public static void horizontal(Kernel1D_I32 kernel, ImageSInt32 input, ImageSInt32 output) {
        int[] dataSrc = input.data;
        int[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int kernelWidth = kernel.getWidth();
        int width = input.getWidth();
        int height = input.getHeight();
        for (int i = 0; i < height; ++i) {
            int indexSrc;
            int totalWeight;
            int total;
            int j;
            int indexDest = output.startIndex + i * output.stride;
            int jStart = j = input.startIndex + i * input.stride;
            int jEnd = j + radius;
            while (j < jEnd) {
                total = 0;
                totalWeight = 0;
                indexSrc = jStart;
                for (int k = kernelWidth - (radius + 1 + j - jStart); k < kernelWidth; ++k) {
                    int w = dataKer[k];
                    totalWeight += w;
                    total += dataSrc[indexSrc++] * w;
                }
                dataDst[indexDest++] = total / totalWeight;
                ++j;
            }
            j += width - 2 * radius;
            indexDest += width - 2 * radius;
            jEnd = jStart + width;
            while (j < jEnd) {
                total = 0;
                totalWeight = 0;
                indexSrc = j - radius;
                int kEnd = jEnd - indexSrc;
                for (int k = 0; k < kEnd; ++k) {
                    int w = dataKer[k];
                    totalWeight += w;
                    total += dataSrc[indexSrc++] * w;
                }
                dataDst[indexDest++] = total / totalWeight;
                ++j;
            }
        }
    }

    public static void vertical(Kernel1D_I32 kernel, ImageSInt32 input, ImageSInt32 output) {
        int k;
        int indexSrc;
        int total;
        int k2;
        int weight;
        int iEnd;
        int i;
        int indexDst;
        int y;
        int[] dataSrc = input.data;
        int[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int kernelWidth = kernel.getWidth();
        int imgWidth = output.getWidth();
        int imgHeight = output.getHeight();
        int yEnd = imgHeight - radius;
        for (y = 0; y < radius; ++y) {
            indexDst = output.startIndex + y * output.stride;
            i = input.startIndex + y * input.stride;
            iEnd = i + imgWidth;
            int kStart = radius - y;
            weight = 0;
            for (k2 = kStart; k2 < kernelWidth; ++k2) {
                weight += dataKer[k2];
            }
            while (i < iEnd) {
                total = 0;
                indexSrc = i - y * input.stride;
                k = kStart;
                while (k < kernelWidth) {
                    total += dataSrc[indexSrc] * dataKer[k];
                    ++k;
                    indexSrc += input.stride;
                }
                dataDst[indexDst++] = total / weight;
                ++i;
            }
        }
        for (y = yEnd; y < imgHeight; ++y) {
            indexDst = output.startIndex + y * output.stride;
            i = input.startIndex + y * input.stride;
            iEnd = i + imgWidth;
            int kEnd = imgHeight - (y - radius);
            weight = 0;
            for (k2 = 0; k2 < kEnd; ++k2) {
                weight += dataKer[k2];
            }
            while (i < iEnd) {
                total = 0;
                indexSrc = i - radius * input.stride;
                k = 0;
                while (k < kEnd) {
                    total += dataSrc[indexSrc] * dataKer[k];
                    ++k;
                    indexSrc += input.stride;
                }
                dataDst[indexDst++] = total / weight;
                ++i;
            }
        }
    }

    public static void convolve(Kernel2D_I32 kernel, ImageSInt32 input, ImageSInt32 output) {
        int y;
        int[] dataSrc = input.data;
        int[] dataDst = output.data;
        int[] dataKer = kernel.data;
        int radius = kernel.getRadius();
        int kernelWidth = kernel.getWidth();
        int width = input.getWidth();
        int height = input.getHeight();
        for (y = 0; y < height; ++y) {
            int x;
            int minI = y >= radius ? -radius : -y;
            int maxI = y < height - radius ? radius : height - y - 1;
            int indexDst = output.startIndex + y * output.stride;
            for (x = 0; x < radius; ++x) {
                int total = 0;
                int totalWeight = 0;
                for (int i = minI; i <= maxI; ++i) {
                    int indexSrc = input.startIndex + (y + i) * input.stride + x;
                    int indexKer = (i + radius) * kernelWidth;
                    for (int j = -x; j <= radius; ++j) {
                        int w = dataKer[indexKer + j + radius];
                        totalWeight += w;
                        total += dataSrc[indexSrc + j] * w;
                    }
                }
                dataDst[indexDst++] = total / totalWeight;
            }
            indexDst = output.startIndex + y * output.stride + width - radius;
            for (x = width - radius; x < width; ++x) {
                int maxJ = width - x - 1;
                int total = 0;
                int totalWeight = 0;
                for (int i = minI; i <= maxI; ++i) {
                    int indexSrc = input.startIndex + (y + i) * input.stride + x;
                    int indexKer = (i + radius) * kernelWidth;
                    for (int j = -radius; j <= maxJ; ++j) {
                        int w = dataKer[indexKer + j + radius];
                        totalWeight += w;
                        total += dataSrc[indexSrc + j] * w;
                    }
                }
                dataDst[indexDst++] = total / totalWeight;
            }
        }
        for (y = 0; y < radius; ++y) {
            int indexDst = output.startIndex + y * output.stride + radius;
            for (int x = radius; x < width - radius; ++x) {
                int total = 0;
                int totalWeight = 0;
                for (int i = -y; i <= radius; ++i) {
                    int indexSrc = input.startIndex + (y + i) * input.stride + x;
                    int indexKer = (i + radius) * kernelWidth;
                    for (int j = -radius; j <= radius; ++j) {
                        int w = dataKer[indexKer + j + radius];
                        totalWeight += w;
                        total += dataSrc[indexSrc + j] * w;
                    }
                }
                dataDst[indexDst++] = total / totalWeight;
            }
        }
        for (y = height - radius; y < height; ++y) {
            int maxI = height - y - 1;
            int indexDst = output.startIndex + y * output.stride + radius;
            for (int x = radius; x < width - radius; ++x) {
                int total = 0;
                int totalWeight = 0;
                for (int i = -radius; i <= maxI; ++i) {
                    int indexSrc = input.startIndex + (y + i) * input.stride + x;
                    int indexKer = (i + radius) * kernelWidth;
                    for (int j = -radius; j <= radius; ++j) {
                        int w = dataKer[indexKer + j + radius];
                        totalWeight += w;
                        total += dataSrc[indexSrc + j] * w;
                    }
                }
                dataDst[indexDst++] = total / totalWeight;
            }
        }
    }
}

