/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.misc;

import boofcv.alg.filter.misc.ImplAverageDownSample2;
import boofcv.alg.filter.misc.ImplAverageDownSampleN;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageInt8;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.MultiSpectral;

public class AverageDownSampleOps {
    public static int downSampleSize(int length, int squareWidth) {
        int ret = length / squareWidth;
        if (length % squareWidth != 0) {
            ++ret;
        }
        return ret;
    }

    public static void reshapeDown(ImageBase image, int inputWidth, int inputHeight, int squareWidth) {
        int w = AverageDownSampleOps.downSampleSize(inputWidth, squareWidth);
        int h = AverageDownSampleOps.downSampleSize(inputHeight, squareWidth);
        image.reshape(w, h);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void down(ImageSingleBand input, int sampleWidth, ImageSingleBand output) {
        if (sampleWidth == 2) {
            if (input instanceof ImageUInt8) {
                ImplAverageDownSample2.down((ImageUInt8)input, (ImageInt8)output);
                return;
            } else if (input instanceof ImageSInt8) {
                ImplAverageDownSample2.down((ImageSInt8)input, (ImageInt8)output);
                return;
            } else if (input instanceof ImageUInt16) {
                ImplAverageDownSample2.down((ImageUInt16)input, (ImageInt16)output);
                return;
            } else if (input instanceof ImageSInt16) {
                ImplAverageDownSample2.down((ImageSInt16)input, (ImageInt16)output);
                return;
            } else if (input instanceof ImageSInt32) {
                ImplAverageDownSample2.down((ImageSInt32)input, (ImageSInt32)output);
                return;
            } else if (input instanceof ImageFloat32) {
                ImplAverageDownSample2.down((ImageFloat32)input, (ImageFloat32)output);
                return;
            } else {
                if (!(input instanceof ImageFloat64)) throw new IllegalArgumentException("Unknown image type");
                ImplAverageDownSample2.down((ImageFloat64)input, (ImageFloat64)output);
            }
            return;
        } else if (input instanceof ImageUInt8) {
            ImplAverageDownSampleN.down((ImageUInt8)input, sampleWidth, (ImageInt8)output);
            return;
        } else if (input instanceof ImageSInt8) {
            ImplAverageDownSampleN.down((ImageSInt8)input, sampleWidth, (ImageInt8)output);
            return;
        } else if (input instanceof ImageUInt16) {
            ImplAverageDownSampleN.down((ImageUInt16)input, sampleWidth, (ImageInt16)output);
            return;
        } else if (input instanceof ImageSInt16) {
            ImplAverageDownSampleN.down((ImageSInt16)input, sampleWidth, (ImageInt16)output);
            return;
        } else if (input instanceof ImageSInt32) {
            ImplAverageDownSampleN.down((ImageSInt32)input, sampleWidth, (ImageSInt32)output);
            return;
        } else if (input instanceof ImageFloat32) {
            ImplAverageDownSampleN.down((ImageFloat32)input, sampleWidth, (ImageFloat32)output);
            return;
        } else {
            if (!(input instanceof ImageFloat64)) throw new IllegalArgumentException("Unknown image type");
            ImplAverageDownSampleN.down((ImageFloat64)input, sampleWidth, (ImageFloat64)output);
        }
    }

    public static <T extends ImageSingleBand> void down(MultiSpectral<T> input, int sampleWidth, MultiSpectral<T> output) {
        for (int band = 0; band < input.getNumBands(); ++band) {
            AverageDownSampleOps.down(input.getBand(band), sampleWidth, output.getBand(band));
        }
    }

    public static void down(ImageUInt8 input, int sampleWidth, ImageInt8 output) {
        if (sampleWidth == 2) {
            ImplAverageDownSample2.down(input, output);
        } else {
            ImplAverageDownSampleN.down(input, sampleWidth, output);
        }
    }

    public static void down(ImageSInt8 input, int sampleWidth, ImageInt8 output) {
        if (sampleWidth == 2) {
            ImplAverageDownSample2.down(input, output);
        } else {
            ImplAverageDownSampleN.down(input, sampleWidth, output);
        }
    }

    public static void down(ImageUInt16 input, int sampleWidth, ImageInt16 output) {
        if (sampleWidth == 2) {
            ImplAverageDownSample2.down(input, output);
        } else {
            ImplAverageDownSampleN.down(input, sampleWidth, output);
        }
    }

    public static void down(ImageSInt16 input, int sampleWidth, ImageInt16 output) {
        if (sampleWidth == 2) {
            ImplAverageDownSample2.down(input, output);
        } else {
            ImplAverageDownSampleN.down(input, sampleWidth, output);
        }
    }

    public static void down(ImageSInt32 input, int sampleWidth, ImageSInt32 output) {
        if (sampleWidth == 2) {
            ImplAverageDownSample2.down(input, output);
        } else {
            ImplAverageDownSampleN.down(input, sampleWidth, output);
        }
    }

    public static void down(ImageFloat32 input, int sampleWidth, ImageFloat32 output) {
        if (sampleWidth == 2) {
            ImplAverageDownSample2.down(input, output);
        } else {
            ImplAverageDownSampleN.down(input, sampleWidth, output);
        }
    }

    public static void down(ImageFloat64 input, int sampleWidth, ImageFloat64 output) {
        if (sampleWidth == 2) {
            ImplAverageDownSample2.down(input, output);
        } else {
            ImplAverageDownSampleN.down(input, sampleWidth, output);
        }
    }
}

