/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.f;

import boofcv.alg.geo.LowLevelMultiViewOps;
import boofcv.alg.geo.f.FundamentalLinear;
import boofcv.struct.geo.AssociatedPair;
import java.util.List;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.SingularValueDecomposition;
import org.ejml.ops.SingularOps;
import org.ejml.ops.SpecializedOps;

public class FundamentalLinear8
extends FundamentalLinear {
    public FundamentalLinear8(boolean computeFundamental) {
        super(computeFundamental);
    }

    public boolean process(List<AssociatedPair> points, DenseMatrix64F solution) {
        if (points.size() < 8) {
            throw new IllegalArgumentException("Must be at least 8 points. Was only " + points.size());
        }
        LowLevelMultiViewOps.computeNormalization(points, this.N1, this.N2);
        this.createA(points, this.A);
        if (this.process(this.A, solution)) {
            return false;
        }
        this.undoNormalizationF(solution, this.N1, this.N2);
        if (this.computeFundamental) {
            return this.projectOntoFundamentalSpace(solution);
        }
        return this.projectOntoEssential(solution);
    }

    protected boolean process(DenseMatrix64F A, DenseMatrix64F F) {
        if (!this.svdNull.decompose((Matrix64F)A)) {
            return true;
        }
        if (A.numRows > 8) {
            SingularOps.nullVector((SingularValueDecomposition)this.svdNull, (boolean)true, (DenseMatrix64F)F);
        } else {
            DenseMatrix64F V = (DenseMatrix64F)this.svdNull.getV(null, false);
            SpecializedOps.subvector((RowD1Matrix64F)V, (int)0, (int)8, (int)V.numCols, (boolean)false, (int)0, (RowD1Matrix64F)F);
        }
        return false;
    }
}

