/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.pose;

import boofcv.abst.geo.optimization.ResidualsCodecToMatrix;
import boofcv.alg.geo.pose.PnPRodriguesCodec;
import boofcv.alg.geo.pose.PnPStereoJacobianRodrigues;
import boofcv.alg.geo.pose.PnPStereoResidualReprojection;
import boofcv.alg.geo.pose.RefinePnPStereo;
import boofcv.alg.geo.pose.Se3ToStereoPoseCodec;
import boofcv.struct.sfm.Stereo2D3D;
import boofcv.struct.sfm.StereoPose;
import georegression.struct.se.Se3_F64;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelCodec;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.functions.FunctionNtoMxN;

public class PnPStereoRefineRodrigues
implements RefinePnPStereo {
    private ModelCodec<Se3_F64> motionCodec = new PnPRodriguesCodec();
    private ResidualsCodecToMatrix<StereoPose, Stereo2D3D> func;
    private PnPStereoJacobianRodrigues jacobian = new PnPStereoJacobianRodrigues();
    private StereoPose stereoPose = new StereoPose();
    private double[] param;
    protected UnconstrainedLeastSquares minimizer;
    private int maxIterations;
    private double convergenceTol;

    public PnPStereoRefineRodrigues(double convergenceTol, int maxIterations) {
        this.maxIterations = maxIterations;
        this.convergenceTol = convergenceTol;
        this.minimizer = FactoryOptimization.leastSquareLevenberg((double)0.001);
        Se3ToStereoPoseCodec paramModel = new Se3ToStereoPoseCodec(this.motionCodec);
        this.func = new ResidualsCodecToMatrix<StereoPose, Stereo2D3D>(paramModel, new PnPStereoResidualReprojection(), this.stereoPose);
        this.param = new double[paramModel.getParamLength()];
    }

    @Override
    public void setLeftToRight(Se3_F64 leftToRight) {
        this.stereoPose.cam0ToCam1 = leftToRight;
        this.jacobian.setLeftToRight(leftToRight);
    }

    @Override
    public boolean process(Se3_F64 worldToLeft, List<Stereo2D3D> obs, Se3_F64 refinedWorldToLeft) {
        this.motionCodec.encode((Object)worldToLeft, this.param);
        this.func.setObservations(obs);
        this.jacobian.setObservations(obs);
        this.minimizer.setFunction(this.func, (FunctionNtoMxN)this.jacobian);
        this.minimizer.initialize(this.param, 0.0, this.convergenceTol * (double)obs.size());
        for (int i = 0; i < this.maxIterations && !this.minimizer.iterate(); ++i) {
        }
        this.motionCodec.decode(this.minimizer.getParameters(), (Object)refinedWorldToLeft);
        return true;
    }
}

