/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate;

import boofcv.alg.interpolate.InterpolatePixel;
import boofcv.alg.interpolate.array.PolynomialNevilleFixed_F32;
import boofcv.struct.image.ImageSingleBand;

public abstract class PolynomialPixel<T extends ImageSingleBand>
implements InterpolatePixel<T> {
    protected T image;
    protected int M;
    protected int offM;
    protected float[] horiz;
    protected float[] vert;
    protected float min;
    protected float max;
    protected PolynomialNevilleFixed_F32 interp1D;

    public PolynomialPixel(int maxDegree, float min, float max) {
        this.M = maxDegree;
        this.min = min;
        this.max = max;
        this.horiz = new float[maxDegree];
        this.vert = new float[maxDegree];
        this.offM = maxDegree % 2 == 0 ? 1 : 0;
        this.interp1D = new PolynomialNevilleFixed_F32(maxDegree);
    }

    @Override
    public void setImage(T image) {
        this.image = image;
    }

    @Override
    public T getImage() {
        return this.image;
    }

    @Override
    public boolean isInSafeBounds(float x, float y) {
        int x0 = (int)x - this.M / 2 + this.offM;
        int x1 = x0 + this.M;
        int y0 = (int)y - this.M / 2 + this.offM;
        int y1 = y0 + this.M;
        return x0 >= 0 && y0 >= 0 && x1 < ((ImageSingleBand)this.image).width && y1 < ((ImageSingleBand)this.image).height;
    }

    @Override
    public int getUnsafeBorderX() {
        return this.M;
    }

    @Override
    public int getUnsafeBorderY() {
        return this.M;
    }
}

