/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate.impl;

import boofcv.alg.interpolate.BilinearPixel;
import boofcv.struct.image.ImageFloat32;

public class ImplBilinearPixel_F32
extends BilinearPixel<ImageFloat32> {
    public ImplBilinearPixel_F32() {
    }

    public ImplBilinearPixel_F32(ImageFloat32 orig) {
        this.setImage(orig);
    }

    @Override
    public float get_unsafe(float x, float y) {
        int xt = (int)x;
        int yt = (int)y;
        float ax = x - (float)xt;
        float ay = y - (float)yt;
        int index = ((ImageFloat32)this.orig).startIndex + yt * this.stride + xt;
        int dx = xt == this.width - 1 ? 0 : 1;
        int dy = yt == this.height - 1 ? 0 : this.stride;
        float[] data = ((ImageFloat32)this.orig).data;
        float val = (1.0f - ax) * (1.0f - ay) * data[index];
        val += ax * (1.0f - ay) * data[index + dx];
        val += ax * ay * data[index + dx + dy];
        return val += (1.0f - ax) * ay * data[index + dy];
    }

    @Override
    public float get(float x, float y) {
        int xt = (int)x;
        int yt = (int)y;
        if (xt < 0 || yt < 0 || xt >= this.width || yt >= this.height) {
            throw new IllegalArgumentException("Point is outside of the image");
        }
        float ax = x - (float)xt;
        float ay = y - (float)yt;
        int index = ((ImageFloat32)this.orig).startIndex + yt * this.stride + xt;
        int dx = xt == this.width - 1 ? 0 : 1;
        int dy = yt == this.height - 1 ? 0 : this.stride;
        float[] data = ((ImageFloat32)this.orig).data;
        float val = (1.0f - ax) * (1.0f - ay) * data[index];
        val += ax * (1.0f - ay) * data[index + dx];
        val += ax * ay * data[index + dx + dy];
        return val += (1.0f - ax) * ay * data[index + dy];
    }
}

