/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.detect.line;

import boofcv.abst.feature.detect.line.DetectLineHoughFoot;
import boofcv.abst.feature.detect.line.DetectLineHoughFootSubimage;
import boofcv.abst.feature.detect.line.DetectLineHoughPolar;
import boofcv.abst.feature.detect.line.DetectLineSegmentsGridRansac;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.detect.line.ConnectLinesGrid;
import boofcv.alg.feature.detect.line.GridRansacLineDetector;
import boofcv.alg.feature.detect.line.gridline.Edgel;
import boofcv.alg.feature.detect.line.gridline.GridLineModelDistance;
import boofcv.alg.feature.detect.line.gridline.GridLineModelFitter;
import boofcv.alg.feature.detect.line.gridline.ImplGridRansacLineDetector_F32;
import boofcv.alg.feature.detect.line.gridline.ImplGridRansacLineDetector_S16;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSingleBand;
import georegression.struct.line.LinePolar2D_F32;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.fitting.modelset.ransac.Ransac;

public class FactoryDetectLineAlgs {
    public static <I extends ImageSingleBand, D extends ImageSingleBand> DetectLineSegmentsGridRansac<I, D> lineRansac(int regionSize, double thresholdEdge, double thresholdAngle, boolean connectLines, Class<I> imageType, Class<D> derivType) {
        GridRansacLineDetector alg;
        ImageGradient<I, D> gradient = FactoryDerivative.sobel(imageType, derivType);
        GridLineModelDistance distance = new GridLineModelDistance((float)thresholdAngle);
        GridLineModelFitter fitter = new GridLineModelFitter((float)thresholdAngle);
        Ransac matcher = new Ransac(123123L, (ModelGenerator)fitter, (DistanceFromModel)distance, 25, 1.0);
        if (derivType == ImageFloat32.class) {
            alg = new ImplGridRansacLineDetector_F32(regionSize, 10, (ModelMatcher<LinePolar2D_F32, Edgel>)matcher);
        } else if (derivType == ImageSInt16.class) {
            alg = new ImplGridRansacLineDetector_S16(regionSize, 10, (ModelMatcher<LinePolar2D_F32, Edgel>)matcher);
        } else {
            throw new IllegalArgumentException("Unsupported derivative type");
        }
        ConnectLinesGrid connect = null;
        if (connectLines) {
            connect = new ConnectLinesGrid(0.031415926535897934, 1.0, 8.0);
        }
        return new DetectLineSegmentsGridRansac<I, ImageFloat32>(alg, connect, gradient, thresholdEdge, imageType, derivType);
    }

    public static <I extends ImageSingleBand, D extends ImageSingleBand> DetectLineHoughFoot<I, D> houghFoot(int localMaxRadius, int minCounts, int minDistanceFromOrigin, float thresholdEdge, int maxLines, Class<I> imageType, Class<D> derivType) {
        ImageGradient<I, D> gradient = FactoryDerivative.sobel(imageType, derivType);
        return new DetectLineHoughFoot<I, D>(localMaxRadius, minCounts, minDistanceFromOrigin, thresholdEdge, maxLines, gradient);
    }

    public static <I extends ImageSingleBand, D extends ImageSingleBand> DetectLineHoughFootSubimage<I, D> houghFootSub(int localMaxRadius, int minCounts, int minDistanceFromOrigin, float thresholdEdge, int maxLines, int totalHorizontalDivisions, int totalVerticalDivisions, Class<I> imageType, Class<D> derivType) {
        ImageGradient<I, D> gradient = FactoryDerivative.sobel(imageType, derivType);
        return new DetectLineHoughFootSubimage<I, D>(localMaxRadius, minCounts, minDistanceFromOrigin, thresholdEdge, totalHorizontalDivisions, totalVerticalDivisions, maxLines, gradient);
    }

    public static <I extends ImageSingleBand, D extends ImageSingleBand> DetectLineHoughPolar<I, D> houghPolar(int localMaxRadius, int minCounts, double resolutionRange, double resolutionAngle, float thresholdEdge, int maxLines, Class<I> imageType, Class<D> derivType) {
        ImageGradient<I, D> gradient = FactoryDerivative.sobel(imageType, derivType);
        return new DetectLineHoughPolar<I, D>(localMaxRadius, minCounts, resolutionRange, resolutionAngle, thresholdEdge, maxLines, gradient);
    }
}

