/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.filter.kernel;

import boofcv.alg.filter.kernel.KernelMath;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.convolve.Kernel1D;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_F64;
import boofcv.struct.convolve.Kernel1D_I32;
import boofcv.struct.convolve.Kernel2D;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_F64;
import boofcv.struct.convolve.Kernel2D_I32;
import boofcv.struct.convolve.KernelBase;
import boofcv.struct.image.ImageSingleBand;
import org.ddogleg.stats.UtilGaussian;

public class FactoryKernelGaussian {
    public static float MIN_FRAC = 0.01f;

    public static <T extends KernelBase> T gaussian(Class<T> kernelType, double sigma, int radius) {
        if (Kernel1D_F32.class == kernelType) {
            return FactoryKernelGaussian.gaussian(1, true, 32, sigma, radius);
        }
        if (Kernel1D_I32.class == kernelType) {
            return FactoryKernelGaussian.gaussian(1, false, 32, sigma, radius);
        }
        if (Kernel2D_I32.class == kernelType) {
            return FactoryKernelGaussian.gaussian(2, false, 32, sigma, radius);
        }
        if (Kernel2D_F32.class == kernelType) {
            return FactoryKernelGaussian.gaussian(2, true, 32, sigma, radius);
        }
        throw new RuntimeException("Unknown kernel type");
    }

    public static <T extends ImageSingleBand, K extends Kernel1D> K gaussian1D(Class<T> imageType, double sigma, int radius) {
        boolean isFloat = GeneralizedImageOps.isFloatingPoint(imageType);
        return (K)((Kernel1D)FactoryKernelGaussian.gaussian(1, isFloat, 32, sigma, radius));
    }

    public static <T extends ImageSingleBand, K extends Kernel2D> K gaussian2D(Class<T> imageType, double sigma, int radius) {
        boolean isFloat = GeneralizedImageOps.isFloatingPoint(imageType);
        return (K)((Kernel2D)FactoryKernelGaussian.gaussian(2, isFloat, 32, sigma, radius));
    }

    public static <T extends KernelBase> T gaussian(int DOF, boolean isFloat, int numBits, double sigma, int radius) {
        if (radius <= 0) {
            radius = FactoryKernelGaussian.radiusForSigma(sigma, 0);
        } else if (sigma <= 0.0) {
            sigma = FactoryKernelGaussian.sigmaForRadius(radius, 0);
        }
        if (DOF == 2) {
            if (numBits == 32) {
                Kernel2D_F32 k = FactoryKernelGaussian.gaussian2D_F32(sigma, radius, isFloat);
                if (isFloat) {
                    return (T)k;
                }
                return (T)KernelMath.convert(k, MIN_FRAC);
            }
            if (numBits == 64) {
                Kernel2D_F64 k = FactoryKernelGaussian.gaussian2D_F64(sigma, radius, isFloat);
                if (isFloat) {
                    return (T)k;
                }
                throw new IllegalArgumentException("64bit int kernels supported");
            }
            throw new IllegalArgumentException("Bits must be 32 or 64");
        }
        if (DOF == 1) {
            if (numBits == 32) {
                Kernel1D_F32 k = FactoryKernelGaussian.gaussian1D_F32(sigma, radius, isFloat);
                if (isFloat) {
                    return (T)k;
                }
                return (T)KernelMath.convert(k, MIN_FRAC);
            }
            throw new IllegalArgumentException("Bits must be 32 ");
        }
        throw new IllegalArgumentException("DOF not supported");
    }

    public static <T extends ImageSingleBand, K extends Kernel1D> K derivativeI(Class<T> imageType, int order, double sigma, int radius) {
        boolean isFloat = GeneralizedImageOps.isFloatingPoint(imageType);
        return (K)FactoryKernelGaussian.derivative(order, isFloat, sigma, radius);
    }

    public static <T extends Kernel1D> T derivativeK(Class<T> kernelType, int order, double sigma, int radius) {
        if (Kernel1D_F32.class == kernelType) {
            return FactoryKernelGaussian.derivative(order, true, sigma, radius);
        }
        return FactoryKernelGaussian.derivative(order, false, sigma, radius);
    }

    public static <T extends Kernel1D> T derivative(int order, boolean isFloat, double sigma, int radius) {
        if (order == 0) {
            return (T)((Kernel1D)FactoryKernelGaussian.gaussian(1, isFloat, 32, sigma, radius));
        }
        if (radius <= 0) {
            radius = FactoryKernelGaussian.radiusForSigma(sigma, order);
        } else if (sigma <= 0.0) {
            sigma = FactoryKernelGaussian.sigmaForRadius(radius, order);
        }
        Kernel1D_F32 k = FactoryKernelGaussian.derivative1D_F32(order, sigma, radius, true);
        if (isFloat) {
            return (T)k;
        }
        return (T)KernelMath.convert(k, MIN_FRAC);
    }

    protected static Kernel1D_F32 gaussian1D_F32(double sigma, int radius, boolean normalize) {
        Kernel1D_F32 ret = new Kernel1D_F32(radius * 2 + 1);
        float[] gaussian = ret.data;
        int index = 0;
        for (int i = radius; i >= -radius; --i) {
            gaussian[index++] = (float)UtilGaussian.computePDF((double)0.0, (double)sigma, (double)i);
        }
        if (normalize) {
            KernelMath.normalizeSumToOne(ret);
        }
        return ret;
    }

    protected static Kernel1D_F64 gaussian1D_F64(double sigma, int radius, boolean normalize) {
        Kernel1D_F64 ret = new Kernel1D_F64(radius * 2 + 1);
        double[] gaussian = ret.data;
        int index = 0;
        for (int i = radius; i >= -radius; --i) {
            gaussian[index++] = UtilGaussian.computePDF((double)0.0, (double)sigma, (double)i);
        }
        if (normalize) {
            KernelMath.normalizeSumToOne(ret);
        }
        return ret;
    }

    protected static Kernel2D_F32 gaussian2D_F32(double sigma, int radius, boolean normalize) {
        Kernel1D_F32 kernel1D = FactoryKernelGaussian.gaussian1D_F32(sigma, radius, false);
        Kernel2D_F32 ret = KernelMath.convolve(kernel1D, kernel1D);
        if (normalize) {
            KernelMath.normalizeSumToOne(ret);
        }
        return ret;
    }

    protected static Kernel2D_F64 gaussian2D_F64(double sigma, int radius, boolean normalize) {
        Kernel1D_F64 kernel1D = FactoryKernelGaussian.gaussian1D_F64(sigma, radius, false);
        Kernel2D_F64 ret = KernelMath.convolve(kernel1D, kernel1D);
        if (normalize) {
            KernelMath.normalizeSumToOne(ret);
        }
        return ret;
    }

    protected static Kernel1D_F32 derivative1D_F32(int order, double sigma, int radius, boolean normalize) {
        Kernel1D_F32 ret = new Kernel1D_F32(radius * 2 + 1);
        float[] gaussian = ret.data;
        int index = 0;
        switch (order) {
            case 1: {
                int i;
                for (i = radius; i >= -radius; --i) {
                    gaussian[index++] = (float)UtilGaussian.derivative1((double)0.0, (double)sigma, (double)i);
                }
                break;
            }
            case 2: {
                int i;
                for (i = radius; i >= -radius; --i) {
                    gaussian[index++] = (float)UtilGaussian.derivative2((double)0.0, (double)sigma, (double)i);
                }
                break;
            }
            case 3: {
                int i;
                for (i = radius; i >= -radius; --i) {
                    gaussian[index++] = (float)UtilGaussian.derivative3((double)0.0, (double)sigma, (double)i);
                }
                break;
            }
            case 4: {
                int i;
                for (i = radius; i >= -radius; --i) {
                    gaussian[index++] = (float)UtilGaussian.derivative4((double)0.0, (double)sigma, (double)i);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Only derivatives of order 1 to 4 are supported");
            }
        }
        if (normalize) {
            int i;
            double sum = 0.0;
            for (i = radius; i >= -radius; --i) {
                sum += UtilGaussian.computePDF((double)0.0, (double)sigma, (double)i);
            }
            i = 0;
            while (i < gaussian.length) {
                int n = i++;
                gaussian[n] = (float)((double)gaussian[n] / sum);
            }
        }
        return ret;
    }

    public static double sigmaForRadius(double radius, int order) {
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Radius must be > 0");
        }
        return (radius * 2.0 + 1.0) / (5.0 + 0.8 * (double)order);
    }

    public static int radiusForSigma(double sigma, int order) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("Sigma must be > 0");
        }
        return (int)Math.ceil(((5.0 + 0.8 * (double)order) * sigma - 1.0) / 2.0);
    }

    public static Kernel2D_F64 gaussianWidth(double sigma, int width) {
        if (sigma <= 0.0) {
            sigma = FactoryKernelGaussian.sigmaForRadius(width / 2, 0);
        } else if (width <= 0) {
            throw new IllegalArgumentException("Must specify the width since it doesn't know if it should be even or odd");
        }
        if (width % 2 == 0) {
            int r = width / 2 - 1;
            Kernel2D_F64 ret = new Kernel2D_F64(width);
            double sum = 0.0;
            for (int y = 0; y < width; ++y) {
                double dy = y <= r ? (double)Math.abs(y - r) + 0.5 : (double)Math.abs(y - r - 1) + 0.5;
                for (int x = 0; x < width; ++x) {
                    double dx = x <= r ? (double)Math.abs(x - r) + 0.5 : (double)Math.abs(x - r - 1) + 0.5;
                    double d = Math.sqrt(dx * dx + dy * dy);
                    double val = UtilGaussian.computePDF((double)0.0, (double)sigma, (double)d);
                    ret.set(x, y, val);
                    sum += val;
                }
            }
            int i = 0;
            while (i < ret.data.length) {
                int n = i++;
                ret.data[n] = ret.data[n] / sum;
            }
            return ret;
        }
        return FactoryKernelGaussian.gaussian2D_F64(sigma, width / 2, true);
    }
}

