/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.sfm;

import boofcv.alg.interpolate.InterpolatePixel;
import boofcv.alg.interpolate.TypeInterpolate;
import boofcv.alg.sfm.overhead.CreateSyntheticOverheadView;
import boofcv.alg.sfm.overhead.CreateSyntheticOverheadViewMS;
import boofcv.alg.sfm.overhead.CreateSyntheticOverheadViewS;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;

public class FactorySfmMisc {
    public static <T extends ImageBase> CreateSyntheticOverheadView<T> createOverhead(ImageDataType<T> imageType) {
        Class classType = imageType.getDataType().getImageClass();
        switch (imageType.getFamily()) {
            case SINGLE_BAND: {
                InterpolatePixel interp = FactoryInterpolation.bilinearPixel(classType);
                return new CreateSyntheticOverheadViewS(interp);
            }
            case MULTI_SPECTRAL: {
                return new CreateSyntheticOverheadViewMS(TypeInterpolate.BILINEAR, imageType.getNumBands(), classType);
            }
        }
        throw new IllegalArgumentException((Object)((Object)imageType.getFamily()) + " is not supported");
    }
}

