/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.sfm;

import boofcv.abst.feature.associate.AssociateDescTo2D;
import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.associate.EnforceUniqueByScore;
import boofcv.abst.feature.associate.ScoreAssociation;
import boofcv.abst.feature.detdesc.DetectDescribeMulti;
import boofcv.abst.feature.disparity.StereoDisparitySparse;
import boofcv.abst.feature.tracker.ExtractTrackDescription;
import boofcv.abst.feature.tracker.PointTracker;
import boofcv.abst.feature.tracker.PointTrackerTwoPass;
import boofcv.abst.geo.Estimate1ofPnP;
import boofcv.abst.geo.EstimateNofPnP;
import boofcv.abst.geo.RefinePnP;
import boofcv.abst.geo.TriangulateTwoViewsCalibrated;
import boofcv.abst.sfm.DepthSparse3D_to_PixelTo3D;
import boofcv.abst.sfm.d2.ImageMotion2D;
import boofcv.abst.sfm.d3.DepthVisualOdometry;
import boofcv.abst.sfm.d3.MonoOverhead_to_MonocularPlaneVisualOdometry;
import boofcv.abst.sfm.d3.MonoPlaneInfinity_to_MonocularPlaneVisualOdometry;
import boofcv.abst.sfm.d3.MonocularPlaneVisualOdometry;
import boofcv.abst.sfm.d3.MonocularPlaneVisualOdometryScaleInput;
import boofcv.abst.sfm.d3.StereoVisualOdometry;
import boofcv.abst.sfm.d3.StereoVisualOdometryScaleInput;
import boofcv.abst.sfm.d3.VisOdomPixelDepthPnP_to_DepthVisualOdometry;
import boofcv.abst.sfm.d3.WrapVisOdomDualTrackPnP;
import boofcv.abst.sfm.d3.WrapVisOdomPixelDepthPnP;
import boofcv.abst.sfm.d3.WrapVisOdomQuadPnP;
import boofcv.alg.feature.associate.AssociateMaxDistanceNaive;
import boofcv.alg.feature.associate.AssociateStereo2D;
import boofcv.alg.geo.pose.PnPDistanceReprojectionSq;
import boofcv.alg.geo.pose.PnPStereoDistanceReprojectionSq;
import boofcv.alg.geo.pose.PnPStereoEstimator;
import boofcv.alg.geo.pose.PnPStereoRefineRodrigues;
import boofcv.alg.sfm.DepthSparse3D;
import boofcv.alg.sfm.StereoSparse3D;
import boofcv.alg.sfm.d3.VisOdomDualTrackPnP;
import boofcv.alg.sfm.d3.VisOdomMonoOverheadMotion2D;
import boofcv.alg.sfm.d3.VisOdomMonoPlaneInfinity;
import boofcv.alg.sfm.d3.VisOdomPixelDepthPnP;
import boofcv.alg.sfm.d3.VisOdomQuadPnP;
import boofcv.alg.sfm.robust.DistancePlane2DToPixelSq;
import boofcv.alg.sfm.robust.EstimatorToGenerator;
import boofcv.alg.sfm.robust.GenerateSe2_PlanePtPixel;
import boofcv.alg.sfm.robust.GeoModelRefineToModelFitter;
import boofcv.factory.feature.associate.FactoryAssociation;
import boofcv.factory.geo.EnumPNP;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.factory.geo.FactoryTriangulate;
import boofcv.factory.sfm.FactoryMotion2D;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.geo.GeoModelEstimator1;
import boofcv.struct.geo.GeoModelRefine;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.sfm.PlanePtPixel;
import boofcv.struct.sfm.Stereo2D3D;
import georegression.struct.se.Se2_F64;
import georegression.struct.se.Se3_F64;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.ModelFitter;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.fitting.modelset.ransac.Ransac;

public class FactoryVisualOdometry {
    public static <T extends ImageSingleBand> MonocularPlaneVisualOdometry<T> monoPlaneInfinity(int thresholdAdd, int thresholdRetire, double inlierPixelTol, int ransacIterations, PointTracker<T> tracker, ImageDataType<T> imageType) {
        double ransacTOL = inlierPixelTol * inlierPixelTol;
        DistancePlane2DToPixelSq distance = new DistancePlane2DToPixelSq();
        GenerateSe2_PlanePtPixel generator = new GenerateSe2_PlanePtPixel();
        Ransac motion = new Ransac(2323L, (ModelGenerator)generator, (DistanceFromModel)distance, ransacIterations, ransacTOL);
        VisOdomMonoPlaneInfinity<T> alg = new VisOdomMonoPlaneInfinity<T>(thresholdAdd, thresholdRetire, inlierPixelTol, (ModelMatcher<Se2_F64, PlanePtPixel>)motion, tracker);
        return new MonoPlaneInfinity_to_MonocularPlaneVisualOdometry<T>(alg, distance, generator, imageType);
    }

    public static <T extends ImageSingleBand> MonocularPlaneVisualOdometry<T> monoPlaneOverhead(double cellSize, double maxCellsPerPixel, double mapHeightFraction, double inlierGroundTol, int ransacIterations, int thresholdRetire, int absoluteMinimumTracks, double respawnTrackFraction, double respawnCoverageFraction, PointTracker<T> tracker, ImageDataType<T> imageType) {
        ImageMotion2D<T, Se2_F64> motion2D = FactoryMotion2D.createMotion2D(ransacIterations, inlierGroundTol * inlierGroundTol, thresholdRetire, absoluteMinimumTracks, respawnTrackFraction, respawnCoverageFraction, false, tracker, new Se2_F64());
        VisOdomMonoOverheadMotion2D<T> alg = new VisOdomMonoOverheadMotion2D<T>(cellSize, maxCellsPerPixel, mapHeightFraction, motion2D, imageType);
        return new MonoOverhead_to_MonocularPlaneVisualOdometry<T>(alg, imageType);
    }

    public static <T extends ImageSingleBand> StereoVisualOdometry<T> stereoDepth(double inlierPixelTol, int thresholdAdd, int thresholdRetire, int ransacIterations, int refineIterations, boolean doublePass, StereoDisparitySparse<T> sparseDisparity, PointTrackerTwoPass<T> tracker, Class<T> imageType) {
        StereoSparse3D<T> pixelTo3D = new StereoSparse3D<T>(sparseDisparity, imageType);
        Estimate1ofPnP estimator = FactoryMultiView.computePnP_1(EnumPNP.P3P_FINSTERWALDER, -1, 2);
        PnPDistanceReprojectionSq distance = new PnPDistanceReprojectionSq();
        EstimatorToGenerator<Se3_F64, Point2D3D> generator = new EstimatorToGenerator<Se3_F64, Point2D3D>((GeoModelEstimator1)estimator){

            public Se3_F64 createModelInstance() {
                return new Se3_F64();
            }
        };
        double ransacTOL = inlierPixelTol * inlierPixelTol;
        Ransac motion = new Ransac(2323L, (ModelGenerator)generator, (DistanceFromModel)distance, ransacIterations, ransacTOL);
        RefinePnP refine = null;
        if (refineIterations > 0) {
            refine = FactoryMultiView.refinePnP(1.0E-12, refineIterations);
        }
        VisOdomPixelDepthPnP<T> alg = new VisOdomPixelDepthPnP<T>(thresholdAdd, thresholdRetire, doublePass, (ModelMatcher<Se3_F64, Point2D3D>)motion, pixelTo3D, refine, tracker, null, null);
        return new WrapVisOdomPixelDepthPnP<T>(alg, pixelTo3D, distance, imageType);
    }

    public static <Vis extends ImageSingleBand, Depth extends ImageSingleBand> DepthVisualOdometry<Vis, Depth> depthDepthPnP(double inlierPixelTol, int thresholdAdd, int thresholdRetire, int ransacIterations, int refineIterations, boolean doublePass, DepthSparse3D<Depth> sparseDepth, PointTrackerTwoPass<Vis> tracker, Class<Vis> visualType, Class<Depth> depthType) {
        DepthSparse3D_to_PixelTo3D<Depth> pixelTo3D = new DepthSparse3D_to_PixelTo3D<Depth>(sparseDepth);
        Estimate1ofPnP estimator = FactoryMultiView.computePnP_1(EnumPNP.P3P_FINSTERWALDER, -1, 2);
        PnPDistanceReprojectionSq distance = new PnPDistanceReprojectionSq();
        EstimatorToGenerator<Se3_F64, Point2D3D> generator = new EstimatorToGenerator<Se3_F64, Point2D3D>((GeoModelEstimator1)estimator){

            public Se3_F64 createModelInstance() {
                return new Se3_F64();
            }
        };
        double ransacTOL = inlierPixelTol * inlierPixelTol;
        Ransac motion = new Ransac(2323L, (ModelGenerator)generator, (DistanceFromModel)distance, ransacIterations, ransacTOL);
        RefinePnP refine = null;
        if (refineIterations > 0) {
            refine = FactoryMultiView.refinePnP(1.0E-12, refineIterations);
        }
        VisOdomPixelDepthPnP<Vis> alg = new VisOdomPixelDepthPnP<Vis>(thresholdAdd, thresholdRetire, doublePass, (ModelMatcher<Se3_F64, Point2D3D>)motion, pixelTo3D, refine, tracker, null, null);
        return new VisOdomPixelDepthPnP_to_DepthVisualOdometry<Vis, Depth>(sparseDepth, alg, distance, ImageDataType.single(visualType), depthType);
    }

    public static <T extends ImageSingleBand, Desc extends TupleDesc> StereoVisualOdometry<T> stereoDualTrackerPnP(int thresholdAdd, int thresholdRetire, double inlierPixelTol, double epipolarPixelTol, int ransacIterations, int refineIterations, PointTracker<T> trackerLeft, PointTracker<T> trackerRight, Class<T> imageType) {
        AssociateStereo2D associateStereo;
        if (!(trackerLeft instanceof ExtractTrackDescription) || !(trackerRight instanceof ExtractTrackDescription)) {
            throw new IllegalArgumentException("Both trackers must implement TrackDescription");
        }
        EstimateNofPnP pnp = FactoryMultiView.computePnP_N(EnumPNP.P3P_FINSTERWALDER, -1);
        PnPDistanceReprojectionSq distanceMono = new PnPDistanceReprojectionSq();
        PnPStereoDistanceReprojectionSq distanceStereo = new PnPStereoDistanceReprojectionSq();
        PnPStereoEstimator pnpStereo = new PnPStereoEstimator(pnp, distanceMono, 0);
        EstimatorToGenerator<Se3_F64, Stereo2D3D> generator = new EstimatorToGenerator<Se3_F64, Stereo2D3D>((GeoModelEstimator1)pnpStereo){

            public Se3_F64 createModelInstance() {
                return new Se3_F64();
            }
        };
        double ransacTOL = 2.0 * inlierPixelTol * inlierPixelTol;
        Ransac motion = new Ransac(2323L, (ModelGenerator)generator, (DistanceFromModel)distanceStereo, ransacIterations, ransacTOL);
        PnPStereoRefineRodrigues refinePnP = null;
        GeoModelRefineToModelFitter<Se3_F64, Stereo2D3D> refine = null;
        ExtractTrackDescription extractor = (ExtractTrackDescription)((Object)trackerLeft);
        Class descType = extractor.getDescriptionType();
        ScoreAssociation scorer = FactoryAssociation.defaultScore(descType);
        AssociateDescription2D associateUnique = associateStereo = new AssociateStereo2D(scorer, epipolarPixelTol, descType);
        if (!associateStereo.uniqueDestination() || !associateStereo.uniqueSource()) {
            associateUnique = new EnforceUniqueByScore.Describe2D(associateStereo, true, true);
        }
        if (refineIterations > 0) {
            refinePnP = new PnPStereoRefineRodrigues(1.0E-12, refineIterations);
            refine = new GeoModelRefineToModelFitter<Se3_F64, Stereo2D3D>((GeoModelRefine)refinePnP){

                public Se3_F64 createModelInstance() {
                    return new Se3_F64();
                }
            };
        }
        TriangulateTwoViewsCalibrated triangulate = FactoryTriangulate.twoGeometric();
        VisOdomDualTrackPnP alg = new VisOdomDualTrackPnP(thresholdAdd, thresholdRetire, epipolarPixelTol, trackerLeft, trackerRight, associateUnique, triangulate, (ModelMatcher<Se3_F64, Stereo2D3D>)motion, (ModelFitter<Se3_F64, Stereo2D3D>)refine);
        return new WrapVisOdomDualTrackPnP<T>(pnpStereo, distanceMono, distanceStereo, associateStereo, alg, refinePnP, imageType);
    }

    public static <T extends ImageSingleBand, Desc extends TupleDesc> StereoVisualOdometry<T> stereoQuadPnP(double inlierPixelTol, double epipolarPixelTol, double maxDistanceF2F, double maxAssociationError, int ransacIterations, int refineIterations, DetectDescribeMulti<T, Desc> detector, Class<T> imageType) {
        EstimateNofPnP pnp = FactoryMultiView.computePnP_N(EnumPNP.P3P_FINSTERWALDER, -1);
        PnPDistanceReprojectionSq distanceMono = new PnPDistanceReprojectionSq();
        PnPStereoDistanceReprojectionSq distanceStereo = new PnPStereoDistanceReprojectionSq();
        PnPStereoEstimator pnpStereo = new PnPStereoEstimator(pnp, distanceMono, 0);
        EstimatorToGenerator<Se3_F64, Stereo2D3D> generator = new EstimatorToGenerator<Se3_F64, Stereo2D3D>((GeoModelEstimator1)pnpStereo){

            public Se3_F64 createModelInstance() {
                return new Se3_F64();
            }
        };
        double ransacTOL = 2.0 * inlierPixelTol * inlierPixelTol;
        Ransac motion = new Ransac(2323L, (ModelGenerator)generator, (DistanceFromModel)distanceStereo, ransacIterations, ransacTOL);
        PnPStereoRefineRodrigues refinePnP = null;
        GeoModelRefineToModelFitter<Se3_F64, Stereo2D3D> refine = null;
        if (refineIterations > 0) {
            refinePnP = new PnPStereoRefineRodrigues(1.0E-12, refineIterations);
            refine = new GeoModelRefineToModelFitter<Se3_F64, Stereo2D3D>((GeoModelRefine)refinePnP){

                public Se3_F64 createModelInstance() {
                    return new Se3_F64();
                }
            };
        }
        Class descType = detector.getDescriptionType();
        ScoreAssociation scorer = FactoryAssociation.defaultScore(descType);
        AssociateDescription2D assocSame = maxDistanceF2F > 0.0 ? new AssociateMaxDistanceNaive(scorer, true, maxAssociationError, maxDistanceF2F) : new AssociateDescTo2D(FactoryAssociation.greedy(scorer, maxAssociationError, true));
        AssociateStereo2D associateStereo = new AssociateStereo2D(scorer, epipolarPixelTol, descType);
        TriangulateTwoViewsCalibrated triangulate = FactoryTriangulate.twoGeometric();
        associateStereo.setThreshold(maxAssociationError);
        VisOdomQuadPnP<T, Desc> alg = new VisOdomQuadPnP<T, Desc>(detector, assocSame, associateStereo, triangulate, (ModelMatcher<Se3_F64, Stereo2D3D>)motion, (ModelFitter<Se3_F64, Stereo2D3D>)refine);
        return new WrapVisOdomQuadPnP<T, Desc>(alg, refinePnP, associateStereo, distanceStereo, distanceMono, imageType);
    }

    public static <T extends ImageBase> StereoVisualOdometry<T> scaleInput(StereoVisualOdometry<T> vo, double scaleFactor) {
        return new StereoVisualOdometryScaleInput<T>(vo, scaleFactor);
    }

    public static <T extends ImageBase> MonocularPlaneVisualOdometry<T> scaleInput(MonocularPlaneVisualOdometry<T> vo, double scaleFactor) {
        return new MonocularPlaneVisualOdometryScaleInput<T>(vo, scaleFactor);
    }
}

