/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.transform.ii;

import boofcv.alg.transform.ii.impl.SparseIntegralGradient_NoBorder_F32;
import boofcv.alg.transform.ii.impl.SparseIntegralGradient_NoBorder_I32;
import boofcv.alg.transform.ii.impl.SparseIntegralHaar_NoBorder_F32;
import boofcv.alg.transform.ii.impl.SparseIntegralHaar_NoBorder_I32;
import boofcv.alg.transform.ii.impl.SparseIntegralSample_F32;
import boofcv.alg.transform.ii.impl.SparseIntegralSample_I32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.sparse.SparseScaleGradient;
import boofcv.struct.sparse.SparseScaleSample;

public class FactorySparseIntegralFilters {
    public static <T extends ImageSingleBand> SparseScaleSample<T> sample(int radius, Class<T> imageType) {
        if (imageType == ImageFloat32.class) {
            return new SparseIntegralSample_F32(radius);
        }
        if (imageType == ImageSInt32.class) {
            return new SparseIntegralSample_I32(radius);
        }
        throw new IllegalArgumentException("Unsupported image type: " + imageType.getSimpleName());
    }

    public static <T extends ImageSingleBand> SparseScaleGradient<T, ?> gradient(int radius, Class<T> imageType) {
        if (imageType == ImageFloat32.class) {
            return new SparseIntegralGradient_NoBorder_F32(radius);
        }
        if (imageType == ImageSInt32.class) {
            return new SparseIntegralGradient_NoBorder_I32(radius);
        }
        throw new IllegalArgumentException("Unsupported image type: " + imageType.getSimpleName());
    }

    public static <T extends ImageSingleBand> SparseScaleGradient<T, ?> haar(int radius, Class<T> imageType) {
        if (imageType == ImageFloat32.class) {
            return new SparseIntegralHaar_NoBorder_F32(radius);
        }
        if (imageType == ImageSInt32.class) {
            return new SparseIntegralHaar_NoBorder_I32(radius);
        }
        throw new IllegalArgumentException("Unsupported image type: " + imageType.getSimpleName());
    }
}

