/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.d3;

import boofcv.gui.d3.ColorPoint3D;
import boofcv.struct.FastQueue;
import georegression.geometry.GeometryMath_F64;
import georegression.geometry.RotationMatrixGenerator;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.ejml.data.DenseMatrix64F;

public class PointCloudViewer
extends JPanel
implements MouseMotionListener,
MouseListener,
MouseWheelListener,
KeyListener {
    FastQueue<ColorPoint3D> cloud = new FastQueue<ColorPoint3D>(200, ColorPoint3D.class, true);
    DenseMatrix64F K;
    double focalLengthX;
    double focalLengthY;
    double centerX;
    double centerY;
    double offsetX;
    double offsetY;
    double offsetZ;
    Pixel[] data = new Pixel[0];
    public int tiltAngle = 0;
    public double radius = 5.0;
    public double pixelToDistance;
    int prevX;
    int prevY;

    public PointCloudViewer(double pixelToDistance) {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        this.setFocusable(true);
        this.requestFocus();
        this.pixelToDistance = pixelToDistance;
    }

    public PointCloudViewer(DenseMatrix64F K, double pixelToDistance) {
        this(pixelToDistance);
        this.configure(K);
    }

    public void configure(DenseMatrix64F K) {
        this.K = K;
        this.focalLengthX = K.get(0, 0);
        this.focalLengthY = K.get(1, 1);
        this.centerX = K.get(0, 2);
        this.centerY = K.get(1, 2);
    }

    public void reset() {
        this.cloud.reset();
    }

    public void addPoint(double x, double y, double z, int rgb) {
        ColorPoint3D p = this.cloud.grow();
        p.set(x, y, z);
        p.rgb = rgb;
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.projectScene();
        int width = this.getWidth();
        int h = this.getHeight();
        int r = 2;
        int w = r * 2 + 1;
        Graphics2D g2 = (Graphics2D)g;
        int index = 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < width; ++x) {
                Pixel p = this.data[index++];
                if (p.rgb == -1) continue;
                g2.setColor(new Color(p.rgb));
                g2.fillRect(x - r, y - r, w, w);
            }
        }
    }

    private void projectScene() {
        int i;
        int h;
        int w = this.getWidth();
        int N = w * (h = this.getHeight());
        if (this.data.length < N) {
            this.data = new Pixel[N];
            for (i = 0; i < N; ++i) {
                this.data[i] = new Pixel();
            }
        } else {
            for (i = 0; i < N; ++i) {
                this.data[i].reset();
            }
        }
        Se3_F64 pose = this.createWorldToCamera();
        Point3D_F64 cameraPt = new Point3D_F64();
        Point2D_F64 pixel = new Point2D_F64();
        for (int i2 = 0; i2 < this.cloud.size(); ++i2) {
            ColorPoint3D p = this.cloud.get(i2);
            SePointOps_F64.transform((Se3_F64)pose, (Point3D_F64)p, (Point3D_F64)cameraPt);
            pixel.x = cameraPt.x / cameraPt.z;
            pixel.y = cameraPt.y / cameraPt.z;
            GeometryMath_F64.mult((DenseMatrix64F)this.K, (GeoTuple2D_F64)pixel, (GeoTuple2D_F64)pixel);
            int x = (int)pixel.x;
            int y = (int)pixel.y;
            if (x < 0 || y < 0 || x >= w || y >= h) continue;
            Pixel d = this.data[y * w + x];
            if (!(d.height > cameraPt.z)) continue;
            d.height = cameraPt.z;
            d.rgb = p.rgb;
        }
    }

    public Se3_F64 createWorldToCamera() {
        Vector3D_F64 rotPt = new Vector3D_F64(this.offsetX, this.offsetY, this.offsetZ);
        double radians = (double)this.tiltAngle * Math.PI / 180.0;
        DenseMatrix64F R = RotationMatrixGenerator.eulerXYZ((double)radians, (double)0.0, (double)0.0, null);
        Se3_F64 a = new Se3_F64(R, rotPt);
        return a;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 72) {
            this.offsetZ = 0.0;
            this.offsetY = 0.0;
            this.offsetX = 0.0;
            this.tiltAngle = 0;
            this.repaint();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.offsetZ -= (double)e.getWheelRotation() * this.pixelToDistance;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.prevX = e.getX();
        this.prevY = e.getY();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public synchronized void mouseDragged(MouseEvent e) {
        int deltaX = e.getX() - this.prevX;
        int deltaY = e.getY() - this.prevY;
        if (SwingUtilities.isRightMouseButton(e)) {
            this.offsetZ -= (double)deltaY * this.pixelToDistance;
        } else if (e.isShiftDown() || SwingUtilities.isMiddleMouseButton(e)) {
            this.tiltAngle += deltaY;
        } else {
            this.offsetX += (double)deltaX * this.pixelToDistance;
            this.offsetY += (double)deltaY * this.pixelToDistance;
        }
        this.prevX = e.getX();
        this.prevY = e.getY();
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private static class Pixel {
        public double height;
        public int rgb;

        private Pixel() {
            this.reset();
        }

        public void reset() {
            this.height = Double.MAX_VALUE;
            this.rgb = -1;
        }
    }
}

